/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.treeWithCheckedNodes;

import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.treeWithCheckedNodes.TreeNodeState;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedState<T> {
    private final Set<T> mySelected;
    private final SLRUMap<T, TreeNodeState> myCache;
    private final int mySelectedSize;

    public SelectedState(int selectedSize, int queueSize) {
        this.mySelectedSize = selectedSize;
        assert (queueSize > 0);
        this.mySelected = new HashSet();
        this.myCache = new SLRUMap(queueSize, queueSize);
    }

    @Nullable
    public TreeNodeState get(T node) {
        if (this.mySelected.contains(node)) {
            return TreeNodeState.SELECTED;
        }
        return (TreeNodeState)((Object)this.myCache.get(node));
    }

    public void clear(T node) {
        this.myCache.remove(node);
        this.mySelected.remove(node);
    }

    public void clearAllCachedMatching(Processor<? super T> processor) {
        Set entries = this.myCache.entrySet();
        for (Map.Entry entry : entries) {
            if (!processor.process(entry.getKey())) continue;
            this.myCache.remove(entry.getKey());
        }
    }

    public void remove(T node) {
        this.mySelected.remove(node);
        this.myCache.remove(node);
    }

    @NotNull
    public TreeNodeState putAndPass(T node, @NotNull TreeNodeState state) {
        if (state == null) {
            SelectedState.$$$reportNull$$$0(0);
        }
        if (TreeNodeState.SELECTED.equals((Object)state)) {
            this.mySelected.add(node);
            this.myCache.remove(node);
        } else {
            this.mySelected.remove(node);
            this.myCache.put(node, (Object)state);
        }
        TreeNodeState treeNodeState = state;
        if (treeNodeState == null) {
            SelectedState.$$$reportNull$$$0(1);
        }
        return treeNodeState;
    }

    public boolean canAddSelection() {
        return this.mySelected.size() < this.mySelectedSize;
    }

    public Set<T> getSelected() {
        return Collections.unmodifiableSet(this.mySelected);
    }

    public void setSelection(Collection<? extends T> files2) {
        this.mySelected.clear();
        this.mySelected.addAll(files2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/treeWithCheckedNodes/SelectedState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/treeWithCheckedNodes/SelectedState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "putAndPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putAndPass";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

