/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectBaseDirectory;
import java.util.Collections;

public class PlatformVcsDetector
implements ProjectComponent {
    private final Project myProject;
    private final ProjectLevelVcsManagerImpl myVcsManager;

    public PlatformVcsDetector(Project project, ProjectLevelVcsManagerImpl vcsManager) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
            Runnable runnable = () -> {
                AbstractVcs vcs;
                VirtualFile file = ProjectBaseDirectory.getInstance((Project)this.myProject).getBaseDir(this.myProject.getBaseDir());
                if (this.myVcsManager.needAutodetectMappings() && (vcs = this.myVcsManager.findVersioningVcs(file)) != null && vcs != this.myVcsManager.getVcsFor(file)) {
                    this.myVcsManager.setAutoDirectoryMappings(Collections.singletonList(new VcsDirectoryMapping(file.getPath(), vcs.getName())));
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable, o -> !this.myProject.isOpen() || this.myProject.isDisposed());
        }));
    }
}

