/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.ByteContent;
import com.intellij.history.Label;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUpdatedDiffActionProvider
implements AnActionExtensionProvider {
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(0);
        }
        return this.isVisible(e.getDataContext());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(1);
        }
        DataContext dc = e.getDataContext();
        Presentation presentation = e.getPresentation();
        presentation.setDescription("Show diff with version before update");
        presentation.setEnabled(this.isVisible(dc) && this.isEnabled(dc));
    }

    private boolean isVisible(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        return project != null && VcsDataKeys.LABEL_BEFORE.getData(dc) != null && VcsDataKeys.LABEL_AFTER.getData(dc) != null;
    }

    private boolean isEnabled(DataContext dc) {
        Iterable iterable = (Iterable)VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.getData(dc);
        return iterable != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dc;
        if (e == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(2);
        }
        if (!this.isVisible(dc = e.getDataContext()) || !this.isEnabled(dc)) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        Iterable iterable = (Iterable)e.getRequiredData(VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE);
        Label before = (Label)e.getRequiredData(VcsDataKeys.LABEL_BEFORE);
        Label after = (Label)e.getRequiredData(VcsDataKeys.LABEL_AFTER);
        FilePath selectedUrl = (FilePath)VcsDataKeys.UPDATE_VIEW_SELECTED_PATH.getData(dc);
        ChangeDiffRequestChain requestChain = ShowUpdatedDiffActionProvider.createDiffRequestChain(project, before, after, iterable, selectedUrl);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)requestChain, DiffDialogHints.FRAME);
    }

    public static ChangeDiffRequestChain createDiffRequestChain(@Nullable Project project, @NotNull Label before, @NotNull Label after, @NotNull Iterable<? extends Pair<FilePath, FileStatus>> iterable, @Nullable FilePath selectedPath) {
        if (before == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(3);
        }
        if (after == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(4);
        }
        if (iterable == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(5);
        }
        ArrayList<MyDiffRequestProducer> requests = new ArrayList<MyDiffRequestProducer>();
        int selected = -1;
        for (Pair<FilePath, FileStatus> pair : iterable) {
            if (selected == -1 && ((FilePath)pair.first).equals(selectedPath)) {
                selected = requests.size();
            }
            requests.add(new MyDiffRequestProducer(project, before, after, (FilePath)pair.first, (FileStatus)pair.second));
        }
        if (selected == -1) {
            selected = 0;
        }
        return new ChangeDiffRequestChain(requests, selected);
    }

    @NotNull
    private static byte[] loadContent(@NotNull FilePath path, @NotNull Label label) throws DiffRequestProducerException {
        ByteContent byteContent;
        if (path == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(6);
        }
        if (label == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(7);
        }
        if ((byteContent = label.getByteContent(path.getPath())) == null || byteContent.isDirectory() || byteContent.getBytes() == null) {
            throw new DiffRequestProducerException("Can't load content");
        }
        byte[] byArray = byteContent.getBytes();
        if (byArray == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(8);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDiffRequestChain";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadContent";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDiffRequestProducer
    implements DiffRequestProducer,
    ChangeDiffRequestChain.Producer {
        @Nullable
        private final Project myProject;
        @NotNull
        private final Label myBefore;
        @NotNull
        private final Label myAfter;
        @NotNull
        private final FileStatus myFileStatus;
        @NotNull
        private final FilePath myFilePath;

        MyDiffRequestProducer(@Nullable Project project, @NotNull Label before, @NotNull Label after, @NotNull FilePath filePath, @NotNull FileStatus fileStatus) {
            if (before == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (after == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (fileStatus == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myBefore = before;
            this.myAfter = after;
            this.myFileStatus = fileStatus;
            this.myFilePath = filePath;
        }

        @NotNull
        public String getName() {
            String string = this.myFilePath.getPresentableUrl();
            if (string == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(5);
            }
            return filePath;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myFileStatus;
            if (fileStatus == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(6);
            }
            return fileStatus;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            SimpleDiffRequest simpleDiffRequest;
            block8: {
                if (context == null) {
                    MyDiffRequestProducer.$$$reportNull$$$0(7);
                }
                if (indicator == null) {
                    MyDiffRequestProducer.$$$reportNull$$$0(8);
                }
                try {
                    EmptyContent content2;
                    EmptyContent content1;
                    DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
                    if (FileStatus.ADDED.equals(this.myFileStatus)) {
                        content1 = contentFactory.createEmpty();
                    } else {
                        byte[] bytes1 = ShowUpdatedDiffActionProvider.loadContent(this.myFilePath, this.myBefore);
                        content1 = contentFactory.createFromBytes(this.myProject, bytes1, this.myFilePath);
                    }
                    if (FileStatus.DELETED.equals(this.myFileStatus)) {
                        content2 = contentFactory.createEmpty();
                    } else {
                        byte[] bytes2 = ShowUpdatedDiffActionProvider.loadContent(this.myFilePath, this.myAfter);
                        content2 = contentFactory.createFromBytes(this.myProject, bytes2, this.myFilePath);
                    }
                    String title = DiffRequestFactoryImpl.getContentTitle((FilePath)this.myFilePath);
                    simpleDiffRequest = new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, "Before update", "After update");
                    if (simpleDiffRequest != null) break block8;
                }
                catch (IOException e) {
                    throw new DiffRequestProducerException("Can't load content", (Throwable)e);
                }
                MyDiffRequestProducer.$$$reportNull$$$0(9);
            }
            return simpleDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "before";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "after";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileStatus";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestProducer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestProducer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

