/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diff.DiffContentFactoryImpl;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsFileStatusProvider
implements FileStatusProvider,
VcsBaseContentProvider {
    private final Project myProject;
    private final FileStatusManagerImpl myFileStatusManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final ChangeListManager myChangeListManager;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final VcsConfiguration myConfiguration;
    private final VcsBaseContentProvider[] myAdditionalProviders;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsFileStatusProvider");

    public VcsFileStatusProvider(Project project, FileStatusManagerImpl fileStatusManager, ProjectLevelVcsManager vcsManager, ChangeListManager changeListManager, VcsDirtyScopeManager dirtyScopeManager, VcsConfiguration configuration) {
        this.myProject = project;
        this.myFileStatusManager = fileStatusManager;
        this.myVcsManager = vcsManager;
        this.myChangeListManager = changeListManager;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.myConfiguration = configuration;
        this.myFileStatusManager.setFileStatusProvider((FileStatusProvider)this);
        this.myAdditionalProviders = (VcsBaseContentProvider[])VcsBaseContentProvider.EP_NAME.getExtensions((AreaInstance)project);
        changeListManager.addChangeListListener((ChangeListListener)new ChangeListAdapter(){

            public void changeListAdded(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListRemoved(ChangeList list) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListUpdateDone() {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }
        });
    }

    private void fileStatusesChanged() {
        this.myFileStatusManager.fileStatusesChanged();
    }

    @NotNull
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        AbstractVcs vcs;
        if (virtualFile == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(0);
        }
        if ((vcs = this.myVcsManager.getVcsFor(virtualFile)) == null) {
            if (ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                FileStatus fileStatus = FileStatus.SUPPRESSED;
                if (fileStatus == null) {
                    VcsFileStatusProvider.$$$reportNull$$$0(1);
                }
                return fileStatus;
            }
            FileStatus fileStatus = FileStatusManagerImpl.getDefaultStatus((VirtualFile)virtualFile);
            if (fileStatus == null) {
                VcsFileStatusProvider.$$$reportNull$$$0(2);
            }
            return fileStatus;
        }
        FileStatus status = this.myChangeListManager.getStatus(virtualFile);
        if (status == FileStatus.NOT_CHANGED && VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            FileStatus fileStatus = FileStatus.MODIFIED;
            if (fileStatus == null) {
                VcsFileStatusProvider.$$$reportNull$$$0(3);
            }
            return fileStatus;
        }
        if (status == FileStatus.NOT_CHANGED) {
            FileStatus fileStatus = FileStatusManagerImpl.getDefaultStatus((VirtualFile)virtualFile);
            if (fileStatus == null) {
                VcsFileStatusProvider.$$$reportNull$$$0(4);
            }
            return fileStatus;
        }
        FileStatus fileStatus = status;
        if (fileStatus == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(5);
        }
        return fileStatus;
    }

    private static boolean isDocumentModified(VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return false;
        }
        return FileDocumentManager.getInstance().isFileModified(virtualFile);
    }

    public void refreshFileStatusFromDocument(@NotNull VirtualFile virtualFile, @NotNull Document doc) {
        FileStatus cachedStatus;
        if (virtualFile == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(6);
        }
        if (doc == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(7);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("refreshFileStatusFromDocument: file.getModificationStamp()=" + virtualFile.getModificationStamp() + ", document.getModificationStamp()=" + doc.getModificationStamp());
        }
        if ((cachedStatus = this.myFileStatusManager.getCachedStatus(virtualFile)) == null || cachedStatus == FileStatus.NOT_CHANGED || !VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            RollbackEnvironment rollbackEnvironment;
            AbstractVcs vcs = this.myVcsManager.getVcsFor(virtualFile);
            if (vcs == null) {
                return;
            }
            if (cachedStatus == FileStatus.MODIFIED && !VcsFileStatusProvider.isDocumentModified(virtualFile) && !((ReadonlyStatusHandlerImpl)ReadonlyStatusHandlerImpl.getInstance((Project)this.myProject)).getState().SHOW_DIALOG && (rollbackEnvironment = vcs.getRollbackEnvironment()) != null) {
                rollbackEnvironment.rollbackIfUnchanged(virtualFile);
            }
            this.myFileStatusManager.fileStatusChanged(virtualFile);
            ChangeProvider cp = vcs.getChangeProvider();
            if (cp != null && cp.isModifiedDocumentTrackingRequired()) {
                this.myDirtyScopeManager.fileDirty(virtualFile);
            }
        }
    }

    @NotNull
    public ThreeState getNotChangedDirectoryParentingStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(8);
        }
        ThreeState threeState = this.myConfiguration.SHOW_DIRTY_RECURSIVELY ? this.myChangeListManager.haveChangesUnder(virtualFile) : ThreeState.NO;
        if (threeState == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(9);
        }
        return threeState;
    }

    @Override
    @Nullable
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file) {
        if (file == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(10);
        }
        if (!this.isHandledByVcs(file)) {
            VcsBaseContentProvider provider = this.findProviderFor(file);
            return provider == null ? null : provider.getBaseRevision(file);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        Change change = changeListManager.getChange(file);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            return beforeRevision == null ? null : new BaseContentImpl(beforeRevision);
        }
        FileStatus status = changeListManager.getStatus(file);
        if (status == FileStatus.HIJACKED) {
            DiffProvider diffProvider;
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file);
            DiffProvider diffProvider2 = diffProvider = vcs != null ? vcs.getDiffProvider() : null;
            if (diffProvider != null) {
                VcsRevisionNumber currentRevision = diffProvider.getCurrentRevision(file);
                return currentRevision == null ? null : new HijackedBaseContent(diffProvider, file, currentRevision);
            }
        }
        return null;
    }

    @Nullable
    private VcsBaseContentProvider findProviderFor(@NotNull VirtualFile file) {
        if (file == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(11);
        }
        for (VcsBaseContentProvider support : this.myAdditionalProviders) {
            if (!support.isSupported(file)) continue;
            return support;
        }
        return null;
    }

    @Override
    public boolean isSupported(@NotNull VirtualFile file) {
        if (file == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(12);
        }
        return this.isHandledByVcs(file) || this.findProviderFor(file) != null;
    }

    private boolean isHandledByVcs(@NotNull VirtualFile file) {
        if (file == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(13);
        }
        return file.isInLocalFileSystem() && this.myVcsManager.getVcsFor(file) != null;
    }

    @Nullable
    private static String loadContentRevision(@NotNull ContentRevision contentRevision) {
        if (contentRevision == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(14);
        }
        try {
            if (contentRevision instanceof ByteBackedContentRevision) {
                byte[] revisionContent = ((ByteBackedContentRevision)contentRevision).getContentAsBytes();
                FilePath filePath = contentRevision.getFile();
                if (revisionContent != null) {
                    Charset charset = DiffContentFactoryImpl.guessCharset((byte[])revisionContent, (FilePath)filePath);
                    return CharsetToolkit.decodeString((byte[])revisionContent, (Charset)charset);
                }
                return null;
            }
            return contentRevision.getContent();
        }
        catch (VcsException ex) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotChangedDirectoryParentingStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileStatus";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshFileStatusFromDocument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNotChangedDirectoryParentingStatus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBaseRevision";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findProviderFor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isHandledByVcs";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadContentRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HijackedBaseContent
    implements VcsBaseContentProvider.BaseContent {
        @NotNull
        private final DiffProvider myDiffProvider;
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final VcsRevisionNumber myRevision;

        HijackedBaseContent(@NotNull DiffProvider diffProvider, @NotNull VirtualFile file, @NotNull VcsRevisionNumber revision) {
            if (diffProvider == null) {
                HijackedBaseContent.$$$reportNull$$$0(0);
            }
            if (file == null) {
                HijackedBaseContent.$$$reportNull$$$0(1);
            }
            if (revision == null) {
                HijackedBaseContent.$$$reportNull$$$0(2);
            }
            this.myDiffProvider = diffProvider;
            this.myFile = file;
            this.myRevision = revision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevision;
            if (vcsRevisionNumber == null) {
                HijackedBaseContent.$$$reportNull$$$0(3);
            }
            return vcsRevisionNumber;
        }

        @Override
        @Nullable
        public String loadContent() {
            ContentRevision contentRevision = this.myDiffProvider.createFileContent(this.myRevision, this.myFile);
            if (contentRevision == null) {
                return null;
            }
            return VcsFileStatusProvider.loadContentRevision(contentRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider$HijackedBaseContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider$HijackedBaseContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BaseContentImpl
    implements VcsBaseContentProvider.BaseContent {
        @NotNull
        private final ContentRevision myContentRevision;

        BaseContentImpl(@NotNull ContentRevision contentRevision) {
            if (contentRevision == null) {
                BaseContentImpl.$$$reportNull$$$0(0);
            }
            this.myContentRevision = contentRevision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myContentRevision.getRevisionNumber();
            if (vcsRevisionNumber == null) {
                BaseContentImpl.$$$reportNull$$$0(1);
            }
            return vcsRevisionNumber;
        }

        @Override
        @Nullable
        public String loadContent() {
            return VcsFileStatusProvider.loadContentRevision(this.myContentRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRevision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider$BaseContentImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider$BaseContentImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

