/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanelKt;
import com.intellij.ui.SimpleColoredComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0004J\b\u0010\u001a\u001a\u00020\u000eH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel;", "", "myInfoCalculator", "Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel$InfoCalculator;", "(Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel$InfoCalculator;)V", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "getComponent", "()Lcom/intellij/ui/SimpleColoredComponent;", "isPanelEmpty", "", "()Z", "myRootPanel", "append", "", "included", "", "fileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "labelName", "", "appendAdded", "new", "unversioned", "appendLegend", "appendSpace", "update", "InfoCalculator", "intellij.platform.vcs.impl"})
public class CommitLegendPanel {
    private final SimpleColoredComponent myRootPanel;
    private final InfoCalculator myInfoCalculator;

    private final boolean isPanelEmpty() {
        return !this.myRootPanel.iterator().hasNext();
    }

    @NotNull
    public final SimpleColoredComponent getComponent() {
        return this.myRootPanel;
    }

    public void update() {
        this.myRootPanel.clear();
        this.appendLegend();
    }

    private final void appendLegend() {
        InfoCalculator infoCalculator = this.myInfoCalculator;
        boolean bl = false;
        boolean bl2 = false;
        InfoCalculator $this$with = infoCalculator;
        boolean bl3 = false;
        this.appendAdded($this$with.getIncludedNew(), $this$with.getIncludedUnversioned());
        int n = $this$with.getIncludedModified();
        FileStatus fileStatus = FileStatus.MODIFIED;
        Intrinsics.checkExpressionValueIsNotNull((Object)fileStatus, (String)"FileStatus.MODIFIED");
        String string = VcsBundle.message((String)"commit.legend.modified", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message(\"commit.legend.modified\")");
        this.append(n, fileStatus, string);
        int n2 = $this$with.getIncludedDeleted();
        FileStatus fileStatus2 = FileStatus.DELETED;
        Intrinsics.checkExpressionValueIsNotNull((Object)fileStatus2, (String)"FileStatus.DELETED");
        String string2 = VcsBundle.message((String)"commit.legend.deleted", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message(\"commit.legend.deleted\")");
        this.append(n2, fileStatus2, string2);
    }

    protected final void append(int included, @NotNull FileStatus fileStatus, @NotNull String labelName) {
        Intrinsics.checkParameterIsNotNull((Object)fileStatus, (String)"fileStatus");
        Intrinsics.checkParameterIsNotNull((Object)labelName, (String)"labelName");
        if (included > 0) {
            if (!this.isPanelEmpty()) {
                this.appendSpace();
            }
            this.myRootPanel.append("" + included + ' ' + labelName, CommitLegendPanelKt.access$getAttributes$p(fileStatus));
        }
    }

    private final void appendAdded(int n, int unversioned) {
        if (n > 0 || unversioned > 0) {
            String string;
            if (!this.isPanelEmpty()) {
                this.appendSpace();
            }
            String labelName = VcsBundle.message((String)"commit.legend.new", (Object[])new Object[0]);
            if (n > 0 && unversioned > 0) {
                string = "" + n + '+' + unversioned + ' ' + labelName;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                int n2 = Math.max(n, unversioned);
                string = stringBuilder.append(n2).append(' ').append(labelName).toString();
            }
            String text = string;
            FileStatus fileStatus = FileStatus.ADDED;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileStatus, (String)"FileStatus.ADDED");
            this.myRootPanel.append(text, CommitLegendPanelKt.access$getAttributes$p(fileStatus));
        }
    }

    protected final void appendSpace() {
        this.myRootPanel.append("   ");
    }

    public CommitLegendPanel(@NotNull InfoCalculator myInfoCalculator) {
        Intrinsics.checkParameterIsNotNull((Object)myInfoCalculator, (String)"myInfoCalculator");
        this.myInfoCalculator = myInfoCalculator;
        this.myRootPanel = new SimpleColoredComponent();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0012\u0010\f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0012\u0010\u000e\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005R\u0012\u0010\u0010\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0012\u0010\u0012\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel$InfoCalculator;", "", "deleted", "", "getDeleted", "()I", "includedDeleted", "getIncludedDeleted", "includedModified", "getIncludedModified", "includedNew", "getIncludedNew", "includedUnversioned", "getIncludedUnversioned", "modified", "getModified", "new", "getNew", "unversioned", "getUnversioned", "intellij.platform.vcs.impl"})
    public static interface InfoCalculator {
        public int getNew();

        public int getModified();

        public int getDeleted();

        public int getUnversioned();

        public int getIncludedNew();

        public int getIncludedModified();

        public int getIncludedDeleted();

        public int getIncludedUnversioned();
    }
}

