/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0016\u001a\u00020\u00172\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\u00020\u00172\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/vcs/changes/actions/MoveChangesHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "changedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChangedFiles", "()Ljava/util/List;", "changes", "Lcom/intellij/openapi/vcs/changes/Change;", "getChanges", "isEmpty", "", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "unversionedFiles", "getUnversionedFiles", "addChanges", "", "", "([Lcom/intellij/openapi/vcs/changes/Change;)V", "addChangesForFiles", "files", "([Lcom/intellij/openapi/vfs/VirtualFile;)V", "addChangesUnder", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.platform.vcs.impl"})
final class MoveChangesHandler {
    private final ChangeListManager changeListManager;
    @NotNull
    private final List<VirtualFile> unversionedFiles;
    @NotNull
    private final List<VirtualFile> changedFiles;
    @NotNull
    private final List<Change> changes;
    @NotNull
    private final Project project;

    @NotNull
    public final List<VirtualFile> getUnversionedFiles() {
        return this.unversionedFiles;
    }

    @NotNull
    public final List<VirtualFile> getChangedFiles() {
        return this.changedFiles;
    }

    @NotNull
    public final List<Change> getChanges() {
        return this.changes;
    }

    public final boolean isEmpty() {
        return this.changes.isEmpty() && this.unversionedFiles.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void addChanges(@Nullable Change[] changes2) {
        void $this$orEmpty$iv;
        Change[] changeArray = changes2;
        Collection collection = this.changes;
        boolean $i$f$orEmpty = false;
        Change[] changeArray2 = $this$orEmpty$iv;
        if (changeArray2 == null) {
            boolean $i$f$emptyArray = false;
            changeArray2 = new Change[]{};
        }
        void var6_6 = changeArray2;
        CollectionsKt.addAll((Collection)collection, (Object[])var6_6);
    }

    public final void addChangesForFiles(@Nullable VirtualFile[] files2) {
        VirtualFile[] $this$orEmpty$iv = files2;
        boolean $i$f$orEmpty = false;
        VirtualFile[] virtualFileArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            virtualFileArray = new VirtualFile[]{};
        }
        for (VirtualFile file : virtualFileArray) {
            Change change = this.changeListManager.getChange(file);
            if (change == null) {
                FileStatus status;
                Intrinsics.checkExpressionValueIsNotNull((Object)this.changeListManager.getStatus(file), (String)"changeListManager.getStatus(file)");
                if (Intrinsics.areEqual((Object)FileStatus.UNKNOWN, (Object)status)) {
                    this.unversionedFiles.add(file);
                    this.changedFiles.add(file);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)FileStatus.NOT_CHANGED, (Object)status) || !file.isDirectory()) continue;
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"VcsUtil.getFilePath(file)");
                this.addChangesUnder(filePath);
                continue;
            }
            FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
            if (afterPath != null && afterPath.isDirectory()) {
                this.addChangesUnder(afterPath);
                continue;
            }
            this.changes.add(change);
            this.changedFiles.add(file);
        }
    }

    private final void addChangesUnder(FilePath path) {
        Iterator iterator = this.changeListManager.getChangesIn(path).iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            VirtualFile file;
            Change change;
            Change change2 = change = (Change)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)change2, (String)"change");
            this.changes.add(change2);
            FilePath filePath = ChangesUtil.getAfterPath((Change)change);
            Object object = file = filePath != null ? filePath.getVirtualFile() : null;
            if (file == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile;
            boolean bl3 = false;
            this.changedFiles.add(it);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public MoveChangesHandler(@NotNull Project project) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        this.changeListManager = changeListManager;
        MoveChangesHandler moveChangesHandler = this;
        boolean bl = false;
        moveChangesHandler.unversionedFiles = list = (List)new ArrayList();
        moveChangesHandler = this;
        bl = false;
        moveChangesHandler.changedFiles = list = (List)new ArrayList();
        moveChangesHandler = this;
        bl = false;
        moveChangesHandler.changes = list = (List)new ArrayList();
    }
}

