/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsGuess {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManagerImpl myVcsManager;

    public VcsGuess(@NotNull Project project) {
        if (project == null) {
            VcsGuess.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myVcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Nullable
    public AbstractVcs getVcsForDirty(@NotNull VirtualFile file) {
        if (file == null) {
            VcsGuess.$$$reportNull$$$0(1);
        }
        if (file.isInLocalFileSystem() && this.isFileInIndex(file)) {
            return this.myVcsManager.getVcsFor(file);
        }
        return null;
    }

    @Nullable
    public AbstractVcs getVcsForDirty(@NotNull FilePath filePath) {
        if (filePath == null) {
            VcsGuess.$$$reportNull$$$0(2);
        }
        if (filePath.isNonLocal()) {
            return null;
        }
        VirtualFile validParent = ChangesUtil.findValidParentAccurately((FilePath)filePath);
        if (validParent != null && this.isFileInIndex(validParent)) {
            return this.myVcsManager.getVcsFor(validParent);
        }
        return null;
    }

    private boolean isFileInIndex(@NotNull VirtualFile validParent) {
        if (validParent == null) {
            VcsGuess.$$$reportNull$$$0(3);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            return this.myVcsManager.isFileInContent(validParent);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validParent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsGuess";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVcsForDirty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileInIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

