/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.ui.MyDoNotAskOptionForPush;
import com.intellij.dvcs.push.ui.PushActionBase;
import com.intellij.dvcs.push.ui.PushUtils;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0014J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dvcs/push/ui/ForcePushAction;", "Lcom/intellij/dvcs/push/ui/PushActionBase;", "()V", "actionPerformed", "", "project", "Lcom/intellij/openapi/project/Project;", "ui", "Lcom/intellij/dvcs/push/ui/VcsPushUi;", "confirmForcePush", "", "getDescription", "", "enabled", "isEnabled", "intellij.platform.vcs.dvcs.impl"})
public final class ForcePushAction
extends PushActionBase {
    @Override
    protected void actionPerformed(@NotNull Project project, @NotNull VcsPushUi ui2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)ui2, (String)"ui");
        if (this.confirmForcePush(project, ui2)) {
            ui2.push(true);
        }
    }

    @Override
    protected boolean isEnabled(@NotNull VcsPushUi ui2) {
        Intrinsics.checkParameterIsNotNull((Object)ui2, (String)"ui");
        return ui2.canPush() && PushUtils.getProhibitedTarget(ui2) == null;
    }

    @Override
    @Nullable
    protected String getDescription(@NotNull VcsPushUi ui2, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)ui2, (String)"ui");
        PushTarget prohibitedTarget = PushUtils.getProhibitedTarget(ui2);
        return !enabled && prohibitedTarget != null ? "Force push to " + prohibitedTarget.getPresentation() + " is prohibited" : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean confirmForcePush(Project project, VcsPushUi ui2) {
        MyDoNotAskOptionForPush myDoNotAskOptionForPush;
        Object object;
        Object object2;
        Object it$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map<PushSupport, Collection<PushInfo>> map2 = ui2.getSelectedPushSpecs();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"ui.selectedPushSpecs");
        Map<PushSupport, Collection<PushInfo>> $this$mapValues$iv = map2;
        boolean $i$f$mapValues = false;
        Map<PushSupport, Collection<PushInfo>> map3 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean bl = false;
        Iterator iterator = $this$associateByTo$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$filterTo$iv$iv;
            Collection pushInfos;
            void $dstr$support$pushInfos;
            Object element$iv$iv$iv = iterator.next();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map bl5 = destination$iv$iv;
            boolean bl2 = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = k;
            object = bl5;
            boolean bl22 = false;
            void var19_30 = $dstr$support$pushInfos;
            boolean bl3 = false;
            PushSupport support = (PushSupport)var19_30.getKey();
            var19_30 = $dstr$support$pushInfos;
            bl3 = false;
            Collection collection = pushInfos = (Collection)var19_30.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"pushInfos");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PushInfo it = (PushInfo)element$iv$iv;
                boolean bl4 = false;
                PushInfo pushInfo = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)pushInfo, (String)"it");
                PushSpec<PushSource, PushTarget> pushSpec = pushInfo.getPushSpec();
                Intrinsics.checkExpressionValueIsNotNull(pushSpec, (String)"it.pushSpec");
                if (!(!support.isSilentForcePushAllowed(pushSpec.getTarget()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            object.put(object2, list);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        destination$iv$iv = $this$filterValues$iv;
        $i$f$mapValuesTo22 = false;
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            List it = (List)entry.getValue();
            boolean bl4 = false;
            it$iv$iv = it;
            boolean bl5 = false;
            if (!(!it$iv$iv.isEmpty())) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map silentForcePushIsNotAllowed = result$iv;
        if (silentForcePushIsNotAllowed.isEmpty()) {
            return true;
        }
        PushTarget commonTarget = null;
        PushSupport aSupport = null;
        if (silentForcePushIsNotAllowed.size() > 1) {
            aSupport = null;
            commonTarget = null;
        } else {
            void $this$mapTo$iv$iv;
            aSupport = (PushSupport)CollectionsKt.first((Iterable)silentForcePushIsNotAllowed.keySet());
            Object v = silentForcePushIsNotAllowed.get(aSupport);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            Iterable $this$map$iv = (Iterable)v;
            boolean $i$f$map = false;
            Iterable $i$f$mapValuesTo22 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean bl6 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                it$iv$iv = (PushInfo)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl7 = false;
                void v5 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                PushSpec<PushSource, PushTarget> pushSpec = v5.getPushSpec();
                Intrinsics.checkExpressionValueIsNotNull(pushSpec, (String)"it.pushSpec");
                object2 = pushSpec.getTarget();
                object.add(object2);
            }
            commonTarget = (PushTarget)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv3)));
        }
        String to = commonTarget != null ? " to <b>" + commonTarget.getPresentation() + "</b>" : "";
        String message = "You're going to force push" + to + ". It may overwrite commits at the remote. Are you sure you want to proceed?";
        if (commonTarget != null) {
            PushSupport pushSupport = aSupport;
            if (pushSupport == null) {
                Intrinsics.throwNpe();
            }
            myDoNotAskOptionForPush = new MyDoNotAskOptionForPush(pushSupport, commonTarget);
        } else {
            myDoNotAskOptionForPush = null;
        }
        MyDoNotAskOptionForPush myDoNotAskOption = myDoNotAskOptionForPush;
        String string = XmlStringUtil.wrapInHtml((CharSequence)message);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XmlStringUtil.wrapInHtml(message)");
        int decision = MessageUtil.showOkCancelDialog$default((String)"Force Push", (String)string, (String)"&Force Push", null, (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)((DialogWrapper.DoNotAskOption)myDoNotAskOption), (Project)project, (int)8, null);
        return decision == 0;
    }
}

