/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.newImpl.table;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.newImpl.JBTabsImpl;
import com.intellij.ui.tabs.newImpl.LayoutPassInfo;
import com.intellij.ui.tabs.newImpl.table.TableRow;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TablePassInfo
extends LayoutPassInfo {
    final List<TableRow> table = new ArrayList<TableRow>();
    public Rectangle toFitRec;
    final Map<TabInfo, TableRow> myInfo2Row = new HashMap<TabInfo, TableRow>();
    int requiredWidth;
    int requiredRows;
    int rowToFitMaxX;
    final JBTabsImpl myTabs;

    TablePassInfo(JBTabsImpl tabs, List<TabInfo> visibleInfos) {
        super(visibleInfos);
        this.myTabs = tabs;
    }

    @Override
    @Nullable
    public TabInfo getPreviousFor(TabInfo info) {
        TableRow row = this.myInfo2Row.get(info);
        return row != null ? TablePassInfo.getPrevious(row.myColumns, row.myColumns.indexOf(info)) : null;
    }

    @Override
    @Nullable
    public TabInfo getNextFor(TabInfo info) {
        TableRow row = this.myInfo2Row.get(info);
        return row != null ? TablePassInfo.getNext(row.myColumns, row.myColumns.indexOf(info)) : null;
    }

    public boolean isInSelectionRow(TabInfo tabInfo) {
        TableRow row = this.myInfo2Row.get(tabInfo);
        int index = this.table.indexOf(row);
        return index != -1 && index == this.table.size() - 1;
    }

    @Override
    public int getRowCount() {
        return this.table.size();
    }

    @Override
    public int getColumnCount(int row) {
        return this.table.get((int)row).myColumns.size();
    }

    @Override
    public TabInfo getTabAt(int row, int column) {
        return this.table.get((int)row).myColumns.get(column);
    }

    @Override
    public boolean hasCurveSpaceFor(TabInfo tabInfo) {
        TableRow row = this.myInfo2Row.get(tabInfo);
        return row != null ? row.myColumns.indexOf(tabInfo) < row.myColumns.size() - 1 : false;
    }

    @Override
    public Rectangle getHeaderRectangle() {
        return (Rectangle)this.toFitRec.clone();
    }
}

