/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.newImpl.singleRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.newImpl.JBTabsImpl;
import com.intellij.ui.tabs.newImpl.LayoutPassInfo;
import com.intellij.ui.tabs.newImpl.singleRow.SingleRowLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class SingleRowPassInfo
extends LayoutPassInfo {
    final Dimension layoutSize;
    final int contentCount;
    int position;
    int requiredLength;
    int toFitLength;
    public final List<TabInfo> toLayout;
    public final List<TabInfo> toDrop;
    final int moreRectAxisSize;
    public Rectangle moreRect;
    public WeakReference<JComponent> hToolbar;
    public WeakReference<JComponent> vToolbar;
    public Rectangle firstGhost;
    public boolean firstGhostVisible;
    public Rectangle lastGhost;
    public boolean lastGhostVisible;
    public Insets insets;
    public WeakReference<JComponent> comp;
    public Rectangle tabRectangle;
    final int scrollOffset;

    public SingleRowPassInfo(SingleRowLayout layout, List<TabInfo> visibleInfos) {
        super(visibleInfos);
        JBTabsImpl tabs = layout.myTabs;
        this.layoutSize = tabs.getSize();
        this.contentCount = tabs.getTabCount();
        this.toLayout = new ArrayList<TabInfo>();
        this.toDrop = new ArrayList<TabInfo>();
        this.moreRectAxisSize = layout.getStrategy().getMoreRectAxisSize();
        this.scrollOffset = layout.getScrollOffset();
    }

    @Override
    public TabInfo getPreviousFor(TabInfo info) {
        return SingleRowPassInfo.getPrevious(this.myVisibleInfos, this.myVisibleInfos.indexOf(info));
    }

    @Override
    public TabInfo getNextFor(TabInfo info) {
        return SingleRowPassInfo.getNext(this.myVisibleInfos, this.myVisibleInfos.indexOf(info));
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public int getColumnCount(int row) {
        return this.myVisibleInfos.size();
    }

    @Override
    public TabInfo getTabAt(int row, int column) {
        return (TabInfo)this.myVisibleInfos.get(column);
    }

    @Override
    public Rectangle getHeaderRectangle() {
        return (Rectangle)this.tabRectangle.clone();
    }

    @Override
    public boolean hasCurveSpaceFor(TabInfo tabInfo) {
        return true;
    }
}

