/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.newImpl.singleRow;

import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.newImpl.JBTabsImpl;
import com.intellij.ui.tabs.newImpl.TabLabel;
import com.intellij.ui.tabs.newImpl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.newImpl.singleRow.SingleRowPassInfo;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CompressibleSingleRowLayout
extends SingleRowLayout {
    public CompressibleSingleRowLayout(JBTabsImpl tabs) {
        super(tabs);
    }

    @Override
    protected void recomputeToLayout(SingleRowPassInfo data) {
        this.calculateRequiredLength(data);
        data.firstGhostVisible = false;
        data.lastGhostVisible = false;
    }

    @Override
    protected void layoutLabelsAndGhosts(SingleRowPassInfo data) {
        if (this.myTabs.getPresentation().getTabsPosition() != JBTabsPosition.top && this.myTabs.getPresentation().getTabsPosition() != JBTabsPosition.bottom) {
            super.layoutLabelsAndGhosts(data);
            return;
        }
        int maxGridSize = 0;
        int spentLength = 0;
        int lengthEstimation = 0;
        int[] lengths = new int[data.toLayout.size()];
        List<TabInfo> layout = data.toLayout;
        for (int i = 0; i < layout.size(); ++i) {
            int lengthIncrement;
            TabLabel label = this.myTabs.myInfo2Label.get(layout.get(i));
            if (maxGridSize == 0) {
                Font font = label.getLabelComponent().getFont();
                maxGridSize = GraphicsUtil.stringWidth((String)"m", (Font)(font == null ? JBFont.label() : font)) * this.myTabs.tabMSize();
            }
            lengths[i] = lengthIncrement = label.getPreferredSize().width;
            lengthEstimation += lengthIncrement;
        }
        int extraWidth = data.toFitLength - lengthEstimation;
        Arrays.sort(lengths);
        double acc = 0.0;
        int actualGridSize = 0;
        for (int i = 0; i < lengths.length; ++i) {
            int length = lengths[i];
            actualGridSize = (int)Math.min((double)maxGridSize, ((acc += (double)length) + (double)extraWidth) / (double)(i + 1));
            if (i < lengths.length - 1 && actualGridSize < lengths[i + 1]) break;
        }
        Iterator<TabInfo> iterator = data.toLayout.iterator();
        while (iterator.hasNext()) {
            TabLabel label = this.myTabs.myInfo2Label.get(iterator.next());
            label.setActionPanelVisible(true);
            int lengthIncrement = label.getPreferredSize().width;
            int length = !iterator.hasNext() ? Math.min(data.toFitLength - spentLength, Math.max(actualGridSize, lengthIncrement)) : (extraWidth <= 0 ? (int)((float)lengthIncrement * (float)data.toFitLength / (float)lengthEstimation) : Math.max(lengthIncrement, actualGridSize));
            spentLength += length + this.myTabs.getTabHGap();
            this.applyTabLayout(data, label, length, 0);
            data.position = (int)label.getBounds().getMaxX() + this.myTabs.getTabHGap();
        }
        for (TabInfo eachInfo : data.toDrop) {
            JBTabsImpl.resetLayout(this.myTabs.myInfo2Label.get(eachInfo));
        }
    }

    @Override
    protected boolean applyTabLayout(SingleRowPassInfo data, TabLabel label, int length, int deltaToFit) {
        boolean result = super.applyTabLayout(data, label, length, deltaToFit);
        label.setAlignmentToCenter(false);
        return result;
    }
}

