/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PatternUtil;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoredFileBean
implements IgnoredFileDescriptor {
    private final String myPath;
    private final String myFilenameIfFile;
    private final String myMask;
    private final Pattern myPattern;
    private final IgnoreSettingsType myType;
    private final Project myProject;
    private volatile VirtualFile myCachedResolved;

    IgnoredFileBean(@NotNull String path2, @NotNull IgnoreSettingsType type, @Nullable Project project) {
        if (path2 == null) {
            IgnoredFileBean.$$$reportNull$$$0(0);
        }
        if (type == null) {
            IgnoredFileBean.$$$reportNull$$$0(1);
        }
        this.myPath = path2;
        this.myType = type;
        this.myFilenameIfFile = IgnoreSettingsType.FILE.equals((Object)type) ? PathUtilRt.getFileName((String)path2) : null;
        this.myProject = project;
        this.myMask = null;
        this.myPattern = null;
    }

    IgnoredFileBean(@NotNull String mask) {
        if (mask == null) {
            IgnoredFileBean.$$$reportNull$$$0(2);
        }
        this.myType = IgnoreSettingsType.MASK;
        this.myMask = mask;
        this.myPattern = PatternUtil.fromMask((String)mask);
        this.myPath = null;
        this.myFilenameIfFile = null;
        this.myProject = null;
    }

    @Nullable
    Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.myPath;
    }

    @Override
    @Nullable
    public String getMask() {
        return this.myMask;
    }

    @Override
    @NotNull
    public IgnoreSettingsType getType() {
        IgnoreSettingsType ignoreSettingsType = this.myType;
        if (ignoreSettingsType == null) {
            IgnoredFileBean.$$$reportNull$$$0(3);
        }
        return ignoreSettingsType;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgnoredFileBean that = (IgnoredFileBean)o;
        if (!Objects.equals(this.myPath, that.myPath)) {
            return false;
        }
        if (!Objects.equals(this.myMask, that.myMask)) {
            return false;
        }
        return this.myType == that.myType;
    }

    public int hashCode() {
        int result = this.myPath != null ? this.myPath.hashCode() : 0;
        result = 31 * result + (this.myMask != null ? this.myMask.hashCode() : 0);
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    @Override
    public boolean matchesFile(@NotNull VirtualFile file) {
        if (file == null) {
            IgnoredFileBean.$$$reportNull$$$0(4);
        }
        if (this.myType == IgnoreSettingsType.MASK) {
            return this.myPattern.matcher(file.getName()).matches();
        }
        if (IgnoreSettingsType.FILE.equals((Object)this.myType) && !StringUtil.equals((CharSequence)this.myFilenameIfFile, (CharSequence)file.getNameSequence())) {
            return false;
        }
        VirtualFile selector = this.resolve();
        if (Comparing.equal((Object)selector, (Object)NullVirtualFile.INSTANCE)) {
            return false;
        }
        if (this.myType == IgnoreSettingsType.FILE) {
            return Comparing.equal((Object)selector, (Object)file);
        }
        if ("./".equals(this.myPath)) {
            return !file.isDirectory() && Comparing.equal((Object)file.getParent(), (Object)selector);
        }
        return VfsUtilCore.isAncestor(selector, file, false);
    }

    @NotNull
    private VirtualFile resolve() {
        if (this.myCachedResolved == null) {
            VirtualFile resolved = this.doResolve();
            this.myCachedResolved = resolved != null ? resolved : NullVirtualFile.INSTANCE;
        }
        VirtualFile virtualFile2 = this.myCachedResolved;
        if (virtualFile2 == null) {
            IgnoredFileBean.$$$reportNull$$$0(5);
        }
        return virtualFile2;
    }

    @Nullable
    private VirtualFile doResolve() {
        if (this.myProject == null || this.myProject.isDisposed()) {
            return null;
        }
        VirtualFile baseDir = this.myProject.getBaseDir();
        String path2 = FileUtil.toSystemIndependentName((String)this.myPath);
        if (baseDir == null) {
            return LocalFileSystem.getInstance().findFileByPath(path2);
        }
        VirtualFile resolvedRelative = baseDir.findFileByRelativePath(path2);
        if (resolvedRelative != null) {
            return resolvedRelative;
        }
        return LocalFileSystem.getInstance().findFileByPath(path2);
    }

    public void resetCache() {
        this.myCachedResolved = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/IgnoredFileBean";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/IgnoredFileBean";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matchesFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

