/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoredBeanFactory {
    private IgnoredBeanFactory() {
    }

    @NotNull
    public static IgnoredFileBean ignoreUnderDirectory(@NotNull @NonNls String path2, @Nullable Project p) {
        if (path2 == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(0);
        }
        String correctedPath = path2.endsWith("/") || path2.endsWith(File.separator) ? path2 : path2 + "/";
        IgnoredFileBean ignoredFileBean = new IgnoredFileBean(correctedPath, IgnoreSettingsType.UNDER_DIR, p);
        if (ignoredFileBean == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(1);
        }
        return ignoredFileBean;
    }

    @NotNull
    public static IgnoredFileBean ignoreFile(@NotNull @NonNls String path2, @Nullable Project p) {
        if (path2 == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(2);
        }
        IgnoredFileBean ignoredFileBean = new IgnoredFileBean(path2, IgnoreSettingsType.FILE, p);
        if (ignoredFileBean == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(3);
        }
        return ignoredFileBean;
    }

    @NotNull
    public static IgnoredFileBean ignoreFile(@NotNull VirtualFile file, @Nullable Project p) {
        if (file == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(4);
        }
        if (file.isDirectory()) {
            IgnoredFileBean ignoredFileBean = IgnoredBeanFactory.ignoreUnderDirectory(file.getPath(), p);
            if (ignoredFileBean == null) {
                IgnoredBeanFactory.$$$reportNull$$$0(5);
            }
            return ignoredFileBean;
        }
        IgnoredFileBean ignoredFileBean = IgnoredBeanFactory.ignoreFile(file.getPath(), p);
        if (ignoredFileBean == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(6);
        }
        return ignoredFileBean;
    }

    @NotNull
    public static IgnoredFileBean withMask(@NotNull String mask) {
        if (mask == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(7);
        }
        IgnoredFileBean ignoredFileBean = new IgnoredFileBean(mask);
        if (ignoredFileBean == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(8);
        }
        return ignoredFileBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/IgnoredBeanFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/IgnoredBeanFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ignoreUnderDirectory";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ignoreFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withMask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ignoreUnderDirectory";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ignoreFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withMask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

