/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEventVisitor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataContextWrapper;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PlaceProvider;
import java.awt.event.InputEvent;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnActionEvent
implements PlaceProvider<String> {
    private final InputEvent myInputEvent;
    @NotNull
    private final ActionManager myActionManager;
    @NotNull
    private final DataContext myDataContext;
    @NotNull
    private final String myPlace;
    @NotNull
    private final Presentation myPresentation;
    @JdkConstants.InputEventMask
    private final int myModifiers;
    private boolean myWorksInInjected;
    @NonNls
    private static final String ourInjectedPrefix = "$injected$.";
    private static final Map<String, String> ourInjectedIds = new HashMap<String, String>();
    private final boolean myIsContextMenuAction;
    private final boolean myIsActionToolbar;

    public AnActionEvent(InputEvent inputEvent, @NotNull DataContext dataContext, @NotNull @NonNls String place, @NotNull Presentation presentation, @NotNull ActionManager actionManager, @JdkConstants.InputEventMask int modifiers) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(0);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            AnActionEvent.$$$reportNull$$$0(2);
        }
        if (actionManager == null) {
            AnActionEvent.$$$reportNull$$$0(3);
        }
        this(inputEvent, dataContext, place, presentation, actionManager, modifiers, false, false);
    }

    public AnActionEvent(InputEvent inputEvent, @NotNull DataContext dataContext, @NotNull @NonNls String place, @NotNull Presentation presentation, @NotNull ActionManager actionManager, @JdkConstants.InputEventMask int modifiers, boolean isContextMenuAction, boolean isActionToolbar) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(4);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(5);
        }
        if (presentation == null) {
            AnActionEvent.$$$reportNull$$$0(6);
        }
        if (actionManager == null) {
            AnActionEvent.$$$reportNull$$$0(7);
        }
        this.myInputEvent = inputEvent;
        this.myActionManager = actionManager;
        this.myDataContext = dataContext;
        this.myPlace = place;
        this.myPresentation = presentation;
        this.myModifiers = modifiers;
        this.myIsContextMenuAction = isContextMenuAction;
        this.myIsActionToolbar = isActionToolbar;
    }

    @Deprecated
    @NotNull
    public static AnActionEvent createFromInputEvent(@NotNull AnAction action, @Nullable InputEvent event, @NotNull String place) {
        if (action == null) {
            AnActionEvent.$$$reportNull$$$0(8);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(9);
        }
        DataContext context = event == null ? DataManager.getInstance().getDataContext() : DataManager.getInstance().getDataContext(event.getComponent());
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction(action, event, place, context);
        if (anActionEvent == null) {
            AnActionEvent.$$$reportNull$$$0(10);
        }
        return anActionEvent;
    }

    @NotNull
    public static AnActionEvent createFromAnAction(@NotNull AnAction action, @Nullable InputEvent event, @NotNull String place, @NotNull DataContext dataContext) {
        if (action == null) {
            AnActionEvent.$$$reportNull$$$0(11);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(12);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(13);
        }
        int modifiers = event == null ? 0 : event.getModifiers();
        Presentation presentation = action.getTemplatePresentation().clone();
        AnActionEvent anActionEvent = new AnActionEvent(event, dataContext, place, presentation, ActionManager.getInstance(), modifiers);
        anActionEvent.setInjectedContext(action.isInInjectedContext());
        AnActionEvent anActionEvent2 = anActionEvent;
        if (anActionEvent2 == null) {
            AnActionEvent.$$$reportNull$$$0(14);
        }
        return anActionEvent2;
    }

    @NotNull
    public static AnActionEvent createFromDataContext(@NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext) {
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(15);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(16);
        }
        AnActionEvent anActionEvent = new AnActionEvent(null, dataContext, place, presentation == null ? new Presentation() : presentation, ActionManager.getInstance(), 0);
        if (anActionEvent == null) {
            AnActionEvent.$$$reportNull$$$0(17);
        }
        return anActionEvent;
    }

    @NotNull
    public static AnActionEvent createFromInputEvent(@Nullable InputEvent event, @NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext) {
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(18);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(19);
        }
        AnActionEvent anActionEvent = AnActionEvent.createFromInputEvent(event, place, presentation, dataContext, false, false);
        if (anActionEvent == null) {
            AnActionEvent.$$$reportNull$$$0(20);
        }
        return anActionEvent;
    }

    @NotNull
    public static AnActionEvent createFromInputEvent(@Nullable InputEvent event, @NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext, boolean isContextMenuAction, boolean isToolbarAction) {
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(21);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(22);
        }
        AnActionEvent anActionEvent = new AnActionEvent(event, dataContext, place, presentation == null ? new Presentation() : presentation, ActionManager.getInstance(), event == null ? 0 : event.getModifiers(), isContextMenuAction, isToolbarAction);
        if (anActionEvent == null) {
            AnActionEvent.$$$reportNull$$$0(23);
        }
        return anActionEvent;
    }

    public InputEvent getInputEvent() {
        return this.myInputEvent;
    }

    @Nullable
    public Project getProject() {
        return this.getData(CommonDataKeys.PROJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NonNls
    @NotNull
    public static String injectedId(@NotNull String dataId) {
        if (dataId == null) {
            AnActionEvent.$$$reportNull$$$0(24);
        }
        Map<String, String> map = ourInjectedIds;
        // MONITORENTER : map
        String string = ourInjectedIds.computeIfAbsent(dataId, i -> ourInjectedPrefix + i);
        // MONITOREXIT : map
        if (string != null) return string;
        AnActionEvent.$$$reportNull$$$0(25);
        return string;
    }

    @NonNls
    @NotNull
    public static String uninjectedId(@NotNull String dataId) {
        if (dataId == null) {
            AnActionEvent.$$$reportNull$$$0(26);
        }
        String string = StringUtil.trimStart((String)dataId, (String)ourInjectedPrefix);
        if (string == null) {
            AnActionEvent.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static DataContext getInjectedDataContext(@NotNull DataContext context) {
        if (context == null) {
            AnActionEvent.$$$reportNull$$$0(28);
        }
        DataContextWrapper dataContextWrapper = new DataContextWrapper(context){

            @Override
            @Nullable
            public Object getData(@NotNull @NonNls String dataId) {
                Object injected;
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((injected = super.getData(AnActionEvent.injectedId(dataId))) != null) {
                    return injected;
                }
                return super.getData(dataId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/actionSystem/AnActionEvent$1", "getData"));
            }
        };
        if (dataContextWrapper == null) {
            AnActionEvent.$$$reportNull$$$0(29);
        }
        return dataContextWrapper;
    }

    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = this.myWorksInInjected ? AnActionEvent.getInjectedDataContext(this.myDataContext) : this.myDataContext;
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(30);
        }
        return dataContext;
    }

    @Nullable
    public <T> T getData(@NotNull DataKey<T> key) {
        if (key == null) {
            AnActionEvent.$$$reportNull$$$0(31);
        }
        return this.getDataContext().getData(key);
    }

    @NotNull
    public <T> T getRequiredData(@NotNull DataKey<T> key) {
        if (key == null) {
            AnActionEvent.$$$reportNull$$$0(32);
        }
        T data = this.getData(key);
        assert (data != null);
        T t = data;
        if (t == null) {
            AnActionEvent.$$$reportNull$$$0(33);
        }
        return t;
    }

    @Override
    @NotNull
    public String getPlace() {
        String string = this.myPlace;
        if (string == null) {
            AnActionEvent.$$$reportNull$$$0(34);
        }
        return string;
    }

    public boolean isFromActionToolbar() {
        return this.myIsActionToolbar;
    }

    @Deprecated
    public boolean isFromContextMenu() {
        return this.myIsContextMenuAction;
    }

    @NotNull
    public Presentation getPresentation() {
        Presentation presentation = this.myPresentation;
        if (presentation == null) {
            AnActionEvent.$$$reportNull$$$0(35);
        }
        return presentation;
    }

    @JdkConstants.InputEventMask
    public int getModifiers() {
        return this.myModifiers;
    }

    @NotNull
    public ActionManager getActionManager() {
        ActionManager actionManager = this.myActionManager;
        if (actionManager == null) {
            AnActionEvent.$$$reportNull$$$0(36);
        }
        return actionManager;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }

    public void accept(@NotNull AnActionEventVisitor visitor) {
        if (visitor == null) {
            AnActionEvent.$$$reportNull$$$0(37);
        }
        visitor.visitEvent(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/AnActionEvent";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/AnActionEvent";
                break;
            }
            case 10: 
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromInputEvent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromAnAction";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromDataContext";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "injectedId";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "uninjectedId";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedDataContext";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredData";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createFromInputEvent";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFromAnAction";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFromDataContext";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "injectedId";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "uninjectedId";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedDataContext";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredData";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

