/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.SmartSelectInContext;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileEditorSelectInContext
extends SmartSelectInContext {
    private final TextEditor editor;

    public FileEditorSelectInContext(@NotNull FileEditor fileEditor, @NotNull PsiFile psiFile) {
        if (fileEditor == null) {
            FileEditorSelectInContext.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            FileEditorSelectInContext.$$$reportNull$$$0(1);
        }
        super(psiFile, psiFile, () -> fileEditor);
        this.editor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
    }

    @Override
    @Nullable
    public Object getSelectorInFile() {
        PsiFile file = this.getPsiFile();
        return file == null ? null : ObjectUtils.notNull((Object)this.getElementAtCaret(file, false), (Object)file);
    }

    @Nullable
    public PsiElement getElementAtCaret(boolean tryInjected) {
        PsiFile file = this.getPsiFile();
        return file == null ? null : this.getElementAtCaret(file, tryInjected);
    }

    @Nullable
    private PsiElement getElementAtCaret(@NotNull PsiFile file, boolean tryInjected) {
        InjectedLanguageManager manager;
        PsiElement injectedElementAt;
        Editor editor;
        if (file == null) {
            FileEditorSelectInContext.$$$reportNull$$$0(2);
        }
        if ((editor = this.getEditor()) == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        if (tryInjected && (injectedElementAt = (manager = InjectedLanguageManager.getInstance(this.getProject())).findInjectedElementAt(file, offset)) != null) {
            return injectedElementAt;
        }
        PsiElement elementAt = file.findElementAt(offset);
        if (offset > 0 && (elementAt == null || elementAt instanceof PsiWhiteSpace)) {
            elementAt = file.findElementAt(offset - 1);
        }
        return elementAt;
    }

    @Nullable
    public Editor getEditor() {
        return this.editor == null ? null : this.editor.getEditor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/FileEditorSelectInContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementAtCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

