/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import org.jdom.Element;

public class LogFilter
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.diagnostic.logging.LogFilter");
    public String myName;
    public String myIconPath;
    private Icon myIcon;

    public LogFilter(String name, Icon icon) {
        this.myName = name;
        this.myIcon = icon;
    }

    public LogFilter(String name, String iconPath) {
        this.myName = name;
        this.myIconPath = iconPath;
    }

    public LogFilter(String name) {
        this.myName = name;
    }

    public LogFilter() {
    }

    public String toString() {
        return this.myName;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public boolean isAcceptable(String line) {
        return true;
    }

    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        if (this.myIcon != null) {
            return this.myIcon;
        }
        if (this.myIconPath != null && new File(FileUtil.toSystemDependentName((String)this.myIconPath)).exists()) {
            Image image = null;
            try {
                image = ImageLoader.loadFromStream((InputStream)VfsUtilCore.convertToURL(VfsUtil.pathToUrl(this.myIconPath)).openStream());
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
            if (image != null) {
                return new JBImageIcon(image);
            }
        }
        return null;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }
}

