/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.psi.PsiElement;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigateAction<T extends PsiElement>
extends AnAction {
    private final LineMarkerInfo<T> myInfo;
    @Nullable
    private final String myOriginalActionId;

    public NavigateAction(@NotNull String text, @NotNull LineMarkerInfo<T> info, @Nullable String originalActionId) {
        if (text == null) {
            NavigateAction.$$$reportNull$$$0(0);
        }
        if (info == null) {
            NavigateAction.$$$reportNull$$$0(1);
        }
        super(text);
        this.myInfo = info;
        this.myOriginalActionId = originalActionId;
        if (originalActionId != null) {
            ShortcutSet set = ActionManager.getInstance().getAction(originalActionId).getShortcutSet();
            this.setShortcutSet(set);
        }
    }

    public NavigateAction(@NotNull LineMarkerInfo<T> info) {
        if (info == null) {
            NavigateAction.$$$reportNull$$$0(2);
        }
        this.myInfo = info;
        this.myOriginalActionId = null;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateAction.$$$reportNull$$$0(3);
        }
        if (this.myInfo.getNavigationHandler() != null) {
            MouseEvent mouseEvent = (MouseEvent)e.getInputEvent();
            T element = this.myInfo.getElement();
            if (element == null || !element.isValid()) {
                return;
            }
            this.myInfo.getNavigationHandler().navigate(mouseEvent, element);
        }
    }

    @NotNull
    public static <T extends PsiElement> LineMarkerInfo<T> setNavigateAction(@NotNull LineMarkerInfo<T> info, @NotNull String text, @Nullable String originalActionId) {
        if (info == null) {
            NavigateAction.$$$reportNull$$$0(4);
        }
        if (text == null) {
            NavigateAction.$$$reportNull$$$0(5);
        }
        NavigateAction<T> action = new NavigateAction<T>(text, info, originalActionId);
        info.setNavigateAction(action);
        LineMarkerInfo<T> lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            NavigateAction.$$$reportNull$$$0(6);
        }
        return lineMarkerInfo;
    }

    @Nullable
    public String getOriginalActionId() {
        return this.myOriginalActionId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/NavigateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/NavigateAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setNavigateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setNavigateAction";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

