/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.comment.ui.EditorComponentInlaysManager;
import org.jetbrains.plugins.github.pullrequest.comment.ui.EditorComponentInlaysManager$ComponentWrapper$$special$;
import org.jetbrains.plugins.github.pullrequest.comment.ui.EditorComponentInlaysManager$sam$java_awt_event_MouseWheelListener$0;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\u000e2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "editorTextWidth", "", "managedInlays", "", "Lcom/intellij/openapi/editor/Inlay;", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$ComponentWrapperPlaceholder;", "verticalScrollbarFlipped", "", "dispose", "", "insertAfter", "line", "component", "Ljavax/swing/JComponent;", "updateLocationForAllInlays", "updateWidthForAllInlays", "updateWrapperLocation", "inlay", "wrapper", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$ComponentWrapper;", "updateWrapperWidth", "wrapAndInsert", "offset", "ComponentWrapper", "ComponentWrapperPlaceholder", "intellij.vcs.github"})
public final class EditorComponentInlaysManager
implements Disposable {
    private final int editorTextWidth;
    private final boolean verticalScrollbarFlipped;
    private final Set<Inlay<? extends ComponentWrapperPlaceholder>> managedInlays;
    private final EditorImpl editor;

    private final void updateLocationForAllInlays() {
        Iterable $this$forEach$iv = this.managedInlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it = (Inlay)element$iv;
            boolean bl = false;
            this.updateWrapperLocation((Inlay<? extends ComponentWrapperPlaceholder>)it, ((ComponentWrapperPlaceholder)it.getRenderer()).getWrapper());
        }
    }

    private final void updateWidthForAllInlays() {
        Iterable $this$forEach$iv = this.managedInlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it = (Inlay)element$iv;
            boolean bl = false;
            this.updateWrapperWidth(((ComponentWrapperPlaceholder)it.getRenderer()).getWrapper());
        }
    }

    @Nullable
    public final Inlay<?> insertAfter(int line, @NotNull JComponent component) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        if (Disposer.isDisposed((Disposable)this)) {
            return null;
        }
        int offset = this.editor.getDocument().getLineEndOffset(line - 1);
        return this.wrapAndInsert(offset, component);
    }

    private final Inlay<?> wrapAndInsert(int offset, JComponent component) {
        ComponentWrapper wrapper = new ComponentWrapper(component);
        Inlay inlay = this.editor.getInlayModel().addBlockElement(offset, true, false, 1, (EditorCustomElementRenderer)new ComponentWrapperPlaceholder(wrapper));
        if (inlay == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)inlay, (String)"editor.inlayModel.addBlo\u2026erPlaceholder(wrapper))!!");
        Inlay inlay2 = inlay;
        component.setBackground(this.editor.getBackgroundColor());
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)inlay2).subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(this, component){
            final /* synthetic */ EditorComponentInlaysManager this$0;
            final /* synthetic */ JComponent $component;

            public final void globalSchemeChange(@Nullable EditorColorsScheme it) {
                this.$component.setBackground(EditorComponentInlaysManager.access$getEditor$p(this.this$0).getBackgroundColor());
            }
            {
                this.this$0 = editorComponentInlaysManager;
                this.$component = jComponent;
            }
        });
        wrapper.addComponentListener(new ComponentAdapter(this, inlay2, wrapper){
            final /* synthetic */ EditorComponentInlaysManager this$0;
            final /* synthetic */ Inlay $inlay;
            final /* synthetic */ ComponentWrapper $wrapper;

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ wrapAndInsert.2 this$0;

                    public final void run() {
                        this.this$0.$inlay.updateSize();
                        EditorComponentInlaysManager.access$updateWrapperLocation(this.this$0.this$0, this.this$0.$inlay, this.this$0.$wrapper);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$inlay = $captured_local_variable$1;
                this.$wrapper = $captured_local_variable$2;
            }
        });
        Function1 function1 = (Function1)new Function1<AWTEvent, Unit>(this.editor.getContentComponent()){

            public final void invoke(AWTEvent p1) {
                ((EditorComponentImpl)this.receiver).dispatchEvent(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(EditorComponentImpl.class);
            }

            public final String getName() {
                return "dispatchEvent";
            }

            public final String getSignature() {
                return "dispatchEvent(Ljava/awt/AWTEvent;)V";
            }
        };
        wrapper.addMouseWheelListener(new EditorComponentInlaysManager$sam$java_awt_event_MouseWheelListener$0(function1));
        this.updateWrapperWidth(wrapper);
        inlay2.updateSize();
        this.updateWrapperLocation((Inlay<? extends ComponentWrapperPlaceholder>)inlay2, wrapper);
        this.editor.getContentComponent().add((Component)((Object)wrapper));
        this.managedInlays.add((Inlay<? extends ComponentWrapperPlaceholder>)inlay2);
        Disposer.register((Disposable)((Disposable)inlay2), (Disposable)new Disposable(this, wrapper, inlay2){
            final /* synthetic */ EditorComponentInlaysManager this$0;
            final /* synthetic */ ComponentWrapper $wrapper;
            final /* synthetic */ Inlay $inlay;

            public final void dispose() {
                EditorComponentInlaysManager.access$getEditor$p(this.this$0).getContentComponent().remove((Component)((Object)this.$wrapper));
                EditorComponentInlaysManager.access$getManagedInlays$p(this.this$0).remove(this.$inlay);
            }
            {
                this.this$0 = editorComponentInlaysManager;
                this.$wrapper = componentWrapper;
                this.$inlay = inlay;
            }
        });
        return inlay2;
    }

    private final void updateWrapperLocation(Inlay<? extends ComponentWrapperPlaceholder> inlay, ComponentWrapper wrapper) {
        Rectangle bounds = inlay.getBounds();
        if (bounds == null) {
            wrapper.setVisible(false);
        } else {
            int n;
            if (this.verticalScrollbarFlipped) {
                JScrollPane jScrollPane = this.editor.getScrollPane();
                Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"editor.scrollPane");
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"editor.scrollPane.verticalScrollBar");
                n = jScrollBar.getWidth();
            } else {
                n = 0;
            }
            wrapper.setLocation(new Point(n, bounds.getLocation().y));
            wrapper.setVisible(true);
            this.updateWrapperWidth(wrapper);
        }
    }

    private final void updateWrapperWidth(ComponentWrapper wrapper) {
        if (!wrapper.isVisible()) {
            return;
        }
        JScrollPane jScrollPane = this.editor.getScrollPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"editor.scrollPane");
        JViewport jViewport = jScrollPane.getViewport();
        Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"editor.scrollPane.viewport");
        int n = jViewport.getWidth();
        JScrollPane jScrollPane2 = this.editor.getScrollPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane2, (String)"editor.scrollPane");
        JScrollBar jScrollBar = jScrollPane2.getVerticalScrollBar();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"editor.scrollPane.verticalScrollBar");
        int visibleEditorTextWidth = n - jScrollBar.getWidth();
        int width = Math.min(visibleEditorTextWidth, this.editorTextWidth);
        wrapper.setSize(new Dimension(width, wrapper.getSize().height));
    }

    public void dispose() {
        Iterator<Inlay<? extends ComponentWrapperPlaceholder>> iter = this.managedInlays.iterator();
        while (iter.hasNext()) {
            Inlay<? extends ComponentWrapperPlaceholder> inlay = iter.next();
            iter.remove();
            Disposer.dispose((Disposable)((Disposable)inlay));
        }
    }

    public EditorComponentInlaysManager(@NotNull EditorImpl editor) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.editor = editor;
        EditorComponentInlaysManager editorComponentInlaysManager = this;
        boolean bl = false;
        editorComponentInlaysManager.managedInlays = set = (Set)new LinkedHashSet();
        FontMetrics fontMetrics = this.editor.getFontMetrics(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics, (String)"editor.getFontMetrics(Font.PLAIN)");
        FontMetrics metrics = fontMetrics;
        float spaceWidth = FontLayoutService.getInstance().charWidth2D(metrics, 32);
        this.editorTextWidth = (int)(spaceWidth * (float)this.editor.getSettings().getRightMargin(this.editor.getProject()));
        Object scrollbarFlip = this.editor.getScrollPane().getClientProperty(JBScrollPane.Flip.class);
        this.verticalScrollbarFlipped = scrollbarFlip == JBScrollPane.Flip.HORIZONTAL || scrollbarFlip == JBScrollPane.Flip.BOTH;
        this.editor.getFoldingModel().addListener(new FoldingListener(){

            public void onFoldProcessingEnd() {
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ 1 this$0;

                    public final void run() {
                        EditorComponentInlaysManager.access$updateLocationForAllInlays(this.this$0.this);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
        }, (Disposable)this);
        ComponentAdapter viewportResizeListener2 = new ComponentAdapter(this){
            final /* synthetic */ EditorComponentInlaysManager this$0;

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ viewportResizeListener.1 this$0;

                    public final void run() {
                        EditorComponentInlaysManager.access$updateWidthForAllInlays(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = $outer;
            }
        };
        JScrollPane jScrollPane = this.editor.getScrollPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"editor.scrollPane");
        jScrollPane.getViewport().addComponentListener(viewportResizeListener2);
        Disposer.register((Disposable)this, (Disposable)new Disposable(viewportResizeListener2){
            final /* synthetic */ viewportResizeListener.1 $viewportResizeListener;

            public final void dispose() {
                JScrollPane jScrollPane = editor.getScrollPane();
                Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"editor.scrollPane");
                jScrollPane.getViewport().removeComponentListener(this.$viewportResizeListener);
            }
            {
                this.$viewportResizeListener = var2_2;
            }
        });
        this.editor.getInlayModel().addListener((InlayModel.Listener)new InlayModel.SimpleAdapter(){

            public void onUpdated(@NotNull Inlay<?> inlay) {
                Intrinsics.checkParameterIsNotNull(inlay, (String)"inlay");
                this.updateLocationForAllInlays();
            }
        }, (Disposable)this);
        Disposer.register((Disposable)this.editor.getDisposable(), (Disposable)this);
    }

    public static final /* synthetic */ void access$updateWrapperLocation(EditorComponentInlaysManager $this, Inlay inlay, ComponentWrapper wrapper) {
        $this.updateWrapperLocation((Inlay<? extends ComponentWrapperPlaceholder>)inlay, wrapper);
    }

    public static final /* synthetic */ Set access$getManagedInlays$p(EditorComponentInlaysManager $this) {
        return $this.managedInlays;
    }

    public static final /* synthetic */ void access$updateWidthForAllInlays(EditorComponentInlaysManager $this) {
        $this.updateWidthForAllInlays();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$ComponentWrapper;", "Lcom/intellij/ui/components/JBScrollPane;", "component", "Ljavax/swing/JComponent;", "(Ljavax/swing/JComponent;)V", "getComponent", "()Ljavax/swing/JComponent;", "paint", "", "g", "Ljava/awt/Graphics;", "refreshHeight", "intellij.vcs.github"})
    private static final class ComponentWrapper
    extends JBScrollPane {
        @NotNull
        private final JComponent component;

        public final void refreshHeight() {
            int n = this.getWidth();
            JViewport jViewport = this.viewport;
            Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"viewport");
            Component component = jViewport.getView();
            Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"viewport.view");
            this.setSize(new Dimension(n, component.getHeight()));
        }

        public void paint(@NotNull Graphics g) {
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            Composite oldComposite = ((Graphics2D)g).getComposite();
            ((Graphics2D)g).setComposite(AlphaComposite.SrcOver);
            super.paint(g);
            ((Graphics2D)g).setComposite(oldComposite);
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        public ComponentWrapper(@NotNull JComponent component) {
            Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
            this.component = component;
            this.setOpaque(false);
            JViewport jViewport = this.viewport;
            Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"viewport");
            jViewport.setOpaque(false);
            this.setBorder((Border)JBUI.Borders.empty());
            this.setViewportBorder((Border)JBUI.Borders.empty());
            this.horizontalScrollBarPolicy = 31;
            JScrollBar jScrollBar = this.verticalScrollBar;
            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"verticalScrollBar");
            jScrollBar.setPreferredSize(new Dimension(0, 0));
            ScrollablePanel scrollablePanel = new ScrollablePanel((LayoutManager)new BorderLayout());
            boolean bl = false;
            boolean bl2 = false;
            ScrollablePanel $this$apply = scrollablePanel;
            boolean bl3 = false;
            $this$apply.setOpaque(false);
            $this$apply.add((Component)this.component, (Object)"Center");
            $this$apply.addComponentListener((ComponentListener)new ComponentAdapter(this){
                final /* synthetic */ ComponentWrapper this$0;
                {
                    this.this$0 = componentWrapper;
                }

                public void componentResized(@NotNull ComponentEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ ComponentWrapper$$special$$inlined$apply$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            this.this$0.this$0.refreshHeight();
                        }
                    });
                }
            });
            ScrollablePanel panel = scrollablePanel;
            this.setViewportView((Component)panel);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0014\u0010\u000b\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J,\u0010\f\u001a\u00020\r2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$ComponentWrapperPlaceholder;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "wrapper", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$ComponentWrapper;", "(Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$ComponentWrapper;)V", "getWrapper", "()Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$ComponentWrapper;", "calcHeightInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcWidthInPixels", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.vcs.github"})
    private static final class ComponentWrapperPlaceholder
    implements EditorCustomElementRenderer {
        @NotNull
        private final ComponentWrapper wrapper;

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkParameterIsNotNull(inlay, (String)"inlay");
            return this.wrapper.getWidth();
        }

        public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkParameterIsNotNull(inlay, (String)"inlay");
            return this.wrapper.getHeight();
        }

        public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkParameterIsNotNull(inlay, (String)"inlay");
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            Intrinsics.checkParameterIsNotNull((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkParameterIsNotNull((Object)textAttributes, (String)"textAttributes");
        }

        @NotNull
        public final ComponentWrapper getWrapper() {
            return this.wrapper;
        }

        public ComponentWrapperPlaceholder(@NotNull ComponentWrapper wrapper) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)wrapper), (String)"wrapper");
            this.wrapper = wrapper;
        }
    }
}

