/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment;

import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.simple.SimpleOnesideDiffViewer;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.comment.GithubPullRequestDiffCommentsProvider;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GithubPullRequestEditorCommentsThreadComponentFactory;
import org.jetbrains.plugins.github.pullrequest.comment.viewer.GithubPullRequestDiffViewerBaseCommentsHandler;
import org.jetbrains.plugins.github.pullrequest.comment.viewer.GithubPullRequestSimpleOnesideDiffViewerCommentsHandler;
import org.jetbrains.plugins.github.pullrequest.comment.viewer.GithubPullRequestTwosideDiffViewerCommentsHandler;
import org.jetbrains.plugins.github.pullrequest.comment.viewer.GithubPullRequestUnifiedDiffViewerCommentsHandler;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.model.GithubPullRequestFileCommentsThreadMapping;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\b2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GithubPullRequestFilesDiffCommentsProvider;", "Lorg/jetbrains/plugins/github/pullrequest/comment/GithubPullRequestDiffCommentsProvider;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestDataProvider;", "componentFactory", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GithubPullRequestEditorCommentsThreadComponentFactory;", "(Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestDataProvider;Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GithubPullRequestEditorCommentsThreadComponentFactory;)V", "install", "", "viewer", "Lcom/intellij/diff/tools/util/base/DiffViewerBase;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "loadAndShowComments", "commentsHandler", "Lorg/jetbrains/plugins/github/pullrequest/comment/viewer/GithubPullRequestDiffViewerBaseCommentsHandler;", "Lcom/intellij/diff/tools/util/base/ListenerDiffViewerBase;", "Companion", "intellij.vcs.github"})
public final class GithubPullRequestFilesDiffCommentsProvider
implements GithubPullRequestDiffCommentsProvider {
    private final GithubPullRequestDataProvider dataProvider;
    private final GithubPullRequestEditorCommentsThreadComponentFactory componentFactory;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void install(@NotNull DiffViewerBase viewer, @NotNull Change change) {
        GithubPullRequestDiffViewerBaseCommentsHandler githubPullRequestDiffViewerBaseCommentsHandler;
        Intrinsics.checkParameterIsNotNull((Object)viewer, (String)"viewer");
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        DiffViewerBase diffViewerBase = viewer;
        if (diffViewerBase instanceof SimpleOnesideDiffViewer) {
            githubPullRequestDiffViewerBaseCommentsHandler = new GithubPullRequestSimpleOnesideDiffViewerCommentsHandler((SimpleOnesideDiffViewer)viewer, this.componentFactory);
        } else if (diffViewerBase instanceof UnifiedDiffViewer) {
            githubPullRequestDiffViewerBaseCommentsHandler = new GithubPullRequestUnifiedDiffViewerCommentsHandler((UnifiedDiffViewer)viewer, this.componentFactory);
        } else if (diffViewerBase instanceof TwosideTextDiffViewer) {
            githubPullRequestDiffViewerBaseCommentsHandler = new GithubPullRequestTwosideDiffViewerCommentsHandler((TwosideTextDiffViewer)viewer, this.componentFactory);
        } else {
            return;
        }
        GithubPullRequestDiffViewerBaseCommentsHandler commentsHandler = githubPullRequestDiffViewerBaseCommentsHandler;
        Disposer.register((Disposable)((Disposable)viewer), (Disposable)commentsHandler);
        this.loadAndShowComments(commentsHandler, change);
        this.dataProvider.addRequestsChangesListener(commentsHandler, new GithubPullRequestDataProvider.RequestsChangedListener(this, commentsHandler, change){
            final /* synthetic */ GithubPullRequestFilesDiffCommentsProvider this$0;
            final /* synthetic */ GithubPullRequestDiffViewerBaseCommentsHandler $commentsHandler;
            final /* synthetic */ Change $change;

            public void commentsRequestChanged() {
                GithubPullRequestFilesDiffCommentsProvider.access$loadAndShowComments(this.this$0, this.$commentsHandler, this.$change);
            }
            {
                this.this$0 = $outer;
                this.$commentsHandler = $captured_local_variable$1;
                this.$change = $captured_local_variable$2;
            }

            public void detailsRequestChanged() {
                GithubPullRequestDataProvider.RequestsChangedListener.DefaultImpls.detailsRequestChanged(this);
            }

            public void commitsRequestChanged() {
                GithubPullRequestDataProvider.RequestsChangedListener.DefaultImpls.commitsRequestChanged(this);
            }
        });
    }

    private final void loadAndShowComments(GithubPullRequestDiffViewerBaseCommentsHandler<? extends ListenerDiffViewerBase> commentsHandler, Change change) {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable disposable2 = disposable;
        GithubAsyncUtilKt.handleOnEdt(this.dataProvider.getFilesCommentThreadsRequest(), disposable2, (Function2)new Function2<Map<Change, ? extends List<? extends GithubPullRequestFileCommentsThreadMapping>>, Throwable, Unit>(commentsHandler, change){
            final /* synthetic */ GithubPullRequestDiffViewerBaseCommentsHandler $commentsHandler;
            final /* synthetic */ Change $change;

            public final void invoke(@Nullable Map<Change, ? extends List<GithubPullRequestFileCommentsThreadMapping>> result, @Nullable Throwable error) {
                if (result != null) {
                    List list = result.get(this.$change);
                    GithubPullRequestDiffViewerBaseCommentsHandler githubPullRequestDiffViewerBaseCommentsHandler = this.$commentsHandler;
                    boolean bl = false;
                    List list2 = list;
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    List list3 = list2;
                    githubPullRequestDiffViewerBaseCommentsHandler.setMappings(list3);
                }
                if (error != null) {
                    GithubPullRequestFilesDiffCommentsProvider.Companion.getLOG().info("Failed to load and process file comments", error);
                }
            }
            {
                this.$commentsHandler = githubPullRequestDiffViewerBaseCommentsHandler;
                this.$change = change;
                super(2);
            }
        });
        Disposer.register((Disposable)commentsHandler, (Disposable)disposable2);
    }

    public GithubPullRequestFilesDiffCommentsProvider(@NotNull GithubPullRequestDataProvider dataProvider, @NotNull GithubPullRequestEditorCommentsThreadComponentFactory componentFactory) {
        Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkParameterIsNotNull((Object)componentFactory, (String)"componentFactory");
        this.dataProvider = dataProvider;
        this.componentFactory = componentFactory;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GithubPullRequestFilesDiffCommentsProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$loadAndShowComments(GithubPullRequestFilesDiffCommentsProvider $this, GithubPullRequestDiffViewerBaseCommentsHandler commentsHandler, Change change) {
        $this.loadAndShowComments(commentsHandler, change);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GithubPullRequestFilesDiffCommentsProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

