/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment;

import com.intellij.diff.util.Side;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitCommit;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubPullRequestComment;
import org.jetbrains.plugins.github.api.data.GithubPullRequestCommentWithHtml;
import org.jetbrains.plugins.github.pullrequest.comment.GithubPullRequestCommentsUtil$WhenMappings;
import org.jetbrains.plugins.github.pullrequest.data.model.GithubPullRequestFileCommentsThreadMapping;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004H\u0002JD\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J&\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GithubPullRequestCommentsUtil;", "", "()V", "buildThreads", "", "", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestCommentWithHtml;", "comments", "buildThreadsAndMapLines", "", "Lcom/intellij/openapi/vcs/changes/Change;", "Lorg/jetbrains/plugins/github/pullrequest/data/model/GithubPullRequestFileCommentsThreadMapping;", "repository", "Lgit4idea/repo/GitRepository;", "commits", "Lgit4idea/GitCommit;", "diffFile", "", "calculateLineLocation", "Lkotlin/Pair;", "Lcom/intellij/diff/util/Side;", "", "diff", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "diffLineNumber", "findDiffForChange", "patchReader", "Lcom/intellij/openapi/diff/impl/patch/PatchReader;", "change", "FileChangesTracker", "intellij.vcs.github"})
public final class GithubPullRequestCommentsUtil {
    public static final GithubPullRequestCommentsUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Change, List<GithubPullRequestFileCommentsThreadMapping>> buildThreadsAndMapLines(@NotNull GitRepository repository, @NotNull List<GitCommit> commits, @NotNull String diffFile, @NotNull List<? extends GithubPullRequestCommentWithHtml> comments) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object threadRoot;
        Map $this$groupByTo$iv$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull(commits, (String)"commits");
        Intrinsics.checkParameterIsNotNull((Object)diffFile, (String)"diffFile");
        Intrinsics.checkParameterIsNotNull(comments, (String)"comments");
        Iterable $this$filter$iv = comments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GithubPullRequestCommentWithHtml)element$iv$iv;
            boolean bl = false;
            if (!(((GithubPullRequestComment)it).getPath() != null && ((GithubPullRequestComment)it).getPosition() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List activeFileComments = (List)destination$iv$iv;
        if (activeFileComments.isEmpty()) {
            return MapsKt.emptyMap();
        }
        PatchReader patchReader = new PatchReader((CharSequence)diffFile, true);
        patchReader.parseAllPatches();
        FileChangesTracker fileChangesFinder = new FileChangesTracker(commits);
        Iterable $this$groupBy$iv = this.buildThreads(activeFileComments);
        boolean $i$f$groupBy = false;
        Iterable $i$f$filterTo22 = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        it = $this$groupByTo$iv$iv.iterator();
        while (it.hasNext()) {
            Object object;
            FilePath filePath;
            String commitSha;
            Object element$iv$iv = it.next();
            List it2 = (List)element$iv$iv;
            boolean bl = false;
            threadRoot = (GithubPullRequestCommentWithHtml)CollectionsKt.first((List)it2);
            if (((GithubPullRequestComment)threadRoot).getOriginalCommitId() == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)commitSha, (String)"threadRoot.originalCommitId!!");
            VirtualFile virtualFile = repository.getRoot();
            String string = ((GithubPullRequestComment)threadRoot).getPath();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)VcsUtil.getFilePath((VirtualFile)virtualFile, (String)GitUtil.unescapePath((String)string)), (String)"VcsUtil.getFilePath(repo\u2026ePath(threadRoot.path!!))");
            Change key$iv$iv = fileChangesFinder.traceAndCollectFileChanges(commitSha, filePath);
            $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void $dstr$change$threads;
            void it$iv$iv;
            threadRoot = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl3 = false;
            value$iv$iv$iv = $dstr$change$threads;
            boolean answer$iv$iv$iv = false;
            Change change = (Change)value$iv$iv$iv.getKey();
            value$iv$iv$iv = $dstr$change$threads;
            answer$iv$iv$iv = false;
            List threads2 = (List)value$iv$iv$iv.getValue();
            if (INSTANCE.findDiffForChange(repository, patchReader, change) == null) {
                throw (Throwable)new IllegalStateException("Missing diff for change " + change);
            }
            Iterable $this$map$iv = threads2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair<Side, Integer> pair;
                int diffLineNumber;
                TextFilePatch diff;
                void comments2;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl4 = false;
                Integer n = ((GithubPullRequestCommentWithHtml)CollectionsKt.first((List)comments2)).getPosition();
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                if (INSTANCE.calculateLineLocation(diff, diffLineNumber = n + 1) == null) {
                    throw (Throwable)new IllegalStateException("Invalid diff position ");
                }
                boolean bl5 = false;
                boolean bl6 = false;
                Pair<Side, Integer> $dstr$side$line = pair;
                boolean bl7 = false;
                Side side = (Side)$dstr$side$line.component1();
                int line = ((Number)$dstr$side$line.component2()).intValue();
                GithubPullRequestFileCommentsThreadMapping githubPullRequestFileCommentsThreadMapping = new GithubPullRequestFileCommentsThreadMapping(side, line, (List<? extends GithubPullRequestCommentWithHtml>)comments2);
                collection.add(githubPullRequestFileCommentsThreadMapping);
            }
            List list = (List)destination$iv$iv3;
            map3.put(k2, list);
        }
        return destination$iv$iv2;
    }

    private final TextFilePatch findDiffForChange(GitRepository repository, PatchReader patchReader, Change change) {
        Object v10;
        block5: {
            String string;
            String string2;
            boolean bl;
            ContentRevision contentRevision = change.getBeforeRevision();
            if (contentRevision != null) {
                ContentRevision contentRevision2 = contentRevision;
                boolean bl2 = false;
                bl = false;
                ContentRevision it = contentRevision2;
                boolean bl3 = false;
                VirtualFile virtualFile = repository.getRoot();
                ContentRevision contentRevision3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)contentRevision3, (String)"it");
                string2 = VcsFileUtil.relativePath((VirtualFile)virtualFile, (FilePath)contentRevision3.getFile());
            } else {
                string2 = null;
            }
            String beforePath = string2;
            ContentRevision contentRevision4 = change.getAfterRevision();
            if (contentRevision4 != null) {
                ContentRevision contentRevision5 = contentRevision4;
                bl = false;
                boolean bl4 = false;
                ContentRevision it = contentRevision5;
                boolean bl5 = false;
                VirtualFile virtualFile = repository.getRoot();
                ContentRevision contentRevision6 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)contentRevision6, (String)"it");
                string = VcsFileUtil.relativePath((VirtualFile)virtualFile, (FilePath)contentRevision6.getFile());
            } else {
                string = null;
            }
            String afterPath = string;
            List list = patchReader.getTextPatches();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"patchReader.textPatches");
            Iterable iterable = list;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl6 = false;
            for (Object t : iterable2) {
                TextFilePatch it = (TextFilePatch)t;
                boolean bl7 = false;
                TextFilePatch textFilePatch = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)textFilePatch, (String)"it");
                if (!(Intrinsics.areEqual((Object)textFilePatch.getBeforeName(), (Object)beforePath) && it.isDeletedFile() || Intrinsics.areEqual((Object)it.getAfterName(), (Object)afterPath) && it.isNewFile() || Intrinsics.areEqual((Object)it.getBeforeName(), (Object)beforePath) && Intrinsics.areEqual((Object)it.getAfterName(), (Object)afterPath))) continue;
                v10 = t;
                break block5;
            }
            v10 = null;
        }
        return v10;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<List<GithubPullRequestCommentWithHtml>> buildThreads(Collection<? extends GithubPullRequestCommentWithHtml> comments) {
        Map $this$mapTo$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = comments;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            GithubPullRequestCommentWithHtml it = (GithubPullRequestCommentWithHtml)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getInReplyToId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map commentsByThreadRootId = destination$iv$iv;
        List list = (List)commentsByThreadRootId.get(null);
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List threadRoots = list;
        Iterable $this$map$iv = threadRoots;
        boolean $i$f$map = false;
        Iterable $i$f$groupByTo22 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            key$iv$iv = (GithubPullRequestCommentWithHtml)item$iv$iv;
            Collection collection = destination$iv$iv22;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getId(), (Object)CollectionsKt.mutableListOf((Object[])new GithubPullRequestCommentWithHtml[]{it}));
            collection.add(pair);
        }
        Map threadsByRootId = MapsKt.toMap((Iterable)((List)destination$iv$iv22));
        $this$mapTo$iv$iv = commentsByThreadRootId;
        boolean destination$iv$iv22 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object3 = object = iterator2.next();
            boolean bl = false;
            Long id = (Long)object3.getKey();
            object3 = object;
            bl = false;
            List threadComments = (List)object3.getValue();
            if (id == null) continue;
            List list2 = (List)threadsByRootId.get(id);
            if (list2 == null) continue;
            list2.addAll(threadComments);
        }
        return threadsByRootId.values();
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Side, Integer> calculateLineLocation(TextFilePatch diff, int diffLineNumber) {
        int diffLineCounter = 0;
        Iterator iterator = diff.getHunks().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            int n;
            int hunkLinesCount;
            int n2;
            void $this$count$iv;
            PatchHunk hunk;
            PatchHunk patchHunk = hunk = (PatchHunk)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)patchHunk, (String)"hunk");
            int n3 = patchHunk.getLines().size();
            List list = hunk.getLines();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"hunk.lines");
            Iterable iterable = list;
            int n4 = n3;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    PatchLine it22 = (PatchLine)element$iv;
                    boolean bl = false;
                    PatchLine patchLine = it22;
                    Intrinsics.checkExpressionValueIsNotNull((Object)patchLine, (String)"it");
                    if (!patchLine.isSuppressNewLine()) continue;
                    int it22 = ++count$iv;
                    boolean bl2 = false;
                    if (it22 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            if (diffLineNumber > (diffLineCounter += (hunkLinesCount = n4 + (n = n2) + 1))) continue;
            int hunkLineIndex = diffLineNumber - (diffLineCounter - hunkLinesCount) - 1 - 1;
            PatchLine patchLine = (PatchLine)hunk.getLines().get(hunkLineIndex);
            if (patchLine == null) {
                return null;
            }
            PatchLine line = patchLine;
            PatchLine.Type type = line.getType();
            if (type == null) {
                Intrinsics.throwNpe();
            }
            switch (GithubPullRequestCommentsUtil$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: 
                case 2: {
                    int n5;
                    Iterable $this$count$iv2 = hunk.getLines().subList(0, hunkLineIndex);
                    boolean $i$f$count2 = false;
                    if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                        n5 = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv2) {
                            PatchLine it32 = (PatchLine)element$iv;
                            boolean bl = false;
                            PatchLine patchLine2 = it32;
                            Intrinsics.checkExpressionValueIsNotNull((Object)patchLine2, (String)"it");
                            if (!(patchLine2.getType() == PatchLine.Type.ADD)) continue;
                            int it32 = ++count$iv;
                            bl = false;
                            if (it32 >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n5 = count$iv;
                    }
                    int addedLinesBefore = n5;
                    pair = TuplesKt.to((Object)Side.LEFT, (Object)(hunk.getStartLineBefore() + (hunkLineIndex - addedLinesBefore) + 1));
                    break;
                }
                case 3: {
                    int n6;
                    Iterable $this$count$iv2 = hunk.getLines().subList(0, hunkLineIndex);
                    boolean $i$f$count3 = false;
                    if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                        n6 = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv2) {
                            PatchLine it = (PatchLine)element$iv;
                            boolean bl = false;
                            PatchLine patchLine3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)patchLine3, (String)"it");
                            if (!(patchLine3.getType() == PatchLine.Type.REMOVE)) continue;
                            int n7 = ++count$iv;
                            boolean bl3 = false;
                            if (n7 >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n6 = count$iv;
                    }
                    int removedLinesBefore = n6;
                    pair = TuplesKt.to((Object)Side.RIGHT, (Object)(hunk.getStartLineAfter() + (hunkLineIndex - removedLinesBefore) + 1));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pair;
        }
        return null;
    }

    private GithubPullRequestCommentsUtil() {
    }

    static {
        GithubPullRequestCommentsUtil githubPullRequestCommentsUtil;
        INSTANCE = githubPullRequestCommentsUtil = new GithubPullRequestCommentsUtil();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J&\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J&\u0010\u0011\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\nR&\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GithubPullRequestCommentsUtil$FileChangesTracker;", "", "commits", "", "Lgit4idea/GitCommit;", "(Ljava/util/List;)V", "cache", "", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vcs/FilePath;", "Lcom/intellij/openapi/vcs/changes/Change;", "buildRevisionChainHead", "", "chain", "", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "buildRevisionChainTail", "doTraceAndCollectChanges", "commitSha", "filePath", "findCommitIndex", "", "traceAndCollectFileChanges", "intellij.vcs.github"})
    private static final class FileChangesTracker {
        private final Map<Pair<String, FilePath>, Change> cache;
        private final List<GitCommit> commits;

        @NotNull
        public final Change traceAndCollectFileChanges(@NotNull String commitSha, @NotNull FilePath filePath) throws IllegalStateException {
            Intrinsics.checkParameterIsNotNull((Object)commitSha, (String)"commitSha");
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            Map<Pair<String, FilePath>, Change> map2 = this.cache;
            Pair pair = TuplesKt.to((Object)commitSha, (Object)filePath);
            boolean bl = false;
            Change change = map2.get(pair);
            if (change == null) {
                boolean bl2 = false;
                change = this.doTraceAndCollectChanges(commitSha, filePath);
            }
            return change;
        }

        private final Change doTraceAndCollectChanges(String commitSha, FilePath filePath) {
            int commitIndex = this.findCommitIndex(commitSha);
            Change referencedChange = null;
            for (GitCommit commit : CollectionsKt.asReversed(this.commits.subList(0, commitIndex + 1))) {
                Change change;
                Object v1;
                block4: {
                    Collection collection = commit.getChanges();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"commit.changes");
                    Iterable iterable = collection;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        Change it = (Change)t;
                        boolean bl3 = false;
                        if (!ChangesUtil.isAffectedByChange((FilePath)filePath, (Change)it)) continue;
                        v1 = t;
                        break block4;
                    }
                    v1 = null;
                }
                if ((change = (Change)v1) == null) continue;
                referencedChange = change;
            }
            if (referencedChange == null) {
                throw (Throwable)new IllegalStateException("Can't find file " + filePath + " change in " + commitSha);
            }
            boolean bl = false;
            List revisionChain = new ArrayList();
            revisionChain.add(referencedChange.getBeforeRevision());
            this.buildRevisionChainHead(revisionChain, this.commits.subList(0, commitIndex));
            revisionChain.add(referencedChange.getAfterRevision());
            this.buildRevisionChainTail(revisionChain, this.commits.subList(commitIndex + 1, this.commits.size()));
            Change summaryChange = new Change((ContentRevision)CollectionsKt.first((List)revisionChain), (ContentRevision)CollectionsKt.last((List)revisionChain));
            for (ContentRevision revision : revisionChain) {
                if (revision == null) continue;
                this.cache.put((Pair<String, FilePath>)TuplesKt.to((Object)revision.getRevisionNumber().asString(), (Object)revision.getFile()), summaryChange);
            }
            return summaryChange;
        }

        private final void buildRevisionChainHead(List<ContentRevision> chain2, List<GitCommit> commits) {
            for (GitCommit commit : CollectionsKt.asReversed(commits)) {
                Change change;
                Object v4;
                block4: {
                    ContentRevision contentRevision = (ContentRevision)CollectionsKt.first(chain2);
                    if (contentRevision == null || (contentRevision = contentRevision.getFile()) == null) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)contentRevision, (String)"chain.first()?.file ?: return");
                    ContentRevision lastKnownFilePath = contentRevision;
                    Collection collection = commit.getChanges();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"commit.changes");
                    Iterable iterable = collection;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        Change it = (Change)t;
                        boolean bl3 = false;
                        Change change2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)change2, (String)"it");
                        ContentRevision contentRevision2 = change2.getAfterRevision();
                        if (!Intrinsics.areEqual((Object)(contentRevision2 != null ? contentRevision2.getFile() : null), (Object)lastKnownFilePath)) continue;
                        v4 = t;
                        break block4;
                    }
                    v4 = null;
                }
                if ((Change)v4 == null) {
                    continue;
                }
                chain2.add(0, change.getBeforeRevision());
            }
        }

        private final void buildRevisionChainTail(List<ContentRevision> chain2, List<GitCommit> commits) {
            for (GitCommit commit : commits) {
                Change change;
                Object v4;
                block4: {
                    ContentRevision contentRevision = (ContentRevision)CollectionsKt.last(chain2);
                    if (contentRevision == null || (contentRevision = contentRevision.getFile()) == null) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)contentRevision, (String)"chain.last()?.file ?: return");
                    ContentRevision lastKnownFilePath = contentRevision;
                    Collection collection = commit.getChanges();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"commit.changes");
                    Iterable iterable = collection;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        Change it = (Change)t;
                        boolean bl3 = false;
                        Change change2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)change2, (String)"it");
                        ContentRevision contentRevision2 = change2.getBeforeRevision();
                        if (!Intrinsics.areEqual((Object)lastKnownFilePath, (Object)(contentRevision2 != null ? contentRevision2.getFile() : null))) continue;
                        v4 = t;
                        break block4;
                    }
                    v4 = null;
                }
                if ((Change)v4 == null) {
                    continue;
                }
                chain2.add(change.getAfterRevision());
            }
        }

        private final int findCommitIndex(String commitSha) {
            int index;
            block3: {
                int n;
                List<GitCommit> $this$indexOfFirst$iv = this.commits;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<GitCommit> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    GitCommit item$iv;
                    GitCommit it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getId().asString(), (Object)commitSha)) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index < 0) {
                throw (Throwable)new IllegalStateException("Can't find commit " + commitSha);
            }
            return index;
        }

        public FileChangesTracker(@NotNull List<GitCommit> commits) {
            Map map2;
            Intrinsics.checkParameterIsNotNull(commits, (String)"commits");
            this.commits = commits;
            FileChangesTracker fileChangesTracker = this;
            boolean bl = false;
            fileChangesTracker.cache = map2 = (Map)new LinkedHashMap();
        }
    }
}

