/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.OnePixelSplitter;
import git4idea.commands.Git;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestKeys;
import org.jetbrains.plugins.github.pullrequest.action.GithubPullRequestsDataContext;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GithubPullRequestEditorCommentsThreadComponentFactoryImpl;
import org.jetbrains.plugins.github.pullrequest.config.GithubPullRequestsProjectUISettings;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsBusyStateTracker;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsBusyStateTrackerImpl;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsDataLoader;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsDataLoaderImpl;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsListLoaderImpl;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsRepositoryDataLoader;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsRepositoryDataLoaderImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsMetadataServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsSecurityServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsStateServiceImpl;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestChangesComponent;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestDetailsComponent;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestPreviewComponent;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestsListSelectionHolder;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestsListSelectionHolderImpl;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestsListWithSearchPanel;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubImageResizer;
import org.jetbrains.plugins.github.util.GithubSharedProjectSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001%BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J8\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GithubPullRequestsComponentFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "git", "Lgit4idea/commands/Git;", "avatarLoader", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "imageResizer", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "autoPopupController", "Lcom/intellij/codeInsight/AutoPopupController;", "sharedProjectSettings", "Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;", "pullRequestUiSettings", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/ide/CopyPasteManager;Lcom/intellij/openapi/progress/ProgressManager;Lgit4idea/commands/Git;Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;Lorg/jetbrains/plugins/github/util/GithubImageResizer;Lcom/intellij/openapi/actionSystem/ActionManager;Lcom/intellij/codeInsight/AutoPopupController;Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;)V", "createComponent", "Ljavax/swing/JComponent;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "accountDetails", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "repoDetails", "Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "GithubPullRequestsComponent", "intellij.vcs.github"})
public final class GithubPullRequestsComponentFactory {
    private final Project project;
    private final CopyPasteManager copyPasteManager;
    private final ProgressManager progressManager;
    private final Git git;
    private final CachingGithubUserAvatarLoader avatarLoader;
    private final GithubImageResizer imageResizer;
    private final ActionManager actionManager;
    private final AutoPopupController autoPopupController;
    private final GithubSharedProjectSettings sharedProjectSettings;
    private final GithubPullRequestsProjectUISettings pullRequestUiSettings;

    @Nullable
    public final JComponent createComponent(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GithubAuthenticatedUser accountDetails, @NotNull GithubRepoDetailed repoDetails, @NotNull GithubAccount account) {
        Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
        Intrinsics.checkParameterIsNotNull((Object)accountDetails, (String)"accountDetails");
        Intrinsics.checkParameterIsNotNull((Object)repoDetails, (String)"repoDetails");
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory = new CachingGithubAvatarIconsProvider.Factory(this.avatarLoader, this.imageResizer, requestExecutor);
        return (JComponent)((Object)new GithubPullRequestsComponent(requestExecutor, avatarIconsProviderFactory, this.pullRequestUiSettings, repository, remote, accountDetails, repoDetails, account));
    }

    public GithubPullRequestsComponentFactory(@NotNull Project project, @NotNull CopyPasteManager copyPasteManager, @NotNull ProgressManager progressManager, @NotNull Git git, @NotNull CachingGithubUserAvatarLoader avatarLoader, @NotNull GithubImageResizer imageResizer, @NotNull ActionManager actionManager, @NotNull AutoPopupController autoPopupController, @NotNull GithubSharedProjectSettings sharedProjectSettings, @NotNull GithubPullRequestsProjectUISettings pullRequestUiSettings) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)copyPasteManager, (String)"copyPasteManager");
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        Intrinsics.checkParameterIsNotNull((Object)git, (String)"git");
        Intrinsics.checkParameterIsNotNull((Object)avatarLoader, (String)"avatarLoader");
        Intrinsics.checkParameterIsNotNull((Object)imageResizer, (String)"imageResizer");
        Intrinsics.checkParameterIsNotNull((Object)actionManager, (String)"actionManager");
        Intrinsics.checkParameterIsNotNull((Object)autoPopupController, (String)"autoPopupController");
        Intrinsics.checkParameterIsNotNull((Object)sharedProjectSettings, (String)"sharedProjectSettings");
        Intrinsics.checkParameterIsNotNull((Object)pullRequestUiSettings, (String)"pullRequestUiSettings");
        this.project = project;
        this.copyPasteManager = copyPasteManager;
        this.progressManager = progressManager;
        this.git = git;
        this.avatarLoader = avatarLoader;
        this.imageResizer = imageResizer;
        this.actionManager = actionManager;
        this.autoPopupController = autoPopupController;
        this.sharedProjectSettings = sharedProjectSettings;
        this.pullRequestUiSettings = pullRequestUiSettings;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BE\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u00101\u001a\u000202H\u0016J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u000206H\u0016R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GithubPullRequestsComponentFactory$GithubPullRequestsComponent;", "Lcom/intellij/ui/OnePixelSplitter;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "avatarIconsProviderFactory", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "pullRequestUiSettings", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "accountDetails", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "repoDetails", "Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "(Lorg/jetbrains/plugins/github/pullrequest/GithubPullRequestsComponentFactory;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;)V", "busyStateTracker", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTrackerImpl;", "changes", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent;", "dataContext", "Lorg/jetbrains/plugins/github/pullrequest/action/GithubPullRequestsDataContext;", "dataLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoaderImpl;", "details", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestDetailsComponent;", "diffCommentComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GithubPullRequestEditorCommentsThreadComponentFactoryImpl;", "list", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsListWithSearchPanel;", "listLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsListLoaderImpl;", "listSelectionHolder", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsListSelectionHolderImpl;", "metadataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsMetadataServiceImpl;", "preview", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestPreviewComponent;", "repoDataLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsRepositoryDataLoaderImpl;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsSecurityServiceImpl;", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsStateServiceImpl;", "dispose", "", "getData", "", "dataId", "", "intellij.vcs.github"})
    public final class GithubPullRequestsComponent
    extends OnePixelSplitter
    implements Disposable,
    DataProvider {
        private final GithubPullRequestsRepositoryDataLoaderImpl repoDataLoader;
        private final GithubPullRequestsListLoaderImpl listLoader;
        private final GithubPullRequestsListSelectionHolderImpl listSelectionHolder;
        private final GithubPullRequestsDataLoaderImpl dataLoader;
        private final GithubPullRequestsSecurityServiceImpl securityService;
        private final GithubPullRequestsBusyStateTrackerImpl busyStateTracker;
        private final GithubPullRequestsMetadataServiceImpl metadataService;
        private final GithubPullRequestsStateServiceImpl stateService;
        private final GithubPullRequestEditorCommentsThreadComponentFactoryImpl diffCommentComponentFactory;
        private final GithubPullRequestChangesComponent changes;
        private final GithubPullRequestDetailsComponent details;
        private final GithubPullRequestPreviewComponent preview;
        private final GithubPullRequestsListWithSearchPanel list;
        private final GithubPullRequestsDataContext dataContext;

        @Nullable
        public Object getData(@NotNull String dataId) {
            Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
            if (Disposer.isDisposed((Disposable)this)) {
                return null;
            }
            return GithubPullRequestKeys.getDATA_CONTEXT().is(dataId) ? this.dataContext : null;
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.list);
            Disposer.dispose((Disposable)this.preview);
            Disposer.dispose((Disposable)this.changes);
            Disposer.dispose((Disposable)this.details);
            Disposer.dispose((Disposable)this.repoDataLoader);
            Disposer.dispose((Disposable)this.listLoader);
            Disposer.dispose((Disposable)this.dataLoader);
        }

        public GithubPullRequestsComponent(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory, @NotNull GithubPullRequestsProjectUISettings pullRequestUiSettings, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GithubAuthenticatedUser accountDetails, @NotNull GithubRepoDetailed repoDetails, GithubAccount account) {
            GithubPullRequestChangesComponent githubPullRequestChangesComponent;
            Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
            Intrinsics.checkParameterIsNotNull((Object)avatarIconsProviderFactory, (String)"avatarIconsProviderFactory");
            Intrinsics.checkParameterIsNotNull((Object)pullRequestUiSettings, (String)"pullRequestUiSettings");
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
            Intrinsics.checkParameterIsNotNull((Object)accountDetails, (String)"accountDetails");
            Intrinsics.checkParameterIsNotNull((Object)repoDetails, (String)"repoDetails");
            Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
            super("Github.PullRequests.Component", 0.33f);
            ProgressManager progressManager = GithubPullRequestsComponentFactory.this.progressManager;
            GithubServerPath githubServerPath = account.getServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
            GithubFullPath githubFullPath = repoDetails.getFullPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubFullPath, (String)"repoDetails.fullPath");
            this.repoDataLoader = new GithubPullRequestsRepositoryDataLoaderImpl(progressManager, requestExecutor, githubServerPath, githubFullPath);
            ProgressManager progressManager2 = GithubPullRequestsComponentFactory.this.progressManager;
            GithubServerPath githubServerPath2 = account.getServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath2, (String)"account.server");
            GithubFullPath githubFullPath2 = repoDetails.getFullPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubFullPath2, (String)"repoDetails.fullPath");
            this.listLoader = new GithubPullRequestsListLoaderImpl(progressManager2, requestExecutor, githubServerPath2, githubFullPath2);
            this.listSelectionHolder = new GithubPullRequestsListSelectionHolderImpl();
            Project project = GithubPullRequestsComponentFactory.this.project;
            ProgressManager progressManager3 = GithubPullRequestsComponentFactory.this.progressManager;
            Git git = GithubPullRequestsComponentFactory.this.git;
            GithubServerPath githubServerPath3 = account.getServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath3, (String)"account.server");
            GithubFullPath githubFullPath3 = repoDetails.getFullPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubFullPath3, (String)"repoDetails.fullPath");
            this.dataLoader = new GithubPullRequestsDataLoaderImpl(project, progressManager3, git, requestExecutor, repository, remote, githubServerPath3, githubFullPath3);
            this.securityService = new GithubPullRequestsSecurityServiceImpl(GithubPullRequestsComponentFactory.this.sharedProjectSettings, accountDetails, repoDetails);
            this.busyStateTracker = new GithubPullRequestsBusyStateTrackerImpl();
            Project project2 = GithubPullRequestsComponentFactory.this.project;
            ProgressManager progressManager4 = GithubPullRequestsComponentFactory.this.progressManager;
            GithubPullRequestsRepositoryDataLoader githubPullRequestsRepositoryDataLoader = this.repoDataLoader;
            GithubPullRequestsListLoader githubPullRequestsListLoader = this.listLoader;
            GithubPullRequestsDataLoader githubPullRequestsDataLoader = this.dataLoader;
            GithubPullRequestsBusyStateTracker githubPullRequestsBusyStateTracker = this.busyStateTracker;
            GithubServerPath githubServerPath4 = account.getServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath4, (String)"account.server");
            GithubFullPath githubFullPath4 = repoDetails.getFullPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubFullPath4, (String)"repoDetails.fullPath");
            this.metadataService = new GithubPullRequestsMetadataServiceImpl(project2, progressManager4, githubPullRequestsRepositoryDataLoader, githubPullRequestsListLoader, githubPullRequestsDataLoader, githubPullRequestsBusyStateTracker, requestExecutor, avatarIconsProviderFactory, githubServerPath4, githubFullPath4);
            Project project3 = GithubPullRequestsComponentFactory.this.project;
            ProgressManager progressManager5 = GithubPullRequestsComponentFactory.this.progressManager;
            GithubPullRequestsListLoader githubPullRequestsListLoader2 = this.listLoader;
            GithubPullRequestsDataLoader githubPullRequestsDataLoader2 = this.dataLoader;
            GithubPullRequestsBusyStateTracker githubPullRequestsBusyStateTracker2 = this.busyStateTracker;
            GithubServerPath githubServerPath5 = account.getServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath5, (String)"account.server");
            GithubFullPath githubFullPath5 = repoDetails.getFullPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubFullPath5, (String)"repoDetails.fullPath");
            this.stateService = new GithubPullRequestsStateServiceImpl(project3, progressManager5, githubPullRequestsListLoader2, githubPullRequestsDataLoader2, githubPullRequestsBusyStateTracker2, requestExecutor, githubServerPath5, githubFullPath5);
            this.diffCommentComponentFactory = new GithubPullRequestEditorCommentsThreadComponentFactoryImpl(avatarIconsProviderFactory);
            GithubPullRequestChangesComponent githubPullRequestChangesComponent2 = new GithubPullRequestChangesComponent(GithubPullRequestsComponentFactory.this.project, pullRequestUiSettings, this.diffCommentComponentFactory);
            GithubPullRequestsComponent githubPullRequestsComponent = this;
            boolean bl = false;
            boolean bl2 = false;
            GithubPullRequestChangesComponent $this$apply = githubPullRequestChangesComponent2;
            boolean bl3 = false;
            $this$apply.getDiffAction().registerCustomShortcutSet((JComponent)((Object)this), (Disposable)this);
            githubPullRequestsComponent.changes = githubPullRequestChangesComponent = githubPullRequestChangesComponent2;
            this.details = new GithubPullRequestDetailsComponent(this.dataLoader, this.securityService, this.busyStateTracker, this.metadataService, this.stateService, avatarIconsProviderFactory);
            this.preview = new GithubPullRequestPreviewComponent(this.changes, this.details);
            this.list = new GithubPullRequestsListWithSearchPanel(GithubPullRequestsComponentFactory.this.project, GithubPullRequestsComponentFactory.this.copyPasteManager, GithubPullRequestsComponentFactory.this.actionManager, GithubPullRequestsComponentFactory.this.autoPopupController, avatarIconsProviderFactory, this.listLoader, this.dataLoader, this.listLoader, this.listLoader, this.listSelectionHolder);
            GithubPullRequestsRepositoryDataLoader githubPullRequestsRepositoryDataLoader2 = this.repoDataLoader;
            GithubPullRequestsListLoader githubPullRequestsListLoader3 = this.listLoader;
            GithubPullRequestsListSelectionHolder githubPullRequestsListSelectionHolder = this.listSelectionHolder;
            GithubPullRequestsDataLoader githubPullRequestsDataLoader3 = this.dataLoader;
            GithubServerPath githubServerPath6 = account.getServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath6, (String)"account.server");
            this.dataContext = new GithubPullRequestsDataContext(requestExecutor, githubPullRequestsRepositoryDataLoader2, githubPullRequestsListLoader3, githubPullRequestsListSelectionHolder, githubPullRequestsDataLoader3, githubServerPath6, repoDetails, accountDetails, repository, remote);
            this.setFirstComponent((JComponent)((Object)this.list));
            this.setSecondComponent((JComponent)((Object)this.preview));
            this.setFocusCycleRoot(true);
            this.listSelectionHolder.addSelectionChangeListener(this.preview, (Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    GithubPullRequestDataProvider githubPullRequestDataProvider;
                    GithubPullRequestPreviewComponent githubPullRequestPreviewComponent = preview;
                    Long l = listSelectionHolder.getSelectionNumber();
                    if (l != null) {
                        Long l2 = l;
                        GithubPullRequestsDataLoaderImpl githubPullRequestsDataLoaderImpl = dataLoader;
                        GithubPullRequestPreviewComponent githubPullRequestPreviewComponent2 = githubPullRequestPreviewComponent;
                        boolean bl = false;
                        boolean bl2 = false;
                        long p1 = ((Number)l2).longValue();
                        boolean bl3 = false;
                        GithubPullRequestDataProvider githubPullRequestDataProvider2 = githubPullRequestsDataLoaderImpl.getDataProvider(p1);
                        githubPullRequestPreviewComponent = githubPullRequestPreviewComponent2;
                        githubPullRequestDataProvider = githubPullRequestDataProvider2;
                    } else {
                        githubPullRequestDataProvider = null;
                    }
                    githubPullRequestPreviewComponent.setDataProvider(githubPullRequestDataProvider);
                }
            }));
            this.dataLoader.addInvalidationListener(this.preview, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(){

                public final void invoke(long it) {
                    Long selection = listSelectionHolder.getSelectionNumber();
                    if (selection != null && selection == it) {
                        preview.setDataProvider(dataLoader.getDataProvider(selection));
                    }
                }
            }));
        }
    }
}

