/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.progress.ProgressVisibilityManager;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountDecorator;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountDecoratorRenderer;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountsPanel;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubImageResizer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b*\u0002\u0018\u001f\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010!\u001a\u00020\"H\u0002J\u0006\u0010#\u001a\u00020\"J\r\u0010$\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010%J\r\u0010&\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\"H\u0016J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u0010H\u0002J\"\u0010+\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150,J\u0018\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u000200H\u0002J\u001e\u00101\u001a\u00020\u001b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0015032\b\u00104\u001a\u0004\u0018\u00010\u0015J\u0010\u00105\u001a\u00020\"2\u0006\u00106\u001a\u00020\u0010H\u0002J\u0006\u00107\u001a\u00020\"J&\u00108\u001a\u00020\"2\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00142\b\u00104\u001a\u0004\u0018\u00010\u0015J\u0010\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u001bH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "avatarLoader", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "imageResizer", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;Lorg/jetbrains/plugins/github/util/GithubImageResizer;)V", "accountIconSize", "Lcom/intellij/util/ui/JBValue$UIInteger;", "accountList", "Lcom/intellij/ui/components/JBList;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountDecorator;", "accountListModel", "Lcom/intellij/ui/CollectionListModel;", "currentTokensMap", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "errorLinkHandler", "org/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createLinkActivationListener$1", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createLinkActivationListener$1;", "errorLinkHandlerInstalled", "", "newTokensMap", "", "progressManager", "org/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createListProgressManager$1", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createListProgressManager$1;", "addAccount", "", "clearNewTokens", "createLinkActivationListener", "()Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createLinkActivationListener$1;", "createListProgressManager", "()Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createListProgressManager$1;", "dispose", "editAccount", "decorator", "getAccounts", "Lkotlin/Pair;", "isAccountUnique", "login", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "isModified", "accounts", "", "defaultAccount", "loadAccountDetails", "accountData", "loadExistingAccountsDetails", "setAccounts", "setLinkHandlerEnabled", "enabled", "intellij.vcs.github"})
public final class GithubAccountsPanel
extends BorderLayoutPanel
implements Disposable {
    private final JBValue.UIInteger accountIconSize;
    private final CollectionListModel<GithubAccountDecorator> accountListModel;
    private final JBList<GithubAccountDecorator> accountList;
    private final createListProgressManager.1 progressManager;
    private final createLinkActivationListener.1 errorLinkHandler;
    private boolean errorLinkHandlerInstalled;
    private Map<GithubAccount, String> currentTokensMap;
    private final Map<GithubAccount, String> newTokensMap;
    private final Project project;
    private final GithubApiRequestExecutor.Factory executorFactory;
    private final CachingGithubUserAvatarLoader avatarLoader;
    private final GithubImageResizer imageResizer;

    private final void addAccount() {
        GithubLoginDialog dialog2 = new GithubLoginDialog(this.executorFactory, this.project, (Component)((Object)this), (Function2)new Function2<String, GithubServerPath, Boolean>(this){

            public final boolean invoke(@NotNull String p1, @NotNull GithubServerPath p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return GithubAccountsPanel.access$isAccountUnique((GithubAccountsPanel)((Object)this.receiver), p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GithubAccountsPanel.class);
            }

            public final String getName() {
                return "isAccountUnique";
            }

            public final String getSignature() {
                return "isAccountUnique(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GithubServerPath;)Z";
            }
        }, null, null, 48, null);
        if (dialog2.showAndGet()) {
            GithubAccount githubAccount = GithubAccountManager.Companion.createAccount(dialog2.getLogin(), dialog2.getServer());
            this.newTokensMap.put(githubAccount, dialog2.getToken());
            GithubAccountDecorator accountData = new GithubAccountDecorator(githubAccount, false);
            this.accountListModel.add((Object)accountData);
            this.loadAccountDetails(accountData);
        }
    }

    private final void editAccount(GithubAccountDecorator decorator) {
        GithubLoginDialog githubLoginDialog = new GithubLoginDialog(this.executorFactory, this.project, (Component)((Object)this), null, null, null, 56, null);
        boolean bl = false;
        boolean bl2 = false;
        GithubLoginDialog $this$apply = githubLoginDialog;
        boolean bl3 = false;
        String string = decorator.getAccount().getServer().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"decorator.account.server.toString()");
        $this$apply.withServer(string, false);
        GithubLoginDialog.withCredentials$default($this$apply, decorator.getAccount().getName(), null, false, 6, null);
        GithubLoginDialog dialog2 = githubLoginDialog;
        if (dialog2.showAndGet()) {
            decorator.getAccount().setName(dialog2.getLogin());
            this.newTokensMap.put(decorator.getAccount(), dialog2.getToken());
            this.loadAccountDetails(decorator);
        }
    }

    private final boolean isAccountUnique(String login2, GithubServerPath server) {
        boolean bl;
        block3: {
            List list = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"accountListModel.items");
            Iterable $this$none$iv = list;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GithubAccountDecorator it = (GithubAccountDecorator)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getAccount().getName(), (Object)login2) && Intrinsics.areEqual((Object)it.getAccount().getServer(), (Object)server))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final createLinkActivationListener.1 createLinkActivationListener() {
        return new MouseAdapter(this){
            final /* synthetic */ GithubAccountsPanel this$0;

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Point point = e.getPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"e.point");
                GithubAccountDecorator decorator = this.findDecoratorWithLoginLinkAt(point);
                if (decorator != null) {
                    UIUtil.setCursor((Component)((Component)GithubAccountsPanel.access$getAccountList$p(this.this$0)), (Cursor)Cursor.getPredefinedCursor(12));
                } else {
                    UIUtil.setCursor((Component)((Component)GithubAccountsPanel.access$getAccountList$p(this.this$0)), (Cursor)Cursor.getDefaultCursor());
                }
                boolean hasChanges = false;
                for (GithubAccountDecorator item : GithubAccountsPanel.access$getAccountListModel$p(this.this$0).getItems()) {
                    boolean isLinkPointedAt = Intrinsics.areEqual((Object)item, (Object)decorator);
                    hasChanges = hasChanges || isLinkPointedAt != item.getErrorLinkPointedAt();
                    item.setErrorLinkPointedAt(isLinkPointedAt);
                }
                if (hasChanges) {
                    GithubAccountsPanel.access$getAccountListModel$p(this.this$0).allContentsChanged();
                }
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    Point point = e.getPoint();
                    Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"e.point");
                    GithubAccountDecorator githubAccountDecorator = this.findDecoratorWithLoginLinkAt(point);
                    if (githubAccountDecorator == null) break block0;
                    GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                    GithubAccountsPanel githubAccountsPanel = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    GithubAccountDecorator p1 = githubAccountDecorator2;
                    boolean bl3 = false;
                    GithubAccountsPanel.access$editAccount(githubAccountsPanel, p1);
                }
            }

            private final GithubAccountDecorator findDecoratorWithLoginLinkAt(Point point) {
                GithubAccountDecorator decorator;
                int idx = GithubAccountsPanel.access$getAccountList$p(this.this$0).locationToIndex(point);
                if (idx < 0) {
                    return null;
                }
                Rectangle cellBounds = GithubAccountsPanel.access$getAccountList$p(this.this$0).getCellBounds(idx, idx);
                if (!cellBounds.contains(point)) {
                    return null;
                }
                GithubAccountDecorator githubAccountDecorator = decorator = (GithubAccountDecorator)GithubAccountsPanel.access$getAccountListModel$p(this.this$0).getElementAt(idx);
                if ((githubAccountDecorator != null ? githubAccountDecorator.getLoadingError() : null) == null) {
                    return null;
                }
                Component rendererComponent = GithubAccountsPanel.access$getAccountList$p(this.this$0).getCellRenderer().getListCellRendererComponent((JList)GithubAccountsPanel.access$getAccountList$p(this.this$0), decorator, idx, true, true);
                rendererComponent.setBounds(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
                UIUtil.layoutRecursively((Component)rendererComponent);
                int rendererRelativeX = point.x - cellBounds.x;
                int rendererRelativeY = point.y - cellBounds.y;
                Component childComponent = UIUtil.getDeepestComponentAt((Component)rendererComponent, (int)rendererRelativeX, (int)rendererRelativeY);
                if (!(childComponent instanceof SimpleColoredComponent)) {
                    return null;
                }
                Container container = ((SimpleColoredComponent)childComponent).getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)container, (String)"childComponent.parent");
                int childRelativeX = rendererRelativeX - container.getX() - ((SimpleColoredComponent)childComponent).getX();
                return Intrinsics.areEqual((Object)((SimpleColoredComponent)childComponent).getFragmentTagAt(childRelativeX), (Object)"EDIT_LINK") ? decorator : null;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    private final void setLinkHandlerEnabled(boolean enabled) {
        if (enabled) {
            if (!this.errorLinkHandlerInstalled) {
                this.accountList.addMouseListener((MouseListener)this.errorLinkHandler);
                this.accountList.addMouseMotionListener((MouseMotionListener)this.errorLinkHandler);
                this.errorLinkHandlerInstalled = true;
            }
        } else if (this.errorLinkHandlerInstalled) {
            this.accountList.removeMouseListener((MouseListener)this.errorLinkHandler);
            this.accountList.removeMouseMotionListener((MouseMotionListener)this.errorLinkHandler);
            this.errorLinkHandlerInstalled = false;
        }
    }

    public final void loadExistingAccountsDetails() {
        Iterator iterator = this.accountListModel.getItems().iterator();
        while (iterator.hasNext()) {
            GithubAccountDecorator accountData;
            GithubAccountDecorator githubAccountDecorator = accountData = (GithubAccountDecorator)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubAccountDecorator, (String)"accountData");
            this.loadAccountDetails(githubAccountDecorator);
        }
    }

    private final void loadAccountDetails(GithubAccountDecorator accountData) {
        String token;
        GithubAccount account = accountData.getAccount();
        String string = this.newTokensMap.get(account);
        if (string == null) {
            string = token = this.currentTokensMap.get(account);
        }
        if (token == null) {
            GithubAccountDecorator githubAccountDecorator = accountData;
            CollectionListModel<GithubAccountDecorator> collectionListModel = this.accountListModel;
            boolean bl = false;
            boolean bl2 = false;
            GithubAccountDecorator $this$apply = githubAccountDecorator;
            boolean bl3 = false;
            $this$apply.setLoadingError("Missing access token");
            $this$apply.setShowLoginLink(true);
            GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
            collectionListModel.contentsChanged((Object)githubAccountDecorator2);
            return;
        }
        GithubApiRequestExecutor.WithTokenAuth executor = this.executorFactory.create(token);
        this.progressManager.run(new Task.Backgroundable(this, executor, account, accountData, this.project, "Not Visible"){
            @NotNull
            public GithubAuthenticatedUser loadedDetails;
            final /* synthetic */ GithubAccountsPanel this$0;
            final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $executor;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ GithubAccountDecorator $accountData;

            @NotNull
            public final GithubAuthenticatedUser getLoadedDetails() {
                GithubAuthenticatedUser githubAuthenticatedUser = this.loadedDetails;
                if (githubAuthenticatedUser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"loadedDetails");
                }
                return githubAuthenticatedUser;
            }

            public final void setLoadedDetails(@NotNull GithubAuthenticatedUser githubAuthenticatedUser) {
                Intrinsics.checkParameterIsNotNull((Object)githubAuthenticatedUser, (String)"<set-?>");
                this.loadedDetails = githubAuthenticatedUser;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                GithubServerPath githubServerPath = this.$account.getServer();
                Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
                this.loadedDetails = this.$executor.execute(indicator, GithubApiRequests.CurrentUser.get(githubServerPath));
            }

            public void onSuccess() {
                GithubAccountDecorator githubAccountDecorator = this.$accountData;
                CollectionListModel collectionListModel = GithubAccountsPanel.access$getAccountListModel$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                GithubAccountDecorator $this$apply = githubAccountDecorator;
                boolean bl3 = false;
                GithubAuthenticatedUser githubAuthenticatedUser = this.loadedDetails;
                if (githubAuthenticatedUser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"loadedDetails");
                }
                $this$apply.setDetails(githubAuthenticatedUser);
                $this$apply.setIconProvider(new CachingGithubAvatarIconsProvider(GithubAccountsPanel.access$getAvatarLoader$p(this.this$0), GithubAccountsPanel.access$getImageResizer$p(this.this$0), this.$executor, (JBValue)GithubAccountsPanel.access$getAccountIconSize$p(this.this$0), (Component)GithubAccountsPanel.access$getAccountList$p(this.this$0)));
                $this$apply.setLoadingError(null);
                $this$apply.setShowLoginLink(false);
                GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                collectionListModel.contentsChanged((Object)githubAccountDecorator2);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubAccountDecorator githubAccountDecorator = this.$accountData;
                CollectionListModel collectionListModel = GithubAccountsPanel.access$getAccountListModel$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                GithubAccountDecorator $this$apply = githubAccountDecorator;
                boolean bl3 = false;
                $this$apply.setLoadingError(String.valueOf(error.getMessage()));
                $this$apply.setShowLoginLink(error instanceof GithubAuthenticationException);
                GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                collectionListModel.contentsChanged((Object)githubAccountDecorator2);
            }
            {
                this.this$0 = $outer;
                this.$executor = $captured_local_variable$1;
                this.$account = $captured_local_variable$2;
                this.$accountData = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5);
            }
        });
    }

    private final createListProgressManager.1 createListProgressManager() {
        return new ProgressVisibilityManager(this){
            final /* synthetic */ GithubAccountsPanel this$0;

            protected void setProgressVisible(boolean visible) {
                GithubAccountsPanel.access$getAccountList$p(this.this$0).setPaintBusy(visible);
            }

            @NotNull
            protected ModalityState getModalityState() {
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"ModalityState.any()");
                return modalityState;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final void setAccounts(@NotNull Map<GithubAccount, String> accounts, @Nullable GithubAccount defaultAccount) {
        Collection<GithubAccountDecorator> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(accounts, (String)"accounts");
        this.accountListModel.removeAll();
        Iterable iterable = accounts.keySet();
        int n = 0;
        CollectionListModel<GithubAccountDecorator> collectionListModel = this.accountListModel;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GithubAccount githubAccount = (GithubAccount)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            GithubAccountDecorator githubAccountDecorator = new GithubAccountDecorator((GithubAccount)it, Intrinsics.areEqual((Object)it, (Object)defaultAccount));
            collection.add(githubAccountDecorator);
        }
        collection = (List)destination$iv$iv;
        collectionListModel.addAll(n, (List)collection);
        this.currentTokensMap = accounts;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Map<GithubAccount, String>, GithubAccount> getAccounts() {
        Object v2;
        Map map2;
        block2: {
            void $this$associateTo$iv$iv;
            List list = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"accountListModel.items");
            Iterable $this$associate$iv = list;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                GithubAccountDecorator it = (GithubAccountDecorator)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getAccount(), (Object)this.newTokensMap.get(it.getAccount()));
                boolean bl2 = false;
                map3.put(pair.getFirst(), pair.getSecond());
            }
            List list2 = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"accountListModel.items");
            Iterable iterable2 = list2;
            map2 = destination$iv$iv;
            boolean bl = false;
            Iterable iterable3 = iterable2;
            boolean bl3 = false;
            for (Object t : iterable3) {
                GithubAccountDecorator it = (GithubAccountDecorator)t;
                boolean bl4 = false;
                if (!it.getProjectDefault()) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        Object var13_17 = v2;
        GithubAccountDecorator githubAccountDecorator = var13_17;
        return TuplesKt.to((Object)map2, (Object)(githubAccountDecorator != null ? githubAccountDecorator.getAccount() : null));
    }

    public final void clearNewTokens() {
        this.newTokensMap.clear();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isModified(@NotNull Set<? extends GithubAccount> accounts, @Nullable GithubAccount defaultAccount) {
        void $this$mapTo$iv$iv;
        Object v1;
        Iterable iterable;
        boolean bl;
        Object object;
        block2: {
            Intrinsics.checkParameterIsNotNull(accounts, (String)"accounts");
            List list = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"accountListModel.items");
            object = list;
            bl = false;
            iterable = object;
            boolean bl2 = false;
            for (Object object2 : iterable) {
                GithubAccountDecorator it = (GithubAccountDecorator)object2;
                boolean bl3 = false;
                if (!it.getProjectDefault()) continue;
                v1 = object2;
                break block2;
            }
            v1 = null;
        }
        GithubAccountDecorator githubAccountDecorator = v1;
        if (Intrinsics.areEqual((Object)(githubAccountDecorator != null ? githubAccountDecorator.getAccount() : null), (Object)defaultAccount) ^ true) return true;
        List list = this.accountListModel.getItems();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"accountListModel.items");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GithubAccountDecorator bl3 = (GithubAccountDecorator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            GithubAccount githubAccount = it.getAccount();
            collection.add(githubAccount);
        }
        if (Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), accounts) ^ true) return true;
        object = this.newTokensMap;
        bl = false;
        if (object.isEmpty()) return false;
        return true;
    }

    public void dispose() {
    }

    public GithubAccountsPanel(@NotNull Project project, @NotNull GithubApiRequestExecutor.Factory executorFactory, @NotNull CachingGithubUserAvatarLoader avatarLoader, @NotNull GithubImageResizer imageResizer) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkParameterIsNotNull((Object)avatarLoader, (String)"avatarLoader");
        Intrinsics.checkParameterIsNotNull((Object)imageResizer, (String)"imageResizer");
        this.project = project;
        this.executorFactory = executorFactory;
        this.avatarLoader = avatarLoader;
        this.imageResizer = imageResizer;
        this.accountIconSize = new JBValue.UIInteger("Github.Profile.Avatar.Size", 40);
        CollectionListModel collectionListModel = new CollectionListModel((Object[])new GithubAccountDecorator[0]);
        GithubAccountsPanel githubAccountsPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        CollectionListModel $this$apply = collectionListModel;
        boolean bl3 = false;
        $this$apply.addListDataListener(new ListDataListener($this$apply, this){
            final /* synthetic */ CollectionListModel $this_apply;
            final /* synthetic */ GithubAccountsPanel this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = githubAccountsPanel;
            }

            public void contentsChanged(@Nullable ListDataEvent e) {
                boolean bl;
                GithubAccountsPanel githubAccountsPanel;
                block3: {
                    List list = this.$this_apply.getItems();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"items");
                    Iterable $this$any$iv = list;
                    githubAccountsPanel = this.this$0;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            GithubAccountDecorator it = (GithubAccountDecorator)element$iv;
                            boolean bl2 = false;
                            if (!(it.getLoadingError() != null)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                boolean bl3 = bl;
                GithubAccountsPanel.access$setLinkHandlerEnabled(githubAccountsPanel, bl3);
            }

            public void intervalRemoved(@Nullable ListDataEvent e) {
            }

            public void intervalAdded(@Nullable ListDataEvent e) {
            }
        });
        githubAccountsPanel.accountListModel = object = collectionListModel;
        collectionListModel = new JBList((ListModel)this.accountListModel);
        githubAccountsPanel = this;
        bl = false;
        bl2 = false;
        $this$apply = collectionListModel;
        boolean bl4 = false;
        GithubAccountDecoratorRenderer decoratorRenderer = new GithubAccountDecoratorRenderer();
        $this$apply.setCellRenderer((ListCellRenderer)decoratorRenderer);
        UIUtil.putClientProperty((JComponent)((JComponent)$this$apply), (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)CollectionsKt.listOf((Object)decoratorRenderer));
        $this$apply.setSelectionMode(0);
        StatusText statusText = $this$apply.getEmptyText();
        boolean bl5 = false;
        boolean bl6 = false;
        StatusText $this$apply2 = statusText;
        boolean bl7 = false;
        $this$apply2.appendText("No GitHub accounts added.");
        $this$apply2.appendSecondaryText("Add account", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(this){
            final /* synthetic */ GithubAccountsPanel this$0;
            {
                this.this$0 = githubAccountsPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                GithubAccountsPanel.access$addAccount(this.this$0);
            }
        });
        $this$apply2.appendSecondaryText(" (" + KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonShortcuts.getNew()) + ')', StatusText.DEFAULT_ATTRIBUTES, null);
        githubAccountsPanel.accountList = object = collectionListModel;
        this.progressManager = this.createListProgressManager();
        this.errorLinkHandler = this.createLinkActivationListener();
        githubAccountsPanel = this;
        boolean bl8 = false;
        githubAccountsPanel.currentTokensMap = object = MapsKt.emptyMap();
        githubAccountsPanel = this;
        bl8 = false;
        githubAccountsPanel.newTokensMap = object = (Map)new LinkedHashMap();
        this.addToCenter(ToolbarDecorator.createDecorator((JList)((JList)this.accountList)).disableUpDownActions().setPanelBorder(IdeBorderFactory.createBorder((int)10)).setAddAction(new AnActionButtonRunnable(){

            public final void run(AnActionButton it) {
                this.addAccount();
            }
        }).addExtraAction((AnActionButton)new ToolbarDecorator.ElementActionButton("Set default", AllIcons.Actions.Checked){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (((GithubAccountDecorator)accountList.getSelectedValue()).getProjectDefault()) {
                    return;
                }
                for (GithubAccountDecorator accountData : accountListModel.getItems()) {
                    if (Intrinsics.areEqual((Object)accountData, (Object)((GithubAccountDecorator)accountList.getSelectedValue()))) {
                        accountData.setProjectDefault(true);
                        accountListModel.contentsChanged((Object)accountData);
                        continue;
                    }
                    if (!accountData.getProjectDefault()) continue;
                    accountData.setProjectDefault(false);
                    accountListModel.contentsChanged((Object)accountData);
                }
            }

            public void updateButton(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.setEnabled(this.isEnabled() && !((GithubAccountDecorator)accountList.getSelectedValue()).getProjectDefault());
            }
        }).createPanel());
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.progressManager));
    }

    public static final /* synthetic */ boolean access$isAccountUnique(GithubAccountsPanel $this, String login2, GithubServerPath server) {
        return $this.isAccountUnique(login2, server);
    }

    public static final /* synthetic */ void access$editAccount(GithubAccountsPanel $this, GithubAccountDecorator decorator) {
        $this.editAccount(decorator);
    }

    public static final /* synthetic */ CachingGithubUserAvatarLoader access$getAvatarLoader$p(GithubAccountsPanel $this) {
        return $this.avatarLoader;
    }

    public static final /* synthetic */ GithubImageResizer access$getImageResizer$p(GithubAccountsPanel $this) {
        return $this.imageResizer;
    }

    public static final /* synthetic */ JBValue.UIInteger access$getAccountIconSize$p(GithubAccountsPanel $this) {
        return $this.accountIconSize;
    }

    public static final /* synthetic */ void access$setLinkHandlerEnabled(GithubAccountsPanel $this, boolean enabled) {
        $this.setLinkHandlerEnabled(enabled);
    }
}

