/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesWriter;
import java.util.HashMap;
import java.util.Map;

public class PacketSignal {
    byte[] payload;
    public int recipientChannelID;
    public String signalName;
    private static final Map<Integer, String> SIGNALS = new HashMap<Integer, String>();

    public PacketSignal(int recipientChannelID, String signalName) {
        this.recipientChannelID = recipientChannelID;
        if (signalName.startsWith("SIG")) {
            signalName = signalName.substring(3);
        }
        this.signalName = signalName;
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter tw = new TypesWriter();
            tw.writeByte(98);
            tw.writeUINT32(this.recipientChannelID);
            tw.writeString("signal");
            tw.writeBoolean(false);
            tw.writeString(this.signalName);
            this.payload = tw.getBytes();
        }
        return this.payload;
    }

    public static String strsignal(int i) {
        return SIGNALS.get(i);
    }

    static {
        SIGNALS.put(14, "ALRM");
        SIGNALS.put(1, "HUP");
        SIGNALS.put(2, "INT");
        SIGNALS.put(9, "KILL");
        SIGNALS.put(13, "PIPE");
        SIGNALS.put(15, "TERM");
        SIGNALS.put(6, "ABRT");
        SIGNALS.put(8, "FPE");
        SIGNALS.put(4, "ILL");
        SIGNALS.put(3, "QUIT");
        SIGNALS.put(11, "SEGV");
        SIGNALS.put(5, "TRAP");
    }
}

