/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.SmartList;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class InputMapExternalizer<Key, Value>
implements DataExternalizer<Map<Key, Value>> {
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataExternalizer<Collection<Key>> mySnapshotIndexExternalizer;

    InputMapExternalizer(IndexExtension<Key, Value, ?> extension) {
        DataExternalizer dataExternalizer;
        this.myValueExternalizer = extension.getValueExternalizer();
        if (extension instanceof CustomInputsIndexFileBasedIndexExtension) {
            dataExternalizer = ((CustomInputsIndexFileBasedIndexExtension)extension).createExternalizer();
        } else {
            DataExternalizer dataExternalizer2;
            dataExternalizer = dataExternalizer2;
            super(extension.getKeyDescriptor(), extension.getName());
        }
        this.mySnapshotIndexExternalizer = dataExternalizer;
    }

    @NotNull
    public DataExternalizer<Value> getValueExternalizer() {
        DataExternalizer<Value> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            InputMapExternalizer.$$$reportNull$$$0(0);
        }
        return dataExternalizer;
    }

    public void save(@NotNull DataOutput stream, Map<Key, Value> data) throws IOException {
        if (stream == null) {
            InputMapExternalizer.$$$reportNull$$$0(1);
        }
        int size = data.size();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
        if (size > 0) {
            THashMap values = new THashMap();
            List keysForNullValue = null;
            for (Map.Entry<Key, Value> e : data.entrySet()) {
                List keys;
                Value value = e.getValue();
                List list2 = keys = value != null ? (List)values.get(value) : keysForNullValue;
                if (keys == null) {
                    if (value != null) {
                        keys = new SmartList();
                        values.put(value, (Object)keys);
                    } else {
                        keys = keysForNullValue = new SmartList();
                    }
                }
                keys.add(e.getKey());
            }
            if (keysForNullValue != null) {
                this.myValueExternalizer.save(stream, null);
                this.mySnapshotIndexExternalizer.save(stream, keysForNullValue);
            }
            for (Map.Entry<Object, Object> value : values.keySet()) {
                this.myValueExternalizer.save(stream, value);
                this.mySnapshotIndexExternalizer.save(stream, values.get(value));
            }
        }
    }

    public Map<Key, Value> read(@NotNull DataInput in) throws IOException {
        int pairs;
        if (in == null) {
            InputMapExternalizer.$$$reportNull$$$0(2);
        }
        if ((pairs = DataInputOutputUtil.readINT((DataInput)in)) == 0) {
            return Collections.emptyMap();
        }
        THashMap result2 = new THashMap(pairs);
        while (((InputStream)((Object)in)).available() > 0) {
            Object value = this.myValueExternalizer.read(in);
            Collection keys = (Collection)this.mySnapshotIndexExternalizer.read(in);
            for (Object k : keys) {
                result2.put(k, value);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/InputMapExternalizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/InputMapExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

