/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.VfsEventsMerger;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedFilesListener
implements AsyncFileListener {
    private final ManagingFS myManagingFS = ManagingFS.getInstance();
    private final VfsEventsMerger myEventMerger = new VfsEventsMerger();
    @Nullable
    private final VirtualFile myConfig = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(PathManager.getConfigPath()));
    @Nullable
    private final VirtualFile myLog = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(PathManager.getLogPath()));

    protected VfsEventsMerger getEventMerger() {
        return this.myEventMerger;
    }

    protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(0);
        }
        if (file2.isDirectory()) {
            ContentIterator iterator = fileOrDir -> {
                this.myEventMerger.recordFileEvent(fileOrDir, contentChange);
                return true;
            };
            this.iterateIndexableFiles(file2, iterator);
        } else {
            this.myEventMerger.recordFileEvent(file2, contentChange);
        }
    }

    private boolean invalidateIndicesForFile(@NotNull VirtualFile file2, boolean contentChange, VfsEventsMerger eventMerger) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(1);
        }
        if (this.isUnderConfigOrSystem(file2)) {
            return false;
        }
        ProgressManager.checkCanceled();
        eventMerger.recordBeforeFileEvent(file2, contentChange);
        return !file2.isDirectory() || FileBasedIndexImpl.isMock(file2) || this.myManagingFS.wereChildrenAccessed(file2);
    }

    protected abstract void iterateIndexableFiles(@NotNull VirtualFile var1, @NotNull ContentIterator var2);

    void invalidateIndicesRecursively(@NotNull VirtualFile file2, final boolean contentChange, final VfsEventsMerger eventMerger) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(2);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return IndexedFilesListener.this.invalidateIndicesForFile(file2, contentChange, eventMerger);
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).iterInDbChildren() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/util/indexing/IndexedFilesListener$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            IndexedFilesListener.$$$reportNull$$$0(3);
        }
        final VfsEventsMerger tempMerger = new VfsEventsMerger();
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.invalidateIndicesRecursively(((VFileContentChangeEvent)vFileEvent).getFile(), true, tempMerger);
                continue;
            }
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.invalidateIndicesRecursively(((VFileDeleteEvent)vFileEvent).getFile(), false, tempMerger);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            String propertyName = pce.getPropertyName();
            if (propertyName.equals("name")) {
                this.invalidateIndicesRecursively(pce.getFile(), false, tempMerger);
                continue;
            }
            if (!propertyName.equals("encoding")) continue;
            this.invalidateIndicesRecursively(pce.getFile(), true, tempMerger);
        }
        AsyncFileListener.ChangeApplier changeApplier = new AsyncFileListener.ChangeApplier(){

            public void beforeVfsChange() {
                IndexedFilesListener.this.myEventMerger.applyMergedEvents(tempMerger);
            }

            public void afterVfsChange() {
                IndexedFilesListener.this.processAfterEvents(events);
            }
        };
        if (changeApplier == null) {
            IndexedFilesListener.$$$reportNull$$$0(4);
        }
        return changeApplier;
    }

    private void processAfterEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            IndexedFilesListener.$$$reportNull$$$0(5);
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.buildIndicesForFileRecursively(((VFileContentChangeEvent)vFileEvent).getFile(), true);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)vFileEvent;
                VirtualFile copy = ce.getNewParent().findChild(ce.getNewChildName());
                if (copy == null) continue;
                this.buildIndicesForFileRecursively(copy, false);
                continue;
            }
            if (vFileEvent instanceof VFileCreateEvent) {
                VirtualFile newChild = vFileEvent.getFile();
                if (newChild == null) continue;
                this.buildIndicesForFileRecursively(newChild, false);
                continue;
            }
            if (vFileEvent instanceof VFileMoveEvent) {
                this.buildIndicesForFileRecursively(((VFileMoveEvent)vFileEvent).getFile(), false);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            String propertyName = pce.getPropertyName();
            if (propertyName.equals("name")) {
                this.buildIndicesForFileRecursively(pce.getFile(), false);
                continue;
            }
            if (!propertyName.equals("encoding")) continue;
            this.buildIndicesForFileRecursively(pce.getFile(), true);
        }
    }

    private boolean isUnderConfigOrSystem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(6);
        }
        return this.myConfig != null && VfsUtilCore.isAncestor((VirtualFile)this.myConfig, (VirtualFile)file2, (boolean)false) || this.myLog != null && VfsUtilCore.isAncestor((VirtualFile)this.myLog, (VirtualFile)file2, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexedFilesListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexedFilesListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildIndicesForFileRecursively";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invalidateIndicesForFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invalidateIndicesRecursively";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processAfterEvents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUnderConfigOrSystem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

