/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.TabbedContentImpl;
import com.intellij.util.ContentsUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentUtilEx
extends ContentsUtil {
    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, boolean select) {
        if (manager == null) {
            ContentUtilEx.$$$reportNull$$$0(0);
        }
        if (contentComponent == null) {
            ContentUtilEx.$$$reportNull$$$0(1);
        }
        if (groupPrefix == null) {
            ContentUtilEx.$$$reportNull$$$0(2);
        }
        if (tabName == null) {
            ContentUtilEx.$$$reportNull$$$0(3);
        }
        ContentUtilEx.addTabbedContent(manager, contentComponent, groupPrefix, tabName, select, null);
    }

    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, boolean select, @Nullable Disposable childDisposable) {
        if (manager == null) {
            ContentUtilEx.$$$reportNull$$$0(4);
        }
        if (contentComponent == null) {
            ContentUtilEx.$$$reportNull$$$0(5);
        }
        if (groupPrefix == null) {
            ContentUtilEx.$$$reportNull$$$0(6);
        }
        if (tabName == null) {
            ContentUtilEx.$$$reportNull$$$0(7);
        }
        if (PropertiesComponent.getInstance().getBoolean("tabbed.toolwindow.expanded." + groupPrefix)) {
            Content content2 = ContentFactory.SERVICE.getInstance().createContent(contentComponent, ContentUtilEx.getFullName(groupPrefix, tabName), true);
            content2.putUserData(Content.TABBED_CONTENT_KEY, (Object)Boolean.TRUE);
            content2.putUserData(Content.TAB_GROUP_NAME_KEY, (Object)groupPrefix);
            for (Content c2 : manager.getContents()) {
                if (c2.getComponent() != contentComponent) continue;
                if (select) {
                    manager.setSelectedContent(c2);
                }
                return;
            }
            ContentUtilEx.addContent((ContentManager)manager, (Content)content2, (boolean)select);
            ContentUtilEx.registerDisposable(content2, childDisposable, contentComponent);
            return;
        }
        TabbedContent tabbedContent = ContentUtilEx.findTabbedContent(manager, groupPrefix);
        if (tabbedContent == null) {
            Disposable disposable = Disposer.newDisposable();
            tabbedContent = new TabbedContentImpl(contentComponent, tabName, true, groupPrefix);
            ContentsUtil.addOrReplaceContent((ContentManager)manager, (Content)tabbedContent, (boolean)select);
            Disposer.register((Disposable)tabbedContent, (Disposable)disposable);
        } else {
            for (Pair tab : new ArrayList(tabbedContent.getTabs())) {
                if (!Comparing.equal((Object)tab.second, (Object)contentComponent)) continue;
                tabbedContent.removeContent((JComponent)tab.second);
            }
            if (select) {
                manager.setSelectedContent((Content)tabbedContent, true, true);
            }
            tabbedContent.addContent(contentComponent, tabName, true);
        }
        ContentUtilEx.registerDisposable((Content)tabbedContent, childDisposable, contentComponent);
    }

    private static void registerDisposable(@NotNull Content content2, @Nullable Disposable childDisposable, @NotNull JComponent contentComponent) {
        if (content2 == null) {
            ContentUtilEx.$$$reportNull$$$0(8);
        }
        if (contentComponent == null) {
            ContentUtilEx.$$$reportNull$$$0(9);
        }
        if (childDisposable != null) {
            Disposer.register((Disposable)content2, (Disposable)childDisposable);
            assert (contentComponent.getClientProperty("TabContentDisposable") == null);
            contentComponent.putClientProperty("TabContentDisposable", childDisposable);
            Disposer.register((Disposable)childDisposable, () -> contentComponent.putClientProperty("TabContentDisposable", null));
        } else {
            Object disposableByKey = contentComponent.getClientProperty("TabContentDisposable");
            if (disposableByKey instanceof Disposable) {
                Disposer.register((Disposable)content2, (Disposable)((Disposable)disposableByKey));
            }
        }
    }

    @Nullable
    public static TabbedContent findTabbedContent(@NotNull ContentManager manager, @NotNull String groupPrefix) {
        if (manager == null) {
            ContentUtilEx.$$$reportNull$$$0(10);
        }
        if (groupPrefix == null) {
            ContentUtilEx.$$$reportNull$$$0(11);
        }
        TabbedContent tabbedContent = null;
        for (Content content2 : manager.getContents()) {
            if (!(content2 instanceof TabbedContent) || !content2.getTabName().startsWith(ContentUtilEx.getFullPrefix(groupPrefix))) continue;
            tabbedContent = (TabbedContent)content2;
            break;
        }
        return tabbedContent;
    }

    public static boolean isContentTab(@NotNull Content content2, @NotNull String groupPrefix) {
        if (content2 == null) {
            ContentUtilEx.$$$reportNull$$$0(12);
        }
        if (groupPrefix == null) {
            ContentUtilEx.$$$reportNull$$$0(13);
        }
        return content2 instanceof TabbedContent && content2.getTabName().startsWith(ContentUtilEx.getFullPrefix(groupPrefix)) || groupPrefix.equals(content2.getUserData(Content.TAB_GROUP_NAME_KEY));
    }

    @NotNull
    public static String getFullName(@NotNull String groupPrefix, @NotNull String tabName) {
        if (groupPrefix == null) {
            ContentUtilEx.$$$reportNull$$$0(14);
        }
        if (tabName == null) {
            ContentUtilEx.$$$reportNull$$$0(15);
        }
        String string = ContentUtilEx.getFullPrefix(groupPrefix) + tabName;
        if (string == null) {
            ContentUtilEx.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String getFullPrefix(@NotNull String groupPrefix) {
        if (groupPrefix == null) {
            ContentUtilEx.$$$reportNull$$$0(17);
        }
        String string = groupPrefix + ": ";
        if (string == null) {
            ContentUtilEx.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static boolean selectContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, boolean requestFocus) {
        if (manager == null) {
            ContentUtilEx.$$$reportNull$$$0(19);
        }
        if (contentComponent == null) {
            ContentUtilEx.$$$reportNull$$$0(20);
        }
        for (Content content2 : manager.getContents()) {
            if (content2 instanceof TabbedContentImpl) {
                boolean found = ((TabbedContentImpl)content2).findAndSelectContent(contentComponent);
                if (!found) continue;
                manager.setSelectedContent(content2, requestFocus);
                return true;
            }
            if (!Comparing.equal((Object)content2.getComponent(), (Object)contentComponent)) continue;
            manager.setSelectedContent(content2, requestFocus);
            return true;
        }
        return false;
    }

    @Nullable
    public static JComponent findContentComponent(@NotNull ContentManager manager, @NotNull Condition<? super JComponent> condition) {
        if (manager == null) {
            ContentUtilEx.$$$reportNull$$$0(21);
        }
        if (condition == null) {
            ContentUtilEx.$$$reportNull$$$0(22);
        }
        for (Content content2 : manager.getContents()) {
            if (content2 instanceof TabbedContentImpl) {
                List<Pair<String, JComponent>> tabs = ((TabbedContentImpl)content2).getTabs();
                for (Pair<String, JComponent> tab : tabs) {
                    if (!condition.value(tab.second)) continue;
                    return (JComponent)tab.second;
                }
                continue;
            }
            if (!condition.value((Object)content2.getComponent())) continue;
            return content2.getComponent();
        }
        return null;
    }

    @Nullable
    private static JComponent findContentComponent(@NotNull TabbedContent tabbedContent, @NotNull Condition<? super JComponent> condition) {
        if (tabbedContent == null) {
            ContentUtilEx.$$$reportNull$$$0(23);
        }
        if (condition == null) {
            ContentUtilEx.$$$reportNull$$$0(24);
        }
        for (Pair tab : tabbedContent.getTabs()) {
            if (!condition.value(tab.second)) continue;
            return (JComponent)tab.second;
        }
        return null;
    }

    public static boolean closeContentTab(@NotNull ContentManager manager, @NotNull Condition<? super JComponent> condition) {
        if (manager == null) {
            ContentUtilEx.$$$reportNull$$$0(25);
        }
        if (condition == null) {
            ContentUtilEx.$$$reportNull$$$0(26);
        }
        for (Content content2 : manager.getContents()) {
            if (content2 instanceof TabbedContent && ((TabbedContent)content2).hasMultipleTabs()) {
                TabbedContent tabbedContent = (TabbedContent)content2;
                JComponent component = ContentUtilEx.findContentComponent(tabbedContent, condition);
                if (component == null) continue;
                tabbedContent.removeContent(component);
                ContentUtilEx.dispose((JComponent)component);
                return true;
            }
            if (!condition.value((Object)content2.getComponent())) continue;
            manager.removeContent(content2, true);
            return true;
        }
        return false;
    }

    public static int getSelectedTab(@NotNull TabbedContent content2) {
        int selectedIndex;
        if (content2 == null) {
            ContentUtilEx.$$$reportNull$$$0(27);
        }
        if ((selectedIndex = content2.getSelectedIndex()) != -1) {
            return selectedIndex;
        }
        JComponent current = content2.getComponent();
        int index = 0;
        for (Pair tab : content2.getTabs()) {
            if (tab.second == current) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static boolean renameTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull String newName) {
        if (manager == null) {
            ContentUtilEx.$$$reportNull$$$0(28);
        }
        if (contentComponent == null) {
            ContentUtilEx.$$$reportNull$$$0(29);
        }
        if (newName == null) {
            ContentUtilEx.$$$reportNull$$$0(30);
        }
        for (Content content2 : manager.getContents()) {
            String groupPrefix;
            if (content2 instanceof TabbedContentImpl) {
                if (!((TabbedContentImpl)content2).rename(contentComponent, newName)) continue;
                return true;
            }
            if (!Comparing.equal((Object)content2.getComponent(), (Object)contentComponent) || (groupPrefix = (String)content2.getUserData(Content.TAB_GROUP_NAME_KEY)) == null) continue;
            content2.setDisplayName(ContentUtilEx.getFullName(groupPrefix, newName));
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPrefix";
                break;
            }
            case 3: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabName";
                break;
            }
            case 8: 
            case 12: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ContentUtilEx";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabbedContent";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ContentUtilEx";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTabbedContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerDisposable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTabbedContent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isContentTab";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 16: 
            case 18: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFullPrefix";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "selectContent";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findContentComponent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "closeContentTab";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedTab";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "renameTabbedContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

