/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreePathBackgroundSupplier;
import com.intellij.ui.tree.ui.CompactPainter;
import com.intellij.ui.tree.ui.Control;
import com.intellij.ui.tree.ui.DefaultControl;
import com.intellij.ui.tree.ui.DispatchThreadValidator;
import com.intellij.ui.tree.ui.TreeAction;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultTreeUI
extends BasicTreeUI {
    public static final Key<Boolean> SHRINK_LONG_RENDERER = Key.create((String)"resize renderer component if it exceed a visible area");
    private static final Logger LOG = Logger.getInstance(DefaultTreeUI.class);
    private static final Collection<Class<?>> SUSPICIOUS = ContainerUtil.createWeakSet();
    private final Control control = new DefaultControl();
    private final DispatchThreadValidator validator = new DispatchThreadValidator();

    @NotNull
    private static Control.Painter getPainter(@NotNull JTree tree) {
        Control.Painter painter;
        if (tree == null) {
            DefaultTreeUI.$$$reportNull$$$0(0);
        }
        if ((painter = (Control.Painter)UIUtil.getClientProperty((Object)tree, Control.Painter.KEY)) != null) {
            Control.Painter painter2 = painter;
            if (painter2 == null) {
                DefaultTreeUI.$$$reportNull$$$0(1);
            }
            return painter2;
        }
        Application application = ApplicationManager.getApplication();
        if (application != null && (painter = (Control.Painter)application.getUserData(Control.Painter.KEY)) != null) {
            Control.Painter painter3 = painter;
            if (painter3 == null) {
                DefaultTreeUI.$$$reportNull$$$0(2);
            }
            return painter3;
        }
        if (Registry.is((String)"ide.tree.painter.classic.compact")) {
            Control.Painter painter4 = Control.Painter.COMPACT;
            if (painter4 == null) {
                DefaultTreeUI.$$$reportNull$$$0(3);
            }
            return painter4;
        }
        if (Registry.is((String)"ide.tree.painter.compact.default")) {
            Control.Painter painter5 = CompactPainter.DEFAULT;
            if (painter5 == null) {
                DefaultTreeUI.$$$reportNull$$$0(4);
            }
            return painter5;
        }
        Control.Painter painter6 = Control.Painter.DEFAULT;
        if (painter6 == null) {
            DefaultTreeUI.$$$reportNull$$$0(5);
        }
        return painter6;
    }

    @Nullable
    private static Color getBackground(@NotNull JTree tree, @NotNull TreePath path, int row, boolean selected2) {
        BackgroundSupplier supplier;
        Color background;
        Color background2;
        if (tree == null) {
            DefaultTreeUI.$$$reportNull$$$0(6);
        }
        if (path == null) {
            DefaultTreeUI.$$$reportNull$$$0(7);
        }
        if (selected2) {
            Object property = tree.getClientProperty("TreeTableTree");
            if (property instanceof JTable) {
                return ((JTable)property).getSelectionBackground();
            }
            return UIUtil.getTreeSelectionBackground((tree.hasFocus() || Boolean.TRUE.equals(property) ? 1 : 0) != 0);
        }
        Object node = TreeUtil.getLastUserObject((TreePath)path);
        if (node instanceof ColoredItem && (background2 = ((ColoredItem)node).getColor()) != null) {
            return background2;
        }
        if (node instanceof BackgroundSupplier && (background = (supplier = (BackgroundSupplier)node).getElementBackground(row)) != null) {
            return background;
        }
        if (tree instanceof TreePathBackgroundSupplier && (background = (supplier = (TreePathBackgroundSupplier)tree).getPathBackground(path, row)) != null) {
            return background;
        }
        return null;
    }

    private static void setBackground(@NotNull JTree tree, @NotNull Component component, @Nullable Color background, boolean opaque) {
        if (tree == null) {
            DefaultTreeUI.$$$reportNull$$$0(8);
        }
        if (component == null) {
            DefaultTreeUI.$$$reportNull$$$0(9);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(opaque);
        }
        if (background != null) {
            component.setBackground(background);
        } else if (component.isOpaque()) {
            component.setBackground(tree.getBackground());
        }
    }

    private static boolean isSuspiciousRenderer(Component component) {
        if (component instanceof JComponent) {
            Method method = ReflectionUtil.getMethod(component.getClass(), (String)"validate", (Class[])new Class[0]);
            Class<?> type = method == null ? null : method.getDeclaringClass();
            return Component.class.equals(type) || Container.class.equals(type);
        }
        return true;
    }

    private static int getExpandedRow(@NotNull JTree tree) {
        Tree custom;
        Collection items;
        if (tree == null) {
            DefaultTreeUI.$$$reportNull$$$0(10);
        }
        if (tree instanceof Tree && !(items = (custom = (Tree)tree).getExpandableItemsHandler().getExpandedItems()).isEmpty()) {
            return (Integer)items.iterator().next();
        }
        return -1;
    }

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JTree);
        return new DefaultTreeUI();
    }

    @Nullable
    private JTree getTree() {
        return this.tree;
    }

    @Nullable
    private Component getRenderer(JTree tree, Object value, boolean selected2, boolean expanded, boolean leaf, int row, boolean focused) {
        Class<?> type;
        TreeCellRenderer renderer2 = this.currentCellRenderer;
        if (renderer2 == null) {
            return null;
        }
        Component component = renderer2.getTreeCellRendererComponent(tree, value, selected2, expanded, leaf, row, focused);
        if (component == null) {
            return null;
        }
        CellRendererPane pane2 = this.rendererPane;
        if (pane2 != null && pane2 != component.getParent()) {
            pane2.add(component);
        }
        if (LOG.isDebugEnabled() && !SUSPICIOUS.contains(type = renderer2.getClass()) && DefaultTreeUI.isSuspiciousRenderer(component) && SUSPICIOUS.add(type)) {
            LOG.debug("suspicious renderer " + type);
        }
        return component;
    }

    private boolean isLeaf(@Nullable Object value) {
        return value == null || this.treeModel.isLeaf(value);
    }

    private boolean isValid(@Nullable JTree tree) {
        if (!this.validator.isValidThread()) {
            return false;
        }
        if (tree != null && tree == this.getTree()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException(tree != null ? "unexpected tree" : "undefined tree"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c2) {
        AbstractLayoutCache cache = this.treeState;
        if (cache == null) {
            return;
        }
        JTree tree = (JTree)c2;
        if (!this.isValid(tree)) {
            return;
        }
        g = g.create();
        try {
            Rectangle paintBounds = g.getClipBounds();
            Insets insets = tree.getInsets();
            TreePath path = cache.getPathClosestTo(0, paintBounds.y - insets.top);
            int row = cache.getRowForPath(path);
            if (row >= 0) {
                Rectangle bounds2;
                Control.Painter painter = DefaultTreeUI.getPainter(tree);
                Rectangle buffer = new Rectangle();
                int expandedRow = DefaultTreeUI.getExpandedRow(tree);
                int maxPaintY = paintBounds.y + paintBounds.height;
                int viewportX = 0;
                int viewportWidth = tree.getWidth();
                int vsbWidth = 0;
                boolean hsbVisible = false;
                Container parent = tree.getParent();
                if (parent instanceof JViewport) {
                    viewportX = -tree.getX();
                    viewportWidth = parent.getWidth();
                    if ((parent = parent.getParent()) instanceof JBScrollPane) {
                        JScrollBar vsb;
                        JBScrollPane pane2 = (JBScrollPane)parent;
                        JScrollBar hsb = pane2.getHorizontalScrollBar();
                        if (hsb != null && hsb.isVisible()) {
                            hsbVisible = true;
                        }
                        if ((vsb = pane2.getVerticalScrollBar()) != null && vsb.isVisible() && !vsb.isOpaque()) {
                            Boolean property = (Boolean)UIUtil.getClientProperty((Object)vsb, (Key)JBScrollPane.IGNORE_SCROLLBAR_IN_INSETS);
                            if (SystemInfo.isMac ? Boolean.FALSE.equals(property) : !Boolean.TRUE.equals(property)) {
                                vsbWidth = vsb.getWidth();
                            }
                        }
                    }
                }
                while (path != null && (bounds2 = cache.getBounds(path, buffer)) != null) {
                    Object value;
                    Component component;
                    int width;
                    bounds2.y += insets.top;
                    int depth = TreeUtil.getNodeDepth((JTree)tree, (TreePath)path);
                    boolean leaf = this.isLeaf(path.getLastPathComponent());
                    boolean expanded = !leaf && cache.getExpandedState(path);
                    boolean selected2 = tree.isRowSelected(row);
                    boolean focused = tree.hasFocus();
                    boolean lead = focused && row == this.getLeadSelectionRow();
                    Color background = DefaultTreeUI.getBackground(tree, path, row, selected2);
                    if (background != null) {
                        g.setColor(background);
                        g.fillRect(viewportX, bounds2.y, viewportWidth, bounds2.height);
                    }
                    int offset = painter.getRendererOffset(this.control, depth, leaf);
                    painter.paint(tree, g, insets.left, bounds2.y, offset, bounds2.height, this.control, depth, leaf, expanded, selected2 && focused);
                    if ((this.editingComponent == null || this.editingRow != row) && (width = viewportX + viewportWidth - insets.left - offset - vsbWidth) > 0 && (component = this.getRenderer(tree, value = path.getLastPathComponent(), selected2, expanded, leaf, row, lead)) != null) {
                        if (width < bounds2.width && (expandedRow == row || hsbVisible && !UIUtil.isClientPropertyTrue((Object)component, SHRINK_LONG_RENDERER))) {
                            width = bounds2.width;
                        }
                        DefaultTreeUI.setBackground(tree, component, background, false);
                        this.rendererPane.paintComponent(g, component, tree, insets.left + offset, bounds2.y, width, bounds2.height, true);
                    }
                    if (bounds2.y + bounds2.height >= maxPaintY) break;
                    path = cache.getPathForRow(++row);
                }
            }
            this.paintDropLine(g);
            this.rendererPane.removeAll();
        }
        finally {
            g.dispose();
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        JTree tree = this.getTree();
        if (tree != null) {
            LookAndFeel.installBorder(tree, "Tree.border");
            if (tree.isForegroundSet()) {
                tree.setForeground(null);
            }
            if (UIManager.get("Tree.showsRootHandles") == null) {
                LookAndFeel.installProperty(tree, "showsRootHandles", Boolean.TRUE);
            }
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        TreeAction.installTo(this.tree.getActionMap());
        TreeAction.installTo(this.tree.getInputMap(0));
    }

    @Override
    protected boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        JTree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        Rectangle bounds2 = this.getPathBounds(tree, path);
        if (bounds2 == null) {
            return false;
        }
        bounds2.x = DefaultTreeUI.getPainter(tree).getControlOffset(this.control, TreeUtil.getNodeDepth((JTree)tree, (TreePath)path), this.isLeaf(path.getLastPathComponent()));
        if (bounds2.x < 0) {
            return false;
        }
        Insets insets = tree.getInsets();
        bounds2.x += insets.left;
        bounds2.width = this.control.getWidth();
        int height = 2 + this.control.getHeight();
        if (height < bounds2.height) {
            bounds2.y += (bounds2.height - height) / 2;
            bounds2.height = height;
        }
        return bounds2.contains(mouseX, mouseY);
    }

    @Override
    protected int getRowX(int row, int depth) {
        JTree tree = this.getTree();
        if (tree == null) {
            return 0;
        }
        TreePath path = this.getPathForRow(tree, row);
        if (path == null) {
            return 0;
        }
        return DefaultTreeUI.getPainter(tree).getRendererOffset(this.control, TreeUtil.getNodeDepth((JTree)tree, (TreePath)path), this.isLeaf(path.getLastPathComponent()));
    }

    @Override
    protected void setRootVisible(boolean newValue) {
        if (this.treeModel instanceof AsyncTreeModel) {
            UIUtil.invokeLaterIfNeeded(() -> super.setRootVisible(newValue));
        } else {
            super.setRootVisible(newValue);
        }
    }

    @Override
    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new AbstractLayoutCache.NodeDimensions(){

            @Override
            public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle bounds2) {
                JTree tree = DefaultTreeUI.this.getTree();
                if (tree == null) {
                    return null;
                }
                boolean leaf = DefaultTreeUI.this.isLeaf(value);
                Dimension size = null;
                if (DefaultTreeUI.this.editingComponent != null && DefaultTreeUI.this.editingRow == row) {
                    size = DefaultTreeUI.this.editingComponent.getPreferredSize();
                } else {
                    boolean selected2 = tree.isRowSelected(row);
                    Component component = DefaultTreeUI.this.getRenderer(tree, value, selected2, expanded, leaf, row, false);
                    if (component != null) {
                        component.validate();
                        size = component.getPreferredSize();
                    }
                }
                if (size == null) {
                    return null;
                }
                int x = DefaultTreeUI.getPainter(tree).getRendererOffset(DefaultTreeUI.this.control, depth + TreeUtil.getDepthOffset((JTree)tree), leaf);
                int height = DefaultTreeUI.this.getRowHeight();
                if (height <= 0) {
                    height = size.height;
                }
                if (bounds2 == null) {
                    return new Rectangle(x, 0, size.width, height);
                }
                bounds2.x = x;
                bounds2.y = 0;
                bounds2.width = size.width;
                bounds2.height = height;
                return bounds2;
            }
        };
    }

    @Override
    protected AbstractLayoutCache createLayoutCache() {
        return super.createLayoutCache();
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseEventAdapter<MouseListener>(super.createMouseListener()){

            public void mouseDragged(MouseEvent event) {
                Object property = UIUtil.getClientProperty((Object)event.getSource(), (Object)"DnD Source");
                if (property == null) {
                    super.mouseDragged(event);
                }
            }

            @NotNull
            protected MouseEvent convert(@NotNull MouseEvent event) {
                Rectangle bounds2;
                int y;
                int x;
                TreePath path;
                JTree tree;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((tree = DefaultTreeUI.this.getTree()) != null && tree == event.getSource() && tree.isEnabled() && !event.isConsumed() && SwingUtilities.isLeftMouseButton(event) && (path = DefaultTreeUI.this.getClosestPathForLocation(tree, x = event.getX(), y = event.getY())) != null && !DefaultTreeUI.this.isLocationInExpandControl(path, x, y) && (bounds2 = DefaultTreeUI.this.getPathBounds(tree, path)) != null && bounds2.y <= y && y <= bounds2.y + bounds2.height && (x = Math.max(bounds2.x, Math.min(x, bounds2.x + bounds2.width - 1))) != event.getX()) {
                    event = 2.convert((MouseEvent)event, (Component)tree, (int)x, (int)y);
                }
                MouseEvent mouseEvent = event;
                if (mouseEvent == null) {
                    2.$$$reportNull$$$0(1);
                }
                return mouseEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/tree/ui/DefaultTreeUI$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/tree/ui/DefaultTreeUI$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convert";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convert";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public Rectangle getPathBounds(JTree tree, TreePath path) {
        if (path == null || !this.isValid(tree)) {
            return null;
        }
        return super.getPathBounds(tree, path);
    }

    @Override
    public TreePath getPathForRow(JTree tree, int row) {
        if (!this.isValid(tree)) {
            return null;
        }
        return super.getPathForRow(tree, row);
    }

    @Override
    public int getRowForPath(JTree tree, TreePath path) {
        if (path == null || !this.isValid(tree)) {
            return -1;
        }
        return super.getRowForPath(tree, path);
    }

    @Override
    public int getRowCount(JTree tree) {
        if (!this.isValid(tree)) {
            return 0;
        }
        return super.getRowCount(tree);
    }

    @Override
    public TreePath getClosestPathForLocation(JTree tree, int x, int y) {
        if (!this.isValid(tree)) {
            return null;
        }
        return super.getClosestPathForLocation(tree, x, y);
    }

    @Override
    public boolean isEditing(JTree tree) {
        if (!this.isValid(tree)) {
            return false;
        }
        return super.isEditing(tree);
    }

    @Override
    public boolean stopEditing(JTree tree) {
        if (!this.isValid(tree)) {
            return false;
        }
        return super.stopEditing(tree);
    }

    @Override
    public void cancelEditing(JTree tree) {
        if (!this.isValid(tree)) {
            return;
        }
        super.cancelEditing(tree);
    }

    @Override
    public void startEditingAtPath(JTree tree, TreePath path) {
        if (path == null || !this.isValid(tree)) {
            return;
        }
        super.startEditingAtPath(tree, path);
    }

    @Override
    public TreePath getEditingPath(JTree tree) {
        if (!this.isValid(tree)) {
            return null;
        }
        return super.getEditingPath(tree);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/ui/DefaultTreeUI";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/ui/DefaultTreeUI";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPainter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPainter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBackground";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedRow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

