/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TreePathUtil {
    @NotNull
    public static TreePath createTreePath(TreePath parent, @NotNull Object component) {
        if (component == null) {
            TreePathUtil.$$$reportNull$$$0(0);
        }
        TreePath treePath = parent != null ? parent.pathByAddingChild(component) : new TreePath(component);
        if (treePath == null) {
            TreePathUtil.$$$reportNull$$$0(1);
        }
        return treePath;
    }

    public static String[] convertTreePathToStrings(@NotNull TreePath path) {
        if (path == null) {
            TreePathUtil.$$$reportNull$$$0(2);
        }
        return TreePathUtil.convertTreePathToArray(path, Object::toString, String.class);
    }

    public static Object[] convertTreePathToArray(@NotNull TreePath path) {
        if (path == null) {
            TreePathUtil.$$$reportNull$$$0(3);
        }
        return TreePathUtil.convertTreePathToArray(path, object -> object, Object.class);
    }

    public static Object[] convertTreePathToArray(@NotNull TreePath path, @NotNull Function<Object, Object> converter) {
        if (path == null) {
            TreePathUtil.$$$reportNull$$$0(4);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(5);
        }
        return TreePathUtil.convertTreePathToArray(path, converter, Object.class);
    }

    private static <T> T[] convertTreePathToArray(@NotNull TreePath path, @NotNull Function<Object, ? extends T> converter, @NotNull Class<T> type) {
        int count;
        if (path == null) {
            TreePathUtil.$$$reportNull$$$0(6);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(7);
        }
        if (type == null) {
            TreePathUtil.$$$reportNull$$$0(8);
        }
        if ((count = path.getPathCount()) <= 0) {
            return null;
        }
        Object[] array = ArrayUtil.newArray(type, (int)count);
        while (path != null && count > 0) {
            Object component = path.getLastPathComponent();
            if (component == null) {
                return null;
            }
            T object = TreePathUtil.convert(component, converter);
            if (object == null) {
                return null;
            }
            array[--count] = object;
            path = path.getParentPath();
        }
        return path != null || count > 0 ? null : array;
    }

    @SafeVarargs
    public static <T> TreePath convertArrayToTreePath(T ... array) {
        if (array == null) {
            TreePathUtil.$$$reportNull$$$0(9);
        }
        return TreePathUtil.convertArrayToTreePath(array, object -> object);
    }

    public static <T> TreePath convertArrayToTreePath(@NotNull T[] array, @NotNull Function<? super T, Object> converter) {
        if (array == null) {
            TreePathUtil.$$$reportNull$$$0(10);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(11);
        }
        return array.length == 0 ? null : TreePathUtil.convertCollectionToTreePath(Arrays.asList(array), converter);
    }

    public static <T> TreePath convertCollectionToTreePath(@NotNull Iterable<? extends T> collection) {
        if (collection == null) {
            TreePathUtil.$$$reportNull$$$0(12);
        }
        return TreePathUtil.convertCollectionToTreePath(collection, object -> object);
    }

    public static <T> TreePath convertCollectionToTreePath(@NotNull Iterable<? extends T> collection, @NotNull Function<? super T, Object> converter) {
        if (collection == null) {
            TreePathUtil.$$$reportNull$$$0(13);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(14);
        }
        TreePath path = null;
        for (T object : collection) {
            Object component = TreePathUtil.convert(object, converter);
            if (component == null) {
                return null;
            }
            path = TreePathUtil.createTreePath(path, component);
        }
        return path;
    }

    public static TreePath pathToTreeNode(@NotNull TreeNode node) {
        if (node == null) {
            TreePathUtil.$$$reportNull$$$0(15);
        }
        return TreePathUtil.pathToTreeNode(node, object -> object);
    }

    public static TreePath pathToTreeNode(@NotNull TreeNode node, @NotNull Function<? super TreeNode, Object> converter) {
        if (node == null) {
            TreePathUtil.$$$reportNull$$$0(16);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(17);
        }
        return TreePathUtil.pathToCustomNode(node, TreeNode::getParent, converter);
    }

    public static <T> TreePath pathToCustomNode(@NotNull T node, @NotNull Function<? super T, ? extends T> getParent) {
        if (node == null) {
            TreePathUtil.$$$reportNull$$$0(18);
        }
        if (getParent == null) {
            TreePathUtil.$$$reportNull$$$0(19);
        }
        return TreePathUtil.pathToCustomNode(node, getParent, object -> object);
    }

    public static <T> TreePath pathToCustomNode(@NotNull T node, @NotNull Function<? super T, ? extends T> getParent, @NotNull Function<? super T, Object> converter) {
        if (node == null) {
            TreePathUtil.$$$reportNull$$$0(20);
        }
        if (getParent == null) {
            TreePathUtil.$$$reportNull$$$0(21);
        }
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(22);
        }
        ArrayDeque<T> deque = new ArrayDeque<T>();
        while (node != null) {
            deque.addFirst(node);
            node = getParent.apply(node);
        }
        return TreePathUtil.convertCollectionToTreePath(deque, converter);
    }

    private static <I, O> O convert(I object, @NotNull Function<? super I, ? extends O> converter) {
        if (converter == null) {
            TreePathUtil.$$$reportNull$$$0(23);
        }
        return object == null ? null : (O)converter.apply((I)object);
    }

    @NotNull
    public static TreePath[] toTreePathArray(@NotNull Collection<TreePath> collection) {
        if (collection == null) {
            TreePathUtil.$$$reportNull$$$0(24);
        }
        TreePath[] treePathArray = collection.isEmpty() ? TreeUtil.EMPTY_TREE_PATH : collection.toArray(TreeUtil.EMPTY_TREE_PATH);
        if (treePathArray == null) {
            TreePathUtil.$$$reportNull$$$0(25);
        }
        return treePathArray;
    }

    public static TreeNode toTreeNode(TreePath path) {
        Object component = path == null ? null : path.getLastPathComponent();
        return component instanceof TreeNode ? (TreeNode)component : null;
    }

    @Contract(value="!null->!null")
    public static TreeNode[] toTreeNodes(TreePath ... paths) {
        return paths == null ? null : (TreeNode[])Stream.of(paths).map(TreePathUtil::toTreeNode).filter(Objects::nonNull).toArray(TreeNode[]::new);
    }

    public static TreePath toTreePath(TreeNode node) {
        return node == null ? null : TreePathUtil.pathToTreeNode(node);
    }

    public static TreePath[] toTreePaths(TreeNode ... nodes) {
        return nodes == null ? null : (TreePath[])Stream.of(nodes).map(TreePathUtil::toTreePath).filter(Objects::nonNull).toArray(TreePath[]::new);
    }

    public static TreePath findCommonAncestor(TreePath ... paths) {
        if (ArrayUtil.isEmpty((Object[])paths)) {
            return null;
        }
        if (paths.length == 1) {
            return paths[0];
        }
        return TreePathUtil.findCommonAncestor(Arrays.asList(paths));
    }

    /*
     * WARNING - void declaration
     */
    public static TreePath findCommonAncestor(@NotNull Iterable<? extends TreePath> paths) {
        if (paths == null) {
            TreePathUtil.$$$reportNull$$$0(26);
        }
        TreePath ancestor = null;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            TreePath first = null;
            for (TreePath treePath : paths) {
                void var5_5;
                int count = treePath.getPathCount();
                if (count <= i) {
                    return ancestor;
                }
                while (--count > i) {
                    TreePath treePath2 = var5_5.getParentPath();
                }
                if (var5_5 == null) {
                    throw new IllegalStateException("unexpected");
                }
                if (first == null) {
                    first = var5_5;
                }
                if (first == var5_5 || Objects.equals(first.getLastPathComponent(), var5_5.getLastPathComponent())) continue;
                return ancestor;
            }
            if (first == null) {
                return ancestor;
            }
            ancestor = TreePathUtil.createTreePath(ancestor, first.getLastPathComponent());
        }
        return ancestor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/TreePathUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 12: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getParent";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/TreePathUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreePath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "toTreePathArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTreePath";
                break;
            }
            case 1: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertTreePathToStrings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertTreePathToArray";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertArrayToTreePath";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertCollectionToTreePath";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "pathToTreeNode";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "pathToCustomNode";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toTreePathArray";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findCommonAncestor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

