/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.stripe;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.stripe.ErrorStripePainter;
import com.intellij.ui.stripe.Updater;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeUpdater<Painter extends ErrorStripePainter>
extends Updater<Painter> {
    private final JTree myTree;
    private final TreeModelListener myTreeModelListener = EventHandler.create(TreeModelListener.class, this, "update");
    private final PropertyChangeListener myPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof TreeModel) {
                ((TreeModel)oldValue).removeTreeModelListener(TreeUpdater.this.myTreeModelListener);
            }
            if ((newValue = event.getNewValue()) instanceof TreeModel) {
                ((TreeModel)newValue).addTreeModelListener(TreeUpdater.this.myTreeModelListener);
            }
        }
    };

    public TreeUpdater(Painter painter, JScrollPane pane2, JTree tree) {
        super(painter, pane2);
        this.myTree = tree;
        this.myTree.addPropertyChangeListener("model", this.myPropertyChangeListener);
        TreeModel model2 = this.myTree.getModel();
        if (model2 != null) {
            model2.addTreeModelListener(this.myTreeModelListener);
        }
        DumbAwareAction.create(e -> this.selectNext(this.myTree.getMaxSelectionRow())).registerCustomShortcutSet(this.getNextErrorShortcut(), (JComponent)this.myTree, (Disposable)this);
        DumbAwareAction.create(e -> this.selectPrevious(this.myTree.getMinSelectionRow())).registerCustomShortcutSet(this.getPreviousErrorShortcut(), (JComponent)this.myTree, (Disposable)this);
    }

    @Override
    public void dispose() {
        this.myTree.removePropertyChangeListener("model", this.myPropertyChangeListener);
        TreeModel model2 = this.myTree.getModel();
        if (model2 != null) {
            model2.removeTreeModelListener(this.myTreeModelListener);
        }
        super.dispose();
    }

    @Override
    protected void onSelect(Painter painter, int index) {
        if (0 <= index) {
            this.myTree.setSelectionRow(index);
            this.myTree.scrollRowToVisible(index);
        }
    }

    @Override
    protected void update(Painter painter) {
        this.update(painter, this.myTree);
    }

    protected void update(Painter painter, JTree tree) {
        int count = tree.getRowCount();
        ((ErrorStripePainter)((Object)painter)).setErrorStripeCount(count);
        for (int index = 0; index < count; ++index) {
            TreePath path = tree.getPathForRow(index);
            this.update(painter, index, path == null ? null : path.getLastPathComponent());
        }
    }
}

