/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.javafx;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.javafx.JFXPanelWrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.webkit.Accessor;
import com.sun.webkit.WebPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFxHtmlPanel
implements Disposable {
    public static final String JAVAFX_INITIALIZATION_INCOMPLETE_PROPERTY = "js.debugger.javafx.inititalization";
    @NotNull
    private final JPanel myPanelWrapper;
    @NotNull
    private final List<Runnable> myInitActions = new ArrayList<Runnable>();
    private final JavaFXLafManagerListener myLafManagerListener;
    @Nullable
    protected JFXPanel myPanel;
    @Nullable
    protected WebView myWebView;
    private java.awt.Color background;

    public JavaFxHtmlPanel() {
        PropertiesComponent.getInstance().setValue(JAVAFX_INITIALIZATION_INCOMPLETE_PROPERTY, true, false);
        ApplicationManager.getApplication().saveSettings();
        this.background = JBColor.background();
        this.myPanelWrapper = new JPanel(new BorderLayout());
        this.myPanelWrapper.setBackground(this.background);
        ApplicationManager.getApplication().invokeLater(() -> JavaFxHtmlPanel.runFX(() -> PlatformImpl.startup(() -> {
            PropertiesComponent.getInstance().setValue(JAVAFX_INITIALIZATION_INCOMPLETE_PROPERTY, false, false);
            this.myWebView = new WebView();
            this.myWebView.setContextMenuEnabled(false);
            this.myWebView.setZoom((double)JBUIScale.scale((float)1.0f));
            WebEngine engine = this.myWebView.getEngine();
            this.registerListeners(engine);
            engine.getLoadWorker().stateProperty().addListener((observable2, oldValue, newValue) -> {
                if (newValue == Worker.State.RUNNING) {
                    WebPage page = Accessor.getPageFor((WebEngine)engine);
                    page.setBackgroundColor(this.background.getRGB());
                }
            });
            Color fxColor = JavaFxHtmlPanel.toFxColor(this.background);
            Scene scene = new Scene((Parent)this.myWebView, (Paint)fxColor);
            ApplicationManager.getApplication().invokeLater(() -> JavaFxHtmlPanel.runFX(() -> {
                this.myPanel = new JFXPanelWrapper();
                Platform.runLater(() -> this.myPanel.setScene(scene));
                this.setHtml("");
                for (Runnable action2 : this.myInitActions) {
                    Platform.runLater((Runnable)action2);
                }
                this.myInitActions.clear();
                this.myPanelWrapper.add((Component)this.myPanel, "Center");
                this.myPanelWrapper.repaint();
            }));
        })));
        this.myLafManagerListener = new JavaFXLafManagerListener();
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this.myLafManagerListener);
        this.runInPlatformWhenAvailable(() -> this.updateLaf(UIUtil.isUnderDarcula()));
    }

    @NotNull
    public static Color toFxColor(java.awt.Color background) {
        double r = (double)background.getRed() / 255.0;
        double g = (double)background.getGreen() / 255.0;
        double b = (double)background.getBlue() / 255.0;
        double a = (double)background.getAlpha() / 255.0;
        Color color = Color.color((double)r, (double)g, (double)b, (double)a);
        if (color == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(0);
        }
        return color;
    }

    public void setBackground(java.awt.Color background) {
        this.background = background;
        this.myPanelWrapper.setBackground(background);
        ApplicationManager.getApplication().invokeLater(() -> JavaFxHtmlPanel.runFX(() -> {
            if (this.myPanel != null) {
                this.myPanel.getScene().setFill((Paint)JavaFxHtmlPanel.toFxColor(background));
            }
        }));
    }

    protected void registerListeners(@NotNull WebEngine engine) {
        if (engine == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(1);
        }
    }

    private static void runFX(@NotNull Runnable r) {
        if (r == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(2);
        }
        IdeEventQueue.unsafeNonblockingExecute(r);
    }

    protected void runInPlatformWhenAvailable(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPanel == null) {
            this.myInitActions.add(runnable2);
        } else {
            Platform.runLater((Runnable)runnable2);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanelWrapper;
        if (jPanel == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    public void setHtml(@NotNull String html) {
        if (html == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(5);
        }
        String htmlToRender = this.prepareHtml(html);
        this.runInPlatformWhenAvailable(() -> this.getWebViewGuaranteed().getEngine().loadContent(htmlToRender));
    }

    @NotNull
    protected String prepareHtml(@NotNull String html) {
        if (html == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(6);
        }
        String string = html;
        if (string == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void render() {
        this.runInPlatformWhenAvailable(() -> {
            this.getWebViewGuaranteed().getEngine().reload();
            ApplicationManager.getApplication().invokeLater(this.myPanelWrapper::repaint);
        });
    }

    @Nullable
    protected URL getStyle(boolean isDarcula) {
        return null;
    }

    private void updateLaf(boolean isDarcula) {
        URL styleUrl = this.getStyle(isDarcula);
        if (styleUrl == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> this.runInPlatformWhenAvailable(() -> {
            WebView webView = this.getWebViewGuaranteed();
            webView.getEngine().setUserStyleSheetLocation(styleUrl.toExternalForm());
        }));
    }

    public void dispose() {
        this.runInPlatformWhenAvailable(() -> this.getWebViewGuaranteed().getEngine().load(null));
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this.myLafManagerListener);
    }

    @NotNull
    protected WebView getWebViewGuaranteed() {
        if (this.myWebView == null) {
            throw new IllegalStateException("WebView should be initialized by now. Check the caller thread");
        }
        WebView webView = this.myWebView;
        if (webView == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(8);
        }
        return webView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/javafx/JavaFxHtmlPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toFxColor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/javafx/JavaFxHtmlPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHtml";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebViewGuaranteed";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerListeners";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runFX";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runInPlatformWhenAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setHtml";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JavaFXLafManagerListener
    implements LafManagerListener {
        private JavaFXLafManagerListener() {
        }

        public void lookAndFeelChanged(@NotNull LafManager manager) {
            if (manager == null) {
                JavaFXLafManagerListener.$$$reportNull$$$0(0);
            }
            JavaFxHtmlPanel.this.updateLaf(manager.getCurrentLookAndFeel() instanceof DarculaLookAndFeelInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ui/javafx/JavaFxHtmlPanel$JavaFXLafManagerListener", "lookAndFeelChanged"));
        }
    }
}

