/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.Cell;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.speedSearch.FilteringTableModel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUIDefaultsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowUIDefaultsAction.$$$reportNull$$$0(0);
        }
        Project project = ShowUIDefaultsAction.getEventProject((AnActionEvent)e);
        this.perform(project);
    }

    public void perform(final Project project) {
        new DialogWrapper(project, true){
            public JBTable myTable;
            public JBTextField mySearchField;
            public JBCheckBox myColorsOnly;
            {
                super(arg0, arg1);
                this.setTitle("Edit LaF Defaults");
                this.setModal(false);
                this.init();
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.mySearchField;
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return project == null ? null : "UI.Defaults.Dialog";
            }

            protected JComponent createCenterPanel() {
                this.mySearchField = new JBTextField(40);
                JPanel top = UI.PanelFactory.panel((JComponent)this.mySearchField).withLabel("Filter:").createPanel();
                JBTable table = new JBTable((TableModel)ShowUIDefaultsAction.createFilteringModel()){

                    public boolean editCellAt(int row, int column, EventObject e) {
                        if (this.isCellEditable(row, column) && e instanceof MouseEvent) {
                            Font newValue;
                            Pair pair = (Pair)this.getValueAt(row, 0);
                            Object key = pair.first;
                            Object value = pair.second;
                            boolean changed = false;
                            if (value instanceof Color) {
                                Color newColor = ColorPicker.showDialog((Component)((Object)this), "Choose Color", (Color)value, true, null, true);
                                if (newColor != null) {
                                    ColorUIResource colorUIResource = new ColorUIResource(newColor);
                                    this.updateValue(pair, colorUIResource, row, column);
                                    changed = true;
                                }
                            } else if (value instanceof Boolean) {
                                this.updateValue(pair, (Boolean)value == false, row, column);
                                changed = true;
                            } else if (value instanceof Integer) {
                                Integer newValue2 = this.editNumber(key.toString(), value.toString());
                                if (newValue2 != null) {
                                    this.updateValue(pair, newValue2, row, column);
                                    changed = true;
                                }
                            } else if (value instanceof EmptyBorder) {
                                Insets i = ((Border)value).getBorderInsets(null);
                                String oldInsets = String.format("%d,%d,%d,%d", i.top, i.left, i.bottom, i.right);
                                Insets newInsets = this.editInsets(key.toString(), oldInsets);
                                if (newInsets != null) {
                                    this.updateValue(pair, new JBEmptyBorder(newInsets), row, column);
                                    changed = true;
                                }
                            } else if (value instanceof Insets) {
                                Insets i = (Insets)value;
                                String oldInsets = String.format("%d,%d,%d,%d", i.top, i.left, i.bottom, i.right);
                                Insets newInsets = this.editInsets(key.toString(), oldInsets);
                                if (newInsets != null) {
                                    this.updateValue(pair, newInsets, row, column);
                                    changed = true;
                                }
                            } else if (value instanceof UIUtil.GrayFilter) {
                                UIUtil.GrayFilter f = (UIUtil.GrayFilter)value;
                                String oldFilter = String.format("%d,%d,%d", f.getBrightness(), f.getContrast(), f.getAlpha());
                                UIUtil.GrayFilter newValue3 = this.editGrayFilter(key.toString(), oldFilter);
                                if (newValue3 != null) {
                                    this.updateValue(pair, newValue3, row, column);
                                    changed = true;
                                }
                            } else if (value instanceof Font && (newValue = this.editFontSize(key.toString(), (Font)value)) != null) {
                                UIManager.getDefaults().remove(key);
                                UIManager.getDefaults().put(key, newValue);
                                this.setValueAt(newValue, row, column);
                                changed = true;
                            }
                            if (changed) {
                                ApplicationManager.getApplication().invokeLater(() -> {
                                    LafManager.getInstance().updateUI();
                                    LafManager.getInstance().repaintUI();
                                });
                            }
                        }
                        return false;
                    }

                    void updateValue(Pair value, Object newValue, int row, int col) {
                        UIManager.getDefaults().remove(value.first);
                        UIManager.getDefaults().put(value.first, newValue);
                        this.setValueAt(Pair.create((Object)value.first, (Object)newValue), row, col);
                    }
                };
                table.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        TableCellRenderer renderer2;
                        Object object = value = column == 0 ? ((Pair)value).first : ((Pair)value).second;
                        if (value instanceof Boolean && (renderer2 = table.getDefaultRenderer(Boolean.class)) != null) {
                            JCheckBox box = (JCheckBox)renderer2.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            box.setHorizontalAlignment(2);
                            return box;
                        }
                        JPanel panel2 = new JPanel(new BorderLayout());
                        JLabel label2 = new JLabel(value == null ? "" : value.toString());
                        panel2.add((Component)label2, "Center");
                        if (value instanceof Color) {
                            Color c2 = (Color)value;
                            label2.setText(String.format("  [%d,%d,%d] #%s", c2.getRed(), c2.getGreen(), c2.getBlue(), StringUtil.toUpperCase((String)ColorUtil.toHex((Color)c2))));
                            Gray fg = ColorUtil.isDark((Color)c2) ? Gray.xFF : Gray.x00;
                            label2.setForeground((Color)fg);
                            panel2.setBackground(c2);
                            return panel2;
                        }
                        if (value instanceof Icon) {
                            try {
                                IconWrap icon = new IconWrap((Icon)value);
                                if (icon.getIconHeight() <= 20) {
                                    label2.setIcon(icon);
                                }
                                label2.setText(String.format("(%dx%d) %s)", icon.getIconWidth(), icon.getIconHeight(), label2.getText()));
                            }
                            catch (Throwable icon) {
                                // empty catch block
                            }
                            return panel2;
                        }
                        if (value instanceof Border) {
                            try {
                                Insets i = ((Border)value).getBorderInsets(null);
                                label2.setText(String.format("[%d, %d, %d, %d] %s", i.top, i.left, i.bottom, i.right, label2.getText()));
                                return panel2;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                });
                new TableSpeedSearch((JTable)table, (PairFunction<Object, ? super Cell, String>)((PairFunction)(o, cell) -> cell.column == 1 ? null : String.valueOf(o)));
                table.setShowGrid(false);
                this.myTable = table;
                TableUtil.ensureSelectionExists((JTable)this.myTable);
                this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        this.updateFilter();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ShowUIDefaultsAction$1$3", "textChanged"));
                    }
                });
                ScrollingUtil.installActions((JTable)this.myTable, (boolean)true, (JComponent)this.mySearchField);
                this.myColorsOnly = new JBCheckBox("Colors only", PropertiesComponent.getInstance().getBoolean("LaFDialog.ColorsOnly", false)){

                    public void addNotify() {
                        super.addNotify();
                        this.updateFilter();
                    }
                };
                this.myColorsOnly.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PropertiesComponent.getInstance().setValue("LaFDialog.ColorsOnly", myColorsOnly.isSelected(), false);
                        this.updateFilter();
                    }
                });
                JPanel pane2 = ToolbarDecorator.createDecorator((JTable)this.myTable).setToolbarPosition(ActionToolbarPosition.BOTTOM).setAddAction(x -> this.addNewValue()).createPanel();
                BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)JBUI.Panels.simplePanel((Component)pane2).withBorder((Border)JBUI.Borders.empty((int)5, (int)0))).addToTop((Component)top).addToBottom((Component)this.myColorsOnly);
                DataProvider provider = dataId -> {
                    int row;
                    if (PlatformDataKeys.COPY_PROVIDER.is(dataId) && (this.mySearchField.hasFocus() && StringUtil.isEmpty((String)this.mySearchField.getSelectedText()) || this.myTable.hasFocus()) && (row = this.myTable.getSelectedRow()) != -1) {
                        final Pair pair = (Pair)this.myTable.getModel().getValueAt(row, 0);
                        if (pair.second instanceof Color) {
                            return new TextCopyProvider(){

                                public Collection<String> getTextLinesToCopy() {
                                    return Collections.singletonList("\"" + pair.first.toString() + "\": \"" + ColorUtil.toHtmlColor((Color)((Color)pair.second)) + "\"");
                                }
                            };
                        }
                    }
                    return null;
                };
                DataManager.registerDataProvider((JComponent)this.myTable, (DataProvider)provider);
                DataManager.registerDataProvider((JComponent)this.mySearchField, (DataProvider)provider);
                return panel2;
            }

            private void addNewValue() {
                ApplicationManager.getApplication().invokeLater(() -> new DialogWrapper((Component)this.myTable, true){
                    final JBTextField name;
                    final JBTextField value;
                    {
                        this.name = new JBTextField(40);
                        this.value = new JBTextField(40);
                        this.setTitle("Add New Value");
                        this.init();
                    }

                    protected JComponent createCenterPanel() {
                        return UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.name).withLabel("Name:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.value).withLabel("Value:")).createPanel();
                    }

                    @Nullable
                    public JComponent getPreferredFocusedComponent() {
                        return this.name;
                    }

                    protected void doOKAction() {
                        String key = this.name.getText().trim();
                        String val = this.value.getText().trim();
                        if (!key.isEmpty() && !val.isEmpty()) {
                            UIManager.put(key, UITheme.parseValue(key, val));
                            myTable.setModel((TableModel)ShowUIDefaultsAction.createFilteringModel());
                            this.updateFilter();
                        }
                        super.doOKAction();
                    }
                }.show());
            }

            private void updateFilter() {
                FilteringTableModel model2 = (FilteringTableModel)this.myTable.getModel();
                if (StringUtil.isEmpty((String)this.mySearchField.getText()) && !this.myColorsOnly.isSelected()) {
                    model2.setFilter(null);
                    return;
                }
                MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + this.mySearchField.getText()), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
                model2.setFilter(pair -> {
                    Object obj = ((Pair)pair).second;
                    String value = obj == null ? "null" : (obj instanceof Color ? ColorUtil.toHtmlColor((Color)((Color)obj)) : obj.toString());
                    value = ((Pair)pair).first.toString() + " " + value;
                    return (!this.myColorsOnly.isSelected() || obj instanceof Color) && matcher.matches(value);
                });
            }

            @Nullable
            private Integer editNumber(String key, String value) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)("Enter new value for " + key), (String)"Number Editor", null, (String)value, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        try {
                            Integer.parseInt(inputString);
                            return true;
                        }
                        catch (NumberFormatException nfe) {
                            return false;
                        }
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? Integer.valueOf(newValue) : null;
            }

            @Nullable
            private Insets editInsets(String key, String value) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)("Enter new value for " + key + "\nin form top,left,bottom,right"), (String)"Insets Editor", null, (String)value, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return this.parseInsets(inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? this.parseInsets(newValue) : null;
            }

            @Nullable
            private Insets parseInsets(String value) {
                Object[] parts = value.split(",");
                if (parts.length != 4) {
                    return null;
                }
                try {
                    List v = ContainerUtil.map((Object[])parts, p -> Integer.parseInt(p));
                    return JBUI.insets((int)((Integer)v.get(0)), (int)((Integer)v.get(1)), (int)((Integer)v.get(2)), (int)((Integer)v.get(3)));
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }

            @Nullable
            private UIUtil.GrayFilter editGrayFilter(String key, String value) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)("Enter new value for " + key + "\nin form brightness,contrast,alpha"), (String)"Gray Filter Editor", null, (String)value, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return this.parseGrayFilter(inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? this.parseGrayFilter(newValue) : null;
            }

            @Nullable
            private UIUtil.GrayFilter parseGrayFilter(String value) {
                Object[] parts = value.split(",");
                if (parts.length != 3) {
                    return null;
                }
                try {
                    List v = ContainerUtil.map((Object[])parts, p -> Integer.parseInt(p));
                    return new UIUtil.GrayFilter(((Integer)v.get(0)).intValue(), ((Integer)v.get(1)).intValue(), ((Integer)v.get(2)).intValue());
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }

            @Nullable
            private Font editFontSize(String key, final Font font) {
                String newValue = Messages.showInputDialog((Component)this.getRootPane(), (String)("Enter new font size for " + key), (String)"Font Size Editor", null, (String)Integer.toString(font.getSize()), (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return this.parseFontSize(font, inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                return newValue != null ? this.parseFontSize(font, newValue) : null;
            }

            @Nullable
            private Font parseFontSize(Font font, String value) {
                try {
                    int newSize = Integer.parseInt(value);
                    return newSize > 0 ? font.deriveFont((float)newSize) : null;
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }
        }.show();
    }

    @NotNull
    private static Object[][] getUIDefaultsData() {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys = defaults.keys();
        Object[][] data = new Object[defaults.size()][2];
        int i = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Pair row = Pair.create(key, (Object)defaults.get(key));
            data[i][0] = row;
            data[i][1] = row;
            ++i;
        }
        Arrays.sort(data, (o1, o2) -> StringUtil.naturalCompare((String)((Pair)o1[0]).first.toString(), (String)((Pair)o2[0]).first.toString()));
        if (data == null) {
            ShowUIDefaultsAction.$$$reportNull$$$0(1);
        }
        return data;
    }

    @NotNull
    private static FilteringTableModel<Object> createFilteringModel() {
        DefaultTableModel model2 = new DefaultTableModel(ShowUIDefaultsAction.getUIDefaultsData(), new Object[]{"Name", "Value"}){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column != 1) {
                    return false;
                }
                Object value = ((Pair)this.getValueAt((int)row, (int)column)).second;
                return value instanceof Color || value instanceof Boolean || value instanceof Integer || value instanceof EmptyBorder || value instanceof Insets || value instanceof UIUtil.GrayFilter || value instanceof Font;
            }
        };
        FilteringTableModel filteringTableModel = new FilteringTableModel((TableModel)model2, Object.class);
        filteringTableModel.setFilter(null);
        FilteringTableModel filteringTableModel2 = filteringTableModel;
        if (filteringTableModel2 == null) {
            ShowUIDefaultsAction.$$$reportNull$$$0(2);
        }
        return filteringTableModel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ShowUIDefaultsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ShowUIDefaultsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUIDefaultsData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilteringModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IconWrap
    implements Icon {
        private final Icon myIcon;

        IconWrap(Icon icon) {
            this.myIcon = icon;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            try {
                this.myIcon.paintIcon(c2, g, x, y);
            }
            catch (Exception e) {
                EmptyIcon.ICON_0.paintIcon(c2, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }
}

