/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsGroup;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolManager<T extends Tool> {
    @Nullable
    private final ActionManagerEx myActionManager;
    private final SchemeManager<ToolsGroup<T>> mySchemeManager;

    public BaseToolManager(@Nullable ActionManagerEx actionManagerEx, @NotNull SchemeManagerFactory factory, @NotNull String schemePath, @NotNull String presentableName) {
        if (factory == null) {
            BaseToolManager.$$$reportNull$$$0(0);
        }
        if (schemePath == null) {
            BaseToolManager.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            BaseToolManager.$$$reportNull$$$0(2);
        }
        this.myActionManager = actionManagerEx;
        this.mySchemeManager = factory.create(schemePath, this.createProcessor(), presentableName);
        this.mySchemeManager.loadSchemes();
        this.registerActions();
    }

    protected abstract SchemeProcessor<ToolsGroup<T>, ToolsGroup<T>> createProcessor();

    @Nullable
    public static String convertString(String s) {
        return StringUtil.nullize((String)s, (boolean)true);
    }

    public List<T> getTools() {
        SmartList result2 = new SmartList();
        for (ToolsGroup<T> group : this.mySchemeManager.getAllSchemes()) {
            result2.addAll(group.getElements());
        }
        return result2;
    }

    @NotNull
    public List<T> getTools(@NotNull String group) {
        ToolsGroup<T> groupByName;
        if (group == null) {
            BaseToolManager.$$$reportNull$$$0(3);
        }
        if ((groupByName = this.mySchemeManager.findSchemeByName(group)) == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                BaseToolManager.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List list3 = groupByName.getElements();
        if (list3 == null) {
            BaseToolManager.$$$reportNull$$$0(5);
        }
        return list3;
    }

    public String getGroupByActionId(String actionId) {
        for (Tool tool : this.getTools()) {
            if (!Comparing.equal((String)actionId, (String)tool.getActionId())) continue;
            return tool.getGroup();
        }
        return null;
    }

    public List<ToolsGroup<T>> getGroups() {
        return this.mySchemeManager.getAllSchemes();
    }

    public void setTools(@NotNull List<? extends ToolsGroup<T>> tools) {
        if (tools == null) {
            BaseToolManager.$$$reportNull$$$0(6);
        }
        this.mySchemeManager.setSchemes(tools);
        this.registerActions();
    }

    void registerActions() {
        if (this.myActionManager == null) {
            return;
        }
        this.unregisterActions();
        THashSet registeredIds = new THashSet();
        for (Tool tool : this.getTools()) {
            String actionId = tool.getActionId();
            if (!registeredIds.add(actionId)) continue;
            this.myActionManager.registerAction(actionId, (AnAction)this.createToolAction(tool));
        }
    }

    @NotNull
    protected ToolAction createToolAction(@NotNull T tool) {
        if (tool == null) {
            BaseToolManager.$$$reportNull$$$0(7);
        }
        ToolAction toolAction = new ToolAction((Tool)tool);
        if (toolAction == null) {
            BaseToolManager.$$$reportNull$$$0(8);
        }
        return toolAction;
    }

    protected abstract String getActionIdPrefix();

    private void unregisterActions() {
        if (this.myActionManager == null) {
            return;
        }
        for (String oldId : this.myActionManager.getActionIds(this.getActionIdPrefix())) {
            this.myActionManager.unregisterAction(oldId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/BaseToolManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/BaseToolManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTools";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTools";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTools";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createToolAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

