/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TextOccurrencesUtil {
    private TextOccurrencesUtil() {
    }

    @Deprecated
    public static void addTextOccurences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Collection<? super UsageInfo> results, @NotNull UsageInfoFactory factory) {
        if (element == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(0);
        }
        if (stringToSearch == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(2);
        }
        if (results == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(3);
        }
        if (factory == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(4);
        }
        TextOccurrencesUtil.addTextOccurrences(element, stringToSearch, searchScope, results, factory);
    }

    public static void addTextOccurrences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Collection<? super UsageInfo> results, @NotNull UsageInfoFactory factory) {
        if (element == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(5);
        }
        if (stringToSearch == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(7);
        }
        if (results == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(8);
        }
        if (factory == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(9);
        }
        PsiSearchHelperImpl.processTextOccurrences(element, stringToSearch, searchScope, (Processor<? super UsageInfo>)((Processor)t -> {
            results.add((UsageInfo)t);
            return true;
        }), factory);
    }

    private static boolean processStringLiteralsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, PsiSearchHelper helper, Processor<? super PsiElement> processor2) {
        if (identifier == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(11);
        }
        TextOccurenceProcessor occurenceProcessor = (element, offsetInElement) -> {
            ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
            ASTNode node = element.getNode();
            if (definition != null && node != null && definition.getStringLiteralElements().contains(node.getElementType())) {
                return processor2.process((Object)element);
            }
            return true;
        };
        return helper.processElementsWithWord(occurenceProcessor, searchScope, identifier, (short)4, true);
    }

    @Deprecated
    public static boolean processUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull String stringToSearch, boolean ignoreReferences, @NotNull PairProcessor<? super PsiElement, ? super TextRange> processor2) {
        if (element == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(12);
        }
        if (stringToSearch == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(13);
        }
        if (processor2 == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(14);
        }
        return TextOccurrencesUtil.processUsagesInStringsAndComments(element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), stringToSearch, ignoreReferences, processor2);
    }

    public static boolean processUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull SearchScope searchScope, @NotNull String stringToSearch, boolean ignoreReferences, @NotNull PairProcessor<? super PsiElement, ? super TextRange> processor2) {
        Processor commentOrLiteralProcessor;
        if (element == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(16);
        }
        if (stringToSearch == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(17);
        }
        if (processor2 == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(18);
        }
        PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)element.getProject());
        SearchScope scope = helper.getUseScope(element);
        return TextOccurrencesUtil.processStringLiteralsContainingIdentifier(stringToSearch, scope = scope.intersectWith(searchScope), helper, (Processor<? super PsiElement>)(commentOrLiteralProcessor = literal -> TextOccurrencesUtil.processTextIn(literal, stringToSearch, ignoreReferences, processor2))) && helper.processCommentsContainingIdentifier(stringToSearch, scope, commentOrLiteralProcessor);
    }

    @Deprecated
    public static void addUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull Collection<? super UsageInfo> results, @NotNull UsageInfoFactory factory) {
        if (element == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(19);
        }
        if (stringToSearch == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(20);
        }
        if (results == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(21);
        }
        if (factory == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(22);
        }
        TextOccurrencesUtil.addUsagesInStringsAndComments(element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), stringToSearch, results, factory);
    }

    public static void addUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull SearchScope searchScope, @NotNull String stringToSearch, @NotNull Collection<? super UsageInfo> results, @NotNull UsageInfoFactory factory) {
        if (element == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(23);
        }
        if (searchScope == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(24);
        }
        if (stringToSearch == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(25);
        }
        if (results == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(26);
        }
        if (factory == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(27);
        }
        Object lock = new Object();
        TextOccurrencesUtil.processUsagesInStringsAndComments(element, searchScope, stringToSearch, false, (PairProcessor<? super PsiElement, ? super TextRange>)((PairProcessor)(commentOrLiteral, textRange) -> {
            UsageInfo usageInfo = factory.createUsageInfo(commentOrLiteral, textRange.getStartOffset(), textRange.getEndOffset());
            if (usageInfo != null) {
                Object object = lock;
                synchronized (object) {
                    results.add(usageInfo);
                }
            }
            return true;
        }));
    }

    private static boolean processTextIn(PsiElement scope, String stringToSearch, boolean ignoreReferences, PairProcessor<? super PsiElement, ? super TextRange> processor2) {
        String text2 = scope.getText();
        for (int offset = 0; offset < text2.length() && (offset = text2.indexOf(stringToSearch, offset)) >= 0; ++offset) {
            char c2;
            PsiReference referenceAt = scope.findReferenceAt(offset);
            if (!ignoreReferences && referenceAt != null && (referenceAt.resolve() != null || referenceAt instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)referenceAt).multiResolve(true).length > 0) || offset > 0 && Character.isJavaIdentifierPart(c2 = text2.charAt(offset - 1)) && c2 != '$' && (offset < 2 || text2.charAt(offset - 2) != '\\') || offset + stringToSearch.length() < text2.length() && Character.isJavaIdentifierPart(c2 = text2.charAt(offset + stringToSearch.length())) && c2 != '$') continue;
            TextRange textRange = new TextRange(offset, offset + stringToSearch.length());
            if (!processor2.process((Object)scope, (Object)textRange)) {
                return false;
            }
            offset += stringToSearch.length();
        }
        return true;
    }

    public static boolean isSearchTextOccurrencesEnabled(@NotNull PsiElement element) {
        if (element == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(28);
        }
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)element.getProject())).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler(element, true);
        return FindUsagesUtil.isSearchForTextOccurrencesAvailable(element, false, handler2);
    }

    @Deprecated
    public static void findNonCodeUsages(PsiElement element, String stringToSearch, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName, Collection<? super UsageInfo> results) {
        TextOccurrencesUtil.findNonCodeUsages(element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), stringToSearch, searchInStringsAndComments, searchInNonJavaFiles, newQName, results);
    }

    public static void findNonCodeUsages(@NotNull PsiElement element, @NotNull SearchScope searchScope, String stringToSearch, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName, Collection<? super UsageInfo> results) {
        if (element == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(29);
        }
        if (searchScope == null) {
            TextOccurrencesUtil.$$$reportNull$$$0(30);
        }
        if (searchInStringsAndComments || searchInNonJavaFiles) {
            UsageInfoFactory factory = TextOccurrencesUtil.createUsageInfoFactory(element, newQName);
            if (searchInStringsAndComments) {
                TextOccurrencesUtil.addUsagesInStringsAndComments(element, searchScope, stringToSearch, results, factory);
            }
            if (searchInNonJavaFiles && searchScope instanceof GlobalSearchScope) {
                TextOccurrencesUtil.addTextOccurrences(element, stringToSearch, (GlobalSearchScope)searchScope, results, factory);
            }
        }
    }

    private static UsageInfoFactory createUsageInfoFactory(PsiElement element, String newQName) {
        return (usage, startOffset, endOffset) -> {
            int start2 = usage.getTextRange().getStartOffset();
            return NonCodeUsageInfo.create((PsiFile)usage.getContainingFile(), (int)(start2 + startOffset), (int)(start2 + endOffset), (PsiElement)element, (String)newQName);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 13: 
            case 17: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToSearch";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 16: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: 
            case 8: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 4: 
            case 9: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/util/TextOccurrencesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addTextOccurences";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addTextOccurrences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processStringLiteralsContainingIdentifier";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "processUsagesInStringsAndComments";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "addUsagesInStringsAndComments";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "isSearchTextOccurrencesEnabled";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "findNonCodeUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

