/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveFilesOrDirectoriesProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor");
    protected final PsiElement[] myElementsToMove;
    protected final boolean mySearchForReferences;
    protected final boolean mySearchInComments;
    protected final boolean mySearchInNonJavaFiles;
    private final PsiDirectory myNewParent;
    private final MoveCallback myMoveCallback;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final Map<PsiFile, List<UsageInfo>> myFoundUsages = new HashMap<PsiFile, List<UsageInfo>>();

    public MoveFilesOrDirectoriesProcessor(Project project, PsiElement[] elements2, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback, Runnable prepareSuccessfulCallback) {
        this(project, elements2, newParent, true, searchInComments, searchInNonJavaFiles, moveCallback, prepareSuccessfulCallback);
    }

    public MoveFilesOrDirectoriesProcessor(Project project, PsiElement[] elements2, PsiDirectory newParent, boolean searchForReferences, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback, Runnable prepareSuccessfulCallback) {
        super(project, prepareSuccessfulCallback);
        this.myElementsToMove = elements2;
        this.myNewParent = newParent;
        this.mySearchForReferences = searchForReferences;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(0);
        }
        MoveFilesOrDirectoriesViewDescriptor moveFilesOrDirectoriesViewDescriptor = new MoveFilesOrDirectoriesViewDescriptor(this.myElementsToMove, this.myNewParent);
        if (moveFilesOrDirectoriesViewDescriptor == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(1);
        }
        return moveFilesOrDirectoriesViewDescriptor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<MyUsageInfo> result2 = new ArrayList<MyUsageInfo>();
        for (int i = 0; i < this.myElementsToMove.length; ++i) {
            PsiElement element = this.myElementsToMove[i];
            if (this.mySearchForReferences) {
                for (PsiReference reference2 : ReferencesSearch.search((PsiElement)element, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject))) {
                    result2.add(new MyUsageInfo(reference2.getElement(), i, reference2));
                }
            }
            this.findElementUsages(result2, element);
        }
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    private void findElementUsages(ArrayList<? super UsageInfo> result2, PsiElement element) {
        if (!this.mySearchForReferences) {
            return;
        }
        if (element instanceof PsiFile) {
            List<UsageInfo> usages = MoveFileHandler.forElement((PsiFile)element).findUsages((PsiFile)element, this.myNewParent, this.mySearchInComments, this.mySearchInNonJavaFiles);
            if (usages != null) {
                result2.addAll(usages);
                this.myFoundUsages.put((PsiFile)element, usages);
            }
        } else if (element instanceof PsiDirectory) {
            for (PsiElement childElement : element.getChildren()) {
                this.findElementUsages(result2, childElement);
            }
        }
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements2) {
        if (elements2 == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(elements2.length == this.myElementsToMove.length);
        System.arraycopy(elements2, 0, this.myElementsToMove, 0, elements2.length);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        }
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(4);
        }
        try {
            LinkedHashMap<PsiFile, FileASTNode> movedFiles = new LinkedHashMap<PsiFile, FileASTNode>();
            HashMap<PsiElement, PsiElement> oldToNewMap = new HashMap<PsiElement, PsiElement>();
            for (PsiElement element : this.myElementsToMove) {
                RefactoringElementListener elementListener = this.getTransaction().getElementListener(element);
                if (element instanceof PsiDirectory) {
                    if (this.mySearchForReferences) {
                        MoveFilesOrDirectoriesProcessor.encodeDirectoryFiles(element, movedFiles);
                    }
                    MoveFilesOrDirectoriesUtil.doMoveDirectory((PsiDirectory)element, this.myNewParent);
                    for (PsiElement psiElement : element.getChildren()) {
                        MoveFilesOrDirectoriesProcessor.processDirectoryFiles(movedFiles, oldToNewMap, psiElement);
                    }
                } else if (element instanceof PsiFile) {
                    PsiFile movedFile = (PsiFile)element;
                    FileASTNode node = movedFile.getNode();
                    if (this.mySearchForReferences) {
                        FileReferenceContextUtil.encodeFileReferences(element);
                    }
                    MoveFileHandler.forElement(movedFile).prepareMovedFile(movedFile, this.myNewParent, oldToNewMap);
                    PsiFile moving = this.myNewParent.findFile(movedFile.getName());
                    if (moving == null) {
                        MoveFilesOrDirectoriesUtil.doMoveFile(movedFile, this.myNewParent);
                    }
                    if ((moving = this.myNewParent.findFile(movedFile.getName())) != null) {
                        movedFiles.put(moving, moving.getNode());
                        ObjectUtils.reachabilityFence((Object)node);
                    }
                }
                elementListener.elementMoved(element);
            }
            CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
            DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            for (PsiFile movedFile : movedFiles.keySet()) {
                MoveFileHandler.forElement(movedFile).updateMovedFile(movedFile);
                if (!this.mySearchForReferences) continue;
                FileReferenceContextUtil.decodeFileReferences((PsiElement)movedFile);
            }
            this.retargetUsages(usages, oldToNewMap);
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
            if (MoveFilesOrDirectoriesDialog.isOpenInEditor()) {
                ArrayList justFiles = new ArrayList(movedFiles.keySet());
                ApplicationManager.getApplication().invokeLater(() -> EditorHelper.openFilesInEditor((PsiElement[])((PsiElement[])justFiles.stream().filter(PsiElement::isValid).toArray(PsiFile[]::new))));
            }
        }
        catch (IncorrectOperationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)this.myProject, (String)cause.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon()));
            }
            LOG.error((Throwable)e);
        }
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(this.myElementsToMove);
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(5);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myNewParent);
        return data;
    }

    private static void encodeDirectoryFiles(PsiElement psiElement, Map<PsiFile, FileASTNode> movedFiles) {
        if (psiElement instanceof PsiFile) {
            movedFiles.put((PsiFile)psiElement, ((PsiFile)psiElement).getNode());
            FileReferenceContextUtil.encodeFileReferences(psiElement);
        } else if (psiElement instanceof PsiDirectory) {
            for (PsiElement element : psiElement.getChildren()) {
                MoveFilesOrDirectoriesProcessor.encodeDirectoryFiles(element, movedFiles);
            }
        }
    }

    private static void processDirectoryFiles(Map<PsiFile, FileASTNode> movedFiles, Map<PsiElement, PsiElement> oldToNewMap, PsiElement psiElement) {
        if (psiElement instanceof PsiFile) {
            PsiFile movedFile = (PsiFile)psiElement;
            movedFiles.put(movedFile, movedFile.getNode());
            MoveFileHandler.forElement(movedFile).prepareMovedFile(movedFile, movedFile.getParent(), oldToNewMap);
        } else if (psiElement instanceof PsiDirectory) {
            for (PsiElement element : psiElement.getChildren()) {
                MoveFilesOrDirectoriesProcessor.processDirectoryFiles(movedFiles, oldToNewMap, element);
            }
        }
    }

    protected void retargetUsages(UsageInfo[] usages, Map<PsiElement, PsiElement> oldToNewMap) {
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usageInfo : usages) {
            if (usageInfo instanceof MyUsageInfo) {
                PsiElement refElement;
                PsiFile usageFile;
                PsiFile psiFile;
                PsiElement usageElement;
                MyUsageInfo info = (MyUsageInfo)usageInfo;
                PsiElement element = this.myElementsToMove[info.myIndex];
                if ((info.getReference() instanceof FileReference || info.getReference() instanceof PsiDynaReference) && (usageElement = info.getElement()) != null && (psiFile = (usageFile = usageElement.getContainingFile()).getViewProvider().getPsi(usageFile.getViewProvider().getBaseLanguage())) != null && psiFile.equals(element) || !(refElement = info.myReference.getElement()).isValid()) continue;
                info.myReference.bindToElement(element);
                continue;
            }
            if (!(usageInfo instanceof NonCodeUsageInfo)) continue;
            nonCodeUsages.add((NonCodeUsageInfo)usageInfo);
        }
        for (PsiFile movedFile : this.myFoundUsages.keySet()) {
            MoveFileHandler.forElement(movedFile).retargetUsages(this.myFoundUsages.get(movedFile), oldToNewMap);
        }
        this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[0]);
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"move.title");
        if (string == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected boolean shouldDisableAccessChecks() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyUsageInfo
    extends UsageInfo {
        int myIndex;
        PsiReference myReference;

        MyUsageInfo(PsiElement element, int index, PsiReference reference2) {
            super(element);
            this.myIndex = index;
            this.myReference = reference2;
        }
    }
}

