/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveFilesOrDirectoriesHandler
extends MoveHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler");

    @Override
    public boolean canMove(PsiElement[] elements2, PsiElement targetContainer, @Nullable PsiReference reference2) {
        HashSet<String> names2 = new HashSet<String>();
        for (PsiElement element : elements2) {
            if (element instanceof PsiFile) {
                PsiFile file2 = (PsiFile)element;
                String name = file2.getName();
                if (names2.contains(name)) {
                    return false;
                }
                names2.add(name);
                continue;
            }
            if (element instanceof PsiDirectory) continue;
            return false;
        }
        return super.canMove(elements2, targetContainer, reference2);
    }

    @Override
    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        return MoveFilesOrDirectoriesHandler.isValidTarget(targetElement);
    }

    public static boolean isValidTarget(PsiElement psiElement) {
        if (psiElement == null) {
            return true;
        }
        if (!(psiElement instanceof PsiDirectory) && !(psiElement instanceof PsiDirectoryContainer)) {
            return false;
        }
        if (psiElement.getManager().isInProject(psiElement)) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        return ScratchFileService.isInScratchRoot((VirtualFile)virtualFile) || virtualFile != null && ProjectRootManager.getInstance((Project)psiElement.getProject()).getFileIndex().isExcluded(virtualFile);
    }

    public void doMove(PsiElement[] elements2, PsiElement targetContainer) {
        Project project = targetContainer != null ? targetContainer.getProject() : elements2[0].getProject();
        this.doMove(project, elements2, targetContainer, null);
    }

    @Override
    @Nullable
    public PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        return PsiTreeUtil.filterAncestors((PsiElement[])sourceElements);
    }

    @Override
    public void doMove(Project project, PsiElement[] elements2, PsiElement targetContainer, @Nullable MoveCallback callback2) {
        if (!LOG.assertTrue(targetContainer == null || targetContainer instanceof PsiDirectory || targetContainer instanceof PsiDirectoryContainer, (Object)("container: " + targetContainer + "; elements: " + Arrays.toString(elements2) + "; working handler: " + this.toString()))) {
            return;
        }
        PsiElement[] adjustedElements = this.adjustForMove(project, elements2, targetContainer);
        if (adjustedElements != null) {
            MoveFilesOrDirectoriesUtil.doMove(project, adjustedElements, new PsiElement[]{targetContainer}, callback2);
        }
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference2, Editor editor) {
        if (element instanceof PsiFile && ((PsiFile)element).getVirtualFile() != null || element instanceof PsiDirectory) {
            this.doMove(project, new PsiElement[]{element}, (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext), null);
            return true;
        }
        if (element instanceof PsiPlainText) {
            PsiFile file2 = element.getContainingFile();
            if (file2 != null) {
                this.doMove(project, new PsiElement[]{file2}, null, null);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getActionName(@NotNull PsiElement[] elements2) {
        if (elements2 == null) {
            MoveFilesOrDirectoriesHandler.$$$reportNull$$$0(0);
        }
        return MoveFilesOrDirectoriesHandler.getMoveOrCopyActionName(elements2, "Move");
    }

    @NotNull
    public static String getMoveOrCopyActionName(@NotNull PsiElement[] elements2, String verb) {
        if (elements2 == null) {
            MoveFilesOrDirectoriesHandler.$$$reportNull$$$0(1);
        }
        int fileCount = 0;
        int directoryCount = 0;
        for (PsiElement element : elements2) {
            if (element instanceof PsiFile) {
                ++fileCount;
                continue;
            }
            if (!(element instanceof PsiDirectory)) continue;
            ++directoryCount;
        }
        if (directoryCount == 0) {
            String string = fileCount == 1 ? verb + " File..." : verb + " Files...";
            if (string == null) {
                MoveFilesOrDirectoriesHandler.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (fileCount == 0) {
            String string = directoryCount == 1 ? verb + " Directory..." : verb + " Directories...";
            if (string == null) {
                MoveFilesOrDirectoriesHandler.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = verb + " Files and Directories...";
        if (string == null) {
            MoveFilesOrDirectoriesHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveOrCopyActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMoveOrCopyActionName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

