/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.invertBoolean.InvertBooleanDelegate;
import com.intellij.refactoring.invertBoolean.InvertBooleanHandler;
import com.intellij.refactoring.invertBoolean.InvertBooleanUsageViewDescriptor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvertBooleanProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.invertBoolean.InvertBooleanMethodProcessor");
    private final InvertBooleanDelegate myDelegate;
    private PsiElement myElement;
    private final String myNewName;
    private final RenameProcessor myRenameProcessor;
    private final Map<UsageInfo, SmartPsiElementPointer> myToInvert = new HashMap<UsageInfo, SmartPsiElementPointer>();
    private final SmartPointerManager mySmartPointerManager;

    public InvertBooleanProcessor(PsiElement namedElement, String newName) {
        super(namedElement.getProject());
        this.myElement = namedElement;
        this.myNewName = newName;
        Project project = namedElement.getProject();
        boolean canRename = namedElement instanceof PsiNamedElement && !Comparing.equal((String)((PsiNamedElement)namedElement).getName(), (String)this.myNewName);
        this.myRenameProcessor = canRename ? new RenameProcessor(project, namedElement, newName, false, false){

            @Override
            @NotNull
            protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
                if (conflicts == null) {
                    1.$$$reportNull$$$0(0);
                }
                ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts, usages == null ? null : () -> InvertBooleanProcessor.this.execute(usages), false, true);
                if (conflictsDialog == null) {
                    1.$$$reportNull$$$0(1);
                }
                return conflictsDialog;
            }

            @Override
            protected void prepareSuccessful() {
                InvertBooleanProcessor.this.prepareSuccessful();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "conflicts";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createConflictsDialog";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createConflictsDialog";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        } : null;
        this.mySmartPointerManager = SmartPointerManager.getInstance((Project)project);
        this.myDelegate = InvertBooleanDelegate.findInvertBooleanDelegate(this.myElement);
        LOG.assertTrue(this.myDelegate != null);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(0);
        }
        InvertBooleanUsageViewDescriptor invertBooleanUsageViewDescriptor = new InvertBooleanUsageViewDescriptor(this.myElement);
        if (invertBooleanUsageViewDescriptor == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(1);
        }
        return invertBooleanUsageViewDescriptor;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(2);
        }
        MultiMap conflicts = new MultiMap();
        UsageInfo[] usageInfos = (UsageInfo[])refUsages.get();
        this.myDelegate.findConflicts(usageInfos, (MultiMap<PsiElement, String>)conflicts);
        if (!conflicts.isEmpty()) {
            return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usageInfos);
        }
        if (this.myRenameProcessor == null || this.myRenameProcessor.preprocessUsages(refUsages)) {
            this.prepareSuccessful();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<SmartPsiElementPointer> toInvert = new ArrayList<SmartPsiElementPointer>();
        LinkedHashSet<PsiElement> elementsToInvert = new LinkedHashSet<PsiElement>();
        this.myDelegate.collectRefElements(this.myElement, this.myRenameProcessor, this.myNewName, elementsToInvert);
        for (PsiElement element : elementsToInvert) {
            toInvert.add(this.mySmartPointerManager.createSmartPsiElementPointer(element));
        }
        UsageInfo[] renameUsages = this.myRenameProcessor != null ? this.myRenameProcessor.findUsages() : UsageInfo.EMPTY_ARRAY;
        SmartPsiElementPointer[] usagesToInvert = toInvert.toArray(new SmartPsiElementPointer[0]);
        HashMap<PsiElement, UsageInfo> expressionsToUsages = new HashMap<PsiElement, UsageInfo>();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (UsageInfo usageInfo : renameUsages) {
            expressionsToUsages.put(usageInfo.getElement(), usageInfo);
            result2.add(usageInfo);
        }
        for (UsageInfo usageInfo : usagesToInvert) {
            PsiElement expression = usageInfo.getElement();
            if (!expressionsToUsages.containsKey(expression)) {
                UsageInfo usageInfo2 = new UsageInfo(expression);
                expressionsToUsages.put(expression, usageInfo2);
                result2.add(usageInfo2);
                this.myToInvert.put(usageInfo2, (SmartPsiElementPointer)usageInfo);
                continue;
            }
            this.myToInvert.put((UsageInfo)expressionsToUsages.get(expression), (SmartPsiElementPointer)usageInfo);
        }
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements2) {
        if (elements2 == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(4);
        }
        this.myElement = elements2[0];
    }

    private static UsageInfo[] extractUsagesForElement(PsiElement element, UsageInfo[] usages) {
        ArrayList<MoveRenameUsageInfo> extractedUsages = new ArrayList<MoveRenameUsageInfo>(usages.length);
        for (UsageInfo usage : usages) {
            MoveRenameUsageInfo usageInfo;
            if (!(usage instanceof MoveRenameUsageInfo) || !element.equals((usageInfo = (MoveRenameUsageInfo)usage).getReferencedElement())) continue;
            extractedUsages.add(usageInfo);
        }
        return extractedUsages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(5);
        }
        if (this.myRenameProcessor != null) {
            for (PsiElement element : this.myRenameProcessor.getElements()) {
                try {
                    RenameUtil.doRename(element, this.myRenameProcessor.getNewName(element), InvertBooleanProcessor.extractUsagesForElement(element, usages), this.myProject, null);
                }
                catch (IncorrectOperationException e) {
                    RenameUtil.showErrorMessage(e, element, this.myProject);
                    return;
                }
            }
        }
        for (UsageInfo usage : usages) {
            SmartPsiElementPointer pointerToInvert = this.myToInvert.get(usage);
            if (pointerToInvert == null) continue;
            PsiElement element = pointerToInvert.getElement();
            LOG.assertTrue(element != null);
            InvertBooleanDelegate delegate = InvertBooleanDelegate.findInvertBooleanDelegate(element);
            try {
                (delegate != null ? delegate : this.myDelegate).replaceWithNegatedExpression(element);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myDelegate.invertElementInitializer(this.myElement);
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = InvertBooleanHandler.REFACTORING_NAME;
        if (string == null) {
            InvertBooleanProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/invertBoolean/InvertBooleanProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

