/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.stubs.IndexedStubs;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubCumulativeInputDiffBuilder;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.forward.AbstractForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubUpdatingForwardIndexAccessor
extends AbstractForwardIndexAccessor<Integer, SerializedStubTree, IndexedStubs> {
    StubUpdatingForwardIndexAccessor() {
        super((DataExternalizer)new DataExternalizer<IndexedStubs>(){
            private volatile boolean myEnsuredStubElementTypesLoaded;

            public void save(@NotNull DataOutput out, IndexedStubs indexedStubs) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                byte[] hash = indexedStubs.getStubTreeHash();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)hash.length);
                out.write(hash);
                Map<StubIndexKey, Map<Object, StubIdList>> stubIndicesValueMap = indexedStubs.getStubIndicesValueMap();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)stubIndicesValueMap.size());
                if (!stubIndicesValueMap.isEmpty()) {
                    StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
                    for (StubIndexKey stubIndexKey : stubIndicesValueMap.keySet()) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubIndexKey.getUniqueId());
                        Map<Object, StubIdList> map2 = stubIndicesValueMap.get(stubIndexKey);
                        stubIndex.serializeIndexValue(out, stubIndexKey, map2);
                    }
                }
            }

            public IndexedStubs read(@NotNull DataInput in) throws IOException {
                int stubIndicesValueMapSize;
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                byte[] hash = new byte[DataInputOutputUtil.readINT((DataInput)in)];
                in.readFully(hash);
                if (!this.myEnsuredStubElementTypesLoaded) {
                    ProgressManager.getInstance().executeNonCancelableSection(() -> {
                        SerializationManager.getInstance().initSerializers();
                        StubIndexImpl.initExtensions();
                    });
                    this.myEnsuredStubElementTypesLoaded = true;
                }
                if ((stubIndicesValueMapSize = DataInputOutputUtil.readINT((DataInput)in)) > 0) {
                    THashMap stubIndicesValueMap = new THashMap(stubIndicesValueMapSize);
                    StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
                    for (int i = 0; i < stubIndicesValueMapSize; ++i) {
                        int stubIndexId = DataInputOutputUtil.readINT((DataInput)in);
                        ID indexKey = ID.findById((int)stubIndexId);
                        if (!(indexKey instanceof StubIndexKey)) continue;
                        StubIndexKey stubIndexKey = (StubIndexKey)indexKey;
                        stubIndicesValueMap.put((Object)stubIndexKey, stubIndex.deserializeIndexValue(in, stubIndexKey));
                    }
                    return new IndexedStubs(hash, (Map<StubIndexKey, Map<Object, StubIdList>>)stubIndicesValueMap);
                }
                return new IndexedStubs(hash, Collections.emptyMap());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingForwardIndexAccessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public IndexedStubs convertToDataType(@NotNull InputData<Integer, SerializedStubTree> data) {
        if (data == null) {
            StubUpdatingForwardIndexAccessor.$$$reportNull$$$0(0);
        }
        return StubUpdatingForwardIndexAccessor.getIndexedStubs(data.getKeyValues());
    }

    protected InputDataDiffBuilder<Integer, SerializedStubTree> createDiffBuilder(int inputId, @Nullable IndexedStubs inputData) {
        return new StubCumulativeInputDiffBuilder(inputId, inputData);
    }

    @Nullable
    static IndexedStubs getIndexedStubs(@Nullable Map<? extends Integer, ? extends SerializedStubTree> map2) {
        SerializedStubTree serializedStubTree = (SerializedStubTree)ContainerUtil.getFirstItem(ContainerUtil.notNullize(map2).values());
        return serializedStubTree == null ? null : serializedStubTree.getIndexedStubs();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/psi/stubs/StubUpdatingForwardIndexAccessor", "convertToDataType"));
    }
}

