/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

class IntEnumerator {
    private final TIntIntHashMap myEnumerates;
    private final TIntArrayList myIds;
    private int myNext = 0;

    IntEnumerator() {
        this(true);
    }

    private IntEnumerator(boolean forSavingStub) {
        this.myEnumerates = forSavingStub ? new TIntIntHashMap(1) : null;
        this.myIds = new TIntArrayList();
    }

    int enumerate(int number) {
        assert (this.myEnumerates != null);
        int i = this.myEnumerates.get(number);
        if (i == 0) {
            i = this.myNext;
            this.myEnumerates.put(number, this.myNext++);
            this.myIds.add(number);
        }
        return i;
    }

    int valueOf(int id) {
        return this.myIds.get(id);
    }

    void dump(DataOutputStream stream) throws IOException {
        assert (this.myEnumerates != null);
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.myIds.size());
        this.myIds.forEach(id -> {
            try {
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)id);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        });
    }

    static IntEnumerator read(DataInputStream stream) throws IOException {
        int size = DataInputOutputUtil.readINT((DataInput)stream);
        IntEnumerator enumerator = new IntEnumerator(false);
        for (int i = 1; i < size + 1; ++i) {
            enumerator.myIds.add(DataInputOutputUtil.readINT((DataInput)stream));
        }
        return enumerator;
    }
}

