/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiManagerImpl
extends PsiManagerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiManagerImpl");
    private final Project myProject;
    private final FileIndexFacade myFileIndex;
    private final MessageBus myMessageBus;
    private final PsiModificationTracker myModificationTracker;
    private final FileManagerImpl myFileManager;
    private final List<PsiTreeChangePreprocessor> myTreeChangePreprocessors = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<PsiTreeChangeListener> myTreeChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myTreeChangeEventIsFiring;
    private boolean myIsDisposed;
    private VirtualFileFilter myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
    private final AtomicInteger myBatchFilesProcessingModeCount = new AtomicInteger(0);
    public static final Topic<AnyPsiChangeListener> ANY_PSI_CHANGE_TOPIC = Topic.create((String)"ANY_PSI_CHANGE_TOPIC", AnyPsiChangeListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);

    public PsiManagerImpl(Project project, FileDocumentManager fileDocumentManager, PsiBuilderFactory psiBuilderFactory, FileIndexFacade fileIndex, MessageBus messageBus, PsiModificationTracker modificationTracker) {
        this.myProject = project;
        this.myFileIndex = fileIndex;
        this.myMessageBus = messageBus;
        this.myModificationTracker = modificationTracker;
        this.myFileManager = new FileManagerImpl(this, fileDocumentManager, fileIndex);
        this.myTreeChangePreprocessors.add((PsiTreeChangePreprocessor)modificationTracker);
        Disposer.register((Disposable)project, () -> {
            this.myIsDisposed = true;
        });
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void dropResolveCaches() {
        this.myFileManager.processQueue();
        this.beforeChange(true);
    }

    public void dropPsiCaches() {
        this.dropResolveCaches();
        WriteAction.run(this.myFileManager::firePropertyChangedForUnloadedPsi);
    }

    public boolean isInProject(@NotNull PsiElement element) {
        if (element == null) {
            PsiManagerImpl.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] dirs;
            for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)element).getDirectories()) {
                if (this.isInProject((PsiElement)dir)) continue;
                return false;
            }
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        VirtualFile virtualFile = null;
        if (file2 != null) {
            virtualFile = file2.getViewProvider().getVirtualFile();
        } else if (element instanceof PsiFileSystemItem) {
            virtualFile = ((PsiFileSystemItem)element).getVirtualFile();
        }
        if (file2 != null && file2.isPhysical() && virtualFile.getFileSystem() instanceof NonPhysicalFileSystem) {
            return true;
        }
        return virtualFile != null && this.myFileIndex.isInContent(virtualFile);
    }

    @Override
    public void setAssertOnFileLoadingFilter(@NotNull VirtualFileFilter filter, @NotNull Disposable parentDisposable) {
        if (filter == null) {
            PsiManagerImpl.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            PsiManagerImpl.$$$reportNull$$$0(2);
        }
        this.myAssertOnFileLoadingFilter = filter;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
        });
    }

    @Override
    public boolean isAssertOnFileLoading(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(3);
        }
        return this.myAssertOnFileLoadingFilter.accept(file2);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PsiManagerImpl.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Override
    @NotNull
    public FileManager getFileManager() {
        FileManagerImpl fileManagerImpl = this.myFileManager;
        if (fileManagerImpl == null) {
            PsiManagerImpl.$$$reportNull$$$0(5);
        }
        return fileManagerImpl;
    }

    public boolean areElementsEquivalent(PsiElement element1, PsiElement element2) {
        ProgressIndicatorProvider.checkCanceled();
        if (element1 == element2) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        return element1.equals(element2) || element1.isEquivalentTo(element2) || element2.isEquivalentTo(element1);
    }

    public PsiFile findFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(6);
        }
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findFile(file2);
    }

    @Nullable
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(7);
        }
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findViewProvider(file2);
    }

    public PsiDirectory findDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(8);
        }
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findDirectory(file2);
    }

    public void reloadFromDisk(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(9);
        }
        this.myFileManager.reloadFromDisk(file2);
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener2) {
        if (listener2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(10);
        }
        this.myTreeChangeListeners.add(listener2);
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            PsiManagerImpl.$$$reportNull$$$0(12);
        }
        this.addPsiTreeChangeListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removePsiTreeChangeListener(listener2));
    }

    public void removePsiTreeChangeListener(@NotNull PsiTreeChangeListener listener2) {
        if (listener2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(13);
        }
        this.myTreeChangeListeners.remove(listener2);
    }

    private static String logPsi(@Nullable PsiElement element) {
        return element == null ? " null" : element.getClass().getName();
    }

    @Override
    public void beforeChildAddition(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(14);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildAddition: event = " + (Object)((Object)event));
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildRemoval(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(15);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REMOVAL);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildRemoval: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildReplacement(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(16);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildReplacement: oldChild = " + PsiManagerImpl.logPsi(event.getOldChild()));
        }
        this.fireEvent(event);
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(17);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildrenChange: parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(18);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_MOVEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildMovement: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", oldParent = " + PsiManagerImpl.logPsi(event.getOldParent()) + ", newParent = " + PsiManagerImpl.logPsi(event.getNewParent()));
        }
        this.fireEvent(event);
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(19);
        }
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforePropertyChange: element = " + PsiManagerImpl.logPsi(event.getElement()) + ", propertyName = " + event.getPropertyName() + ", oldValue = " + PsiManagerImpl.arrayToString(event.getOldValue()));
        }
        this.fireEvent(event);
    }

    private static Object arrayToString(Object value) {
        return value instanceof Object[] ? Arrays.deepToString((Object[])value) : value;
    }

    public void childAdded(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(20);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childAdded: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childRemoved(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(21);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childRemoved: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childReplaced(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(22);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REPLACED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childReplaced: oldChild = " + PsiManagerImpl.logPsi(event.getOldChild()) + ", newChild = " + PsiManagerImpl.logPsi(event.getNewChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childMoved(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(23);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childMoved: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", oldParent = " + PsiManagerImpl.logPsi(event.getOldParent()) + ", newParent = " + PsiManagerImpl.logPsi(event.getNewParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(24);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childrenChanged: parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(25);
        }
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("propertyChanged: element = " + PsiManagerImpl.logPsi(event.getElement()) + ", propertyName = " + event.getPropertyName() + ", oldValue = " + PsiManagerImpl.arrayToString(event.getOldValue()) + ", newValue = " + PsiManagerImpl.arrayToString(event.getNewValue()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void addTreeChangePreprocessor(@NotNull PsiTreeChangePreprocessor preprocessor) {
        if (preprocessor == null) {
            PsiManagerImpl.$$$reportNull$$$0(26);
        }
        this.myTreeChangePreprocessors.add(preprocessor);
    }

    public void removeTreeChangePreprocessor(@NotNull PsiTreeChangePreprocessor preprocessor) {
        if (preprocessor == null) {
            PsiManagerImpl.$$$reportNull$$$0(27);
        }
        this.myTreeChangePreprocessors.remove(preprocessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiManagerImpl.$$$reportNull$$$0(28);
        }
        boolean isRealTreeChange = event.getCode() != PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED && event.getCode() != PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE;
        PsiFile file2 = event.getFile();
        if (file2 == null || file2.isPhysical()) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (isRealTreeChange) {
            LOG.assertTrue(!this.myTreeChangeEventIsFiring, (Object)"Changes to PSI are not allowed inside event processing");
            this.myTreeChangeEventIsFiring = true;
        }
        try {
            for (PsiTreeChangePreprocessor preprocessor : this.myTreeChangePreprocessors) {
                preprocessor.treeChanged(event);
            }
            for (PsiTreeChangePreprocessor preprocessor : PsiTreeChangePreprocessor.EP.getExtensions((AreaInstance)this.myProject)) {
                try {
                    preprocessor.treeChanged(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            for (PsiTreeChangeListener listener2 : this.myTreeChangeListeners) {
                try {
                    switch (event.getCode()) {
                        case BEFORE_CHILD_ADDITION: {
                            listener2.beforeChildAddition((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILD_REMOVAL: {
                            listener2.beforeChildRemoval((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILD_REPLACEMENT: {
                            listener2.beforeChildReplacement((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILD_MOVEMENT: {
                            listener2.beforeChildMovement((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILDREN_CHANGE: {
                            listener2.beforeChildrenChange((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_PROPERTY_CHANGE: {
                            listener2.beforePropertyChange((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_ADDED: {
                            listener2.childAdded((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_REMOVED: {
                            listener2.childRemoved((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_REPLACED: {
                            listener2.childReplaced((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_MOVED: {
                            listener2.childMoved((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILDREN_CHANGED: {
                            listener2.childrenChanged((PsiTreeChangeEvent)event);
                            break;
                        }
                        case PROPERTY_CHANGED: {
                            listener2.propertyChanged((PsiTreeChangeEvent)event);
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        finally {
            if (isRealTreeChange) {
                this.myTreeChangeEventIsFiring = false;
            }
        }
    }

    @Override
    public void registerRunnableToRunOnChange(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(29);
        }
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    runnable2.run();
                }
            }
        });
    }

    @Override
    public void registerRunnableToRunOnAnyChange(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(30);
        }
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                runnable2.run();
            }
        });
    }

    @Override
    public void registerRunnableToRunAfterAnyChange(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            PsiManagerImpl.$$$reportNull$$$0(31);
        }
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            @Override
            public void afterPsiChanged(boolean isPhysical) {
                runnable2.run();
            }
        });
    }

    @Override
    public void beforeChange(boolean isPhysical) {
        ((AnyPsiChangeListener)this.myMessageBus.syncPublisher(ANY_PSI_CHANGE_TOPIC)).beforePsiChanged(isPhysical);
    }

    @Override
    public void afterChange(boolean isPhysical) {
        ((AnyPsiChangeListener)this.myMessageBus.syncPublisher(ANY_PSI_CHANGE_TOPIC)).afterPsiChanged(isPhysical);
    }

    @NotNull
    public PsiModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = this.myModificationTracker;
        if (psiModificationTracker == null) {
            PsiManagerImpl.$$$reportNull$$$0(32);
        }
        return psiModificationTracker;
    }

    public void startBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.incrementAndGet();
    }

    public void finishBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.decrementAndGet();
        LOG.assertTrue(this.myBatchFilesProcessingModeCount.get() >= 0);
    }

    @Override
    public boolean isBatchFilesProcessingMode() {
        return this.myBatchFilesProcessingModeCount.get() > 0;
    }

    public void cleanupForNextTest() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileManager.cleanupForNextTest();
        this.dropPsiCaches();
    }

    public void dropResolveCacheRegularly(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PsiManagerImpl.$$$reportNull$$$0(33);
        }
        if ((indicator = ProgressWrapper.unwrap(indicator)) instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate(new AbstractProgressIndicatorExBase(){
                private final AtomicLong lastClearedTimeStamp = new AtomicLong();

                @Override
                public void setFraction(double fraction) {
                    long last;
                    long current = System.currentTimeMillis();
                    if (current - (last = this.lastClearedTimeStamp.get()) >= 500L && this.lastClearedTimeStamp.compareAndSet(last, current)) {
                        PsiManagerImpl.this.dropResolveCaches();
                    }
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiManagerImpl";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preprocessor";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setAssertOnFileLoadingFilter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAssertOnFileLoading";
                break;
            }
            case 4: 
            case 5: 
            case 32: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findViewProvider";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPsiTreeChangeListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removePsiTreeChangeListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildAddition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildRemoval";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildReplacement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildrenChange";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildMovement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "beforePropertyChange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "childAdded";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "childRemoved";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "childReplaced";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "childMoved";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "childrenChanged";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addTreeChangePreprocessor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeTreeChangePreprocessor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerRunnableToRunOnChange";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "registerRunnableToRunOnAnyChange";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "registerRunnableToRunAfterAnyChange";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "dropResolveCacheRegularly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

