/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionToolWrapperWithHint;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import org.jdesktop.swingx.renderer.DefaultTreeRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionsConfigTreeRenderer
extends DefaultTreeRenderer {
    protected abstract String getFilter();

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SimpleColoredComponent component = new SimpleColoredComponent();
        if (!(value instanceof InspectionConfigTreeNode)) {
            return component;
        }
        InspectionConfigTreeNode node = (InspectionConfigTreeNode)value;
        boolean reallyHasFocus = ((TreeTableTree)tree).getTreeTable().hasFocus();
        Color background = UIUtil.getTreeBackground((boolean)selected2, (boolean)reallyHasFocus);
        UIUtil.changeBackGround((Component)component, (Color)background);
        Color foreground = selected2 ? UIUtil.getTreeSelectionForeground((boolean)reallyHasFocus) : (node.isProperSetting() ? PlatformColors.BLUE : UIUtil.getTreeForeground());
        int style = 0;
        String hint = null;
        if (node instanceof InspectionConfigTreeNode.Group) {
            style = 1;
        } else {
            InspectionConfigTreeNode.Tool toolNode = (InspectionConfigTreeNode.Tool)node;
            hint = InspectionsConfigTreeRenderer.getHint(toolNode.getDefaultDescriptor());
        }
        SearchUtil.appendFragments(this.getFilter(), node.getText(), style, foreground, background, component);
        if (hint != null) {
            component.append(" " + hint, selected2 ? new SimpleTextAttributes(0, foreground) : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        component.setForeground(foreground);
        return component;
    }

    @Nullable
    private static String getHint(Descriptor descriptor2) {
        InspectionToolWrapper toolWrapper = descriptor2.getToolWrapper();
        if (toolWrapper.getTool() instanceof InspectionToolWrapperWithHint) {
            return ((InspectionToolWrapperWithHint)toolWrapper.getTool()).getHint();
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper || toolWrapper instanceof GlobalInspectionToolWrapper && !((GlobalInspectionToolWrapper)toolWrapper).worksInBatchModeOnly()) {
            return null;
        }
        return InspectionsBundle.message((String)"inspection.tool.availability.in.tree.node1", (Object[])new Object[0]);
    }
}

