/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.LocalFileSystemRefreshWorker;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.VfsEventGenerationHelper;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshWorker {
    private final boolean myIsRecursive;
    private final Queue<NewVirtualFile> myRefreshQueue;
    private final VfsEventGenerationHelper myHelper;
    private volatile boolean myCancelled;
    private final LocalFileSystemRefreshWorker myLocalFileSystemRefreshWorker;
    private static Consumer<? super VirtualFile> ourTestListener;

    public RefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        if (refreshRoot == null) {
            RefreshWorker.$$$reportNull$$$0(0);
        }
        this.myRefreshQueue = new Queue(100);
        this.myHelper = new VfsEventGenerationHelper();
        boolean canUseNioRefresher = refreshRoot.isInLocalFileSystem() && !(refreshRoot.getFileSystem() instanceof TempFileSystem) && Registry.is((String)"vfs.use.nio-based.local.refresh.worker");
        this.myLocalFileSystemRefreshWorker = canUseNioRefresher ? new LocalFileSystemRefreshWorker(refreshRoot, isRecursive) : null;
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast((Object)refreshRoot);
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            List<VFileEvent> list2 = this.myLocalFileSystemRefreshWorker.getEvents();
            if (list2 == null) {
                RefreshWorker.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<VFileEvent> list3 = this.myHelper.getEvents();
        if (list3 == null) {
            RefreshWorker.$$$reportNull$$$0(2);
        }
        return list3;
    }

    public void cancel() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.cancel();
        }
        this.myCancelled = true;
    }

    public void scan() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.scan();
            return;
        }
        NewVirtualFile root = (NewVirtualFile)this.myRefreshQueue.pullFirst();
        NewVirtualFileSystem fs = root.getFileSystem();
        if (root.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        PersistentFS persistence = PersistentFS.getInstance();
        FileAttributes attributes = fs.getAttributes((VirtualFile)root);
        if (attributes == null) {
            this.myHelper.scheduleDeletion((VirtualFile)root);
            root.markClean();
            return;
        }
        this.checkAndScheduleChildRefresh(fs, persistence, root.getParent(), root, attributes);
        if (root.isDirty()) {
            if (this.myRefreshQueue.isEmpty()) {
                this.queueDirectory(root);
            }
            try {
                this.processQueue(fs, persistence);
            }
            catch (RefreshCancelledException e) {
                VfsEventGenerationHelper.LOG.trace("refresh cancelled");
            }
        }
    }

    private void queueDirectory(NewVirtualFile root) {
        if (root instanceof VirtualDirectoryImpl) {
            this.myRefreshQueue.addLast((Object)root);
        } else {
            VfsEventGenerationHelper.LOG.error("not a directory: " + root + " (" + root.getClass());
        }
    }

    private void processQueue(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence) throws RefreshCancelledException {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(3);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(4);
        }
        TObjectHashingStrategy strategy = FilePathHashingStrategy.create((boolean)fs.isCaseSensitive());
        block2: while (!this.myRefreshQueue.isEmpty()) {
            boolean succeeded;
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)((Object)this.myRefreshQueue.pullFirst());
            boolean fullSync = dir.allChildrenLoaded();
            do {
                this.myHelper.beginTransaction();
                try {
                    succeeded = fullSync ? this.fullDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, dir) : this.partialDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, dir);
                }
                catch (InvalidVirtualFileAccessException e) {
                    this.myHelper.endTransaction(false);
                    continue block2;
                }
                this.myHelper.endTransaction(succeeded);
                if (succeeded || !VfsEventGenerationHelper.LOG.isTraceEnabled()) continue;
                VfsEventGenerationHelper.LOG.trace("retry: " + (Object)((Object)dir));
            } while (!succeeded);
            if (!this.myIsRecursive) continue;
            dir.markClean();
        }
    }

    private boolean fullDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy, @NotNull VirtualDirectoryImpl dir) {
        OpenTHashSet actualNames;
        Pair<String[], VirtualFile[]> snapshot;
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(5);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(6);
        }
        if (strategy == null) {
            RefreshWorker.$$$reportNull$$$0(7);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(8);
        }
        if ((snapshot = LocalFileSystemRefreshWorker.getDirectorySnapshot(persistence, dir)) == null) {
            return false;
        }
        Object[] persistedNames = (String[])snapshot.getFirst();
        VirtualFile[] children2 = (VirtualFile[])snapshot.getSecond();
        Object[] upToDateNames = VfsUtil.filterNames((String[])fs.list((VirtualFile)dir));
        THashSet newNames = ContainerUtil.newTroveSet(strategy, (Object[])upToDateNames);
        if (dir.allChildrenLoaded() && children2.length < upToDateNames.length) {
            for (VirtualFile child2 : children2) {
                newNames.remove(child2.getName());
            }
        } else {
            ContainerUtil.removeAll((Collection)newNames, (Object[])persistedNames);
        }
        THashSet deletedNames = ContainerUtil.newTroveSet(strategy, (Object[])persistedNames);
        ContainerUtil.removeAll((Collection)deletedNames, (Object[])upToDateNames);
        OpenTHashSet openTHashSet = actualNames = fs.isCaseSensitive() ? null : new OpenTHashSet(strategy, upToDateNames);
        if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
            VfsEventGenerationHelper.LOG.trace("current=" + Arrays.toString(persistedNames) + " +" + newNames + " -" + deletedNames);
        }
        ArrayList<ChildInfo> newKids = new ArrayList<ChildInfo>(newNames.size());
        for (String newName : newNames) {
            this.checkCancelled(dir);
            ChildInfo record = RefreshWorker.childRecord(fs, (VirtualFile)dir, newName);
            if (record != null) {
                newKids.add(record);
                continue;
            }
            if (!VfsEventGenerationHelper.LOG.isTraceEnabled()) continue;
            VfsEventGenerationHelper.LOG.trace("[+] fs=" + fs + " dir=" + (Object)((Object)dir) + " name=" + newName);
        }
        ArrayList<Pair> updatedMap = new ArrayList<Pair>(children2.length);
        for (VirtualFile child3 : children2) {
            this.checkCancelled(dir);
            if (deletedNames.contains(child3.getName())) continue;
            updatedMap.add(Pair.pair((Object)child3, (Object)fs.getAttributes(child3)));
        }
        if (this.isDirectoryChanged(persistence, dir, (String[])persistedNames, children2)) {
            return false;
        }
        for (String name : deletedNames) {
            VirtualFileSystemEntry child4 = dir.findChild(name);
            if (child4 == null) continue;
            this.myHelper.scheduleDeletion((VirtualFile)child4);
        }
        for (ChildInfo record : newKids) {
            this.myHelper.scheduleCreation((VirtualFile)dir, record.getName().toString(), record.getFileAttributes(), record.getSymLinkTarget(), (ThrowableRunnable<RefreshCancelledException>)((ThrowableRunnable)() -> this.checkCancelled(dir)));
        }
        for (Pair pair : updatedMap) {
            NewVirtualFile child5 = (NewVirtualFile)pair.first;
            this.checkCancelled(child5);
            FileAttributes childAttributes = (FileAttributes)pair.second;
            if (childAttributes != null) {
                this.checkAndScheduleChildRefresh(fs, persistence, dir, child5, childAttributes);
                this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, (VirtualFile)child5);
                continue;
            }
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.warn("[x] fs=" + fs + " dir=" + (Object)((Object)dir) + " name=" + child5.getName());
            }
            this.myHelper.scheduleDeletion((VirtualFile)child5);
        }
        return !this.isDirectoryChanged(persistence, dir, (String[])persistedNames, children2);
    }

    private boolean isDirectoryChanged(@NotNull PersistentFS persistence, @NotNull VirtualDirectoryImpl dir, @NotNull String[] persistedNames, @NotNull VirtualFile[] children2) {
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(9);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(10);
        }
        if (persistedNames == null) {
            RefreshWorker.$$$reportNull$$$0(11);
        }
        if (children2 == null) {
            RefreshWorker.$$$reportNull$$$0(12);
        }
        return (Boolean)ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return !Arrays.equals(persistedNames, persistence.list((VirtualFile)dir)) || !Arrays.equals(children2, dir.getChildren());
        });
    }

    private boolean partialDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy, @NotNull VirtualDirectoryImpl dir) {
        OpenTHashSet actualNames;
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(13);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(14);
        }
        if (strategy == null) {
            RefreshWorker.$$$reportNull$$$0(15);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(16);
        }
        Pair snapshot = (Pair)ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return Pair.pair((Object)dir.getCachedChildren(), dir.getSuspiciousNames());
        });
        List cached = (List)snapshot.getFirst();
        List wanted = (List)snapshot.getSecond();
        OpenTHashSet openTHashSet = actualNames = fs.isCaseSensitive() || cached.isEmpty() ? null : new OpenTHashSet(strategy, (Object[])VfsUtil.filterNames((String[])fs.list((VirtualFile)dir)));
        if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
            VfsEventGenerationHelper.LOG.trace("cached=" + cached + " actual=" + actualNames + " suspicious=" + wanted);
        }
        ArrayList<Pair> existingMap = new ArrayList<Pair>(cached.size());
        for (VirtualFile child2 : cached) {
            this.checkCancelled(dir);
            existingMap.add(Pair.pair((Object)child2, (Object)fs.getAttributes(child2)));
        }
        ArrayList<ChildInfo> newKids = new ArrayList<ChildInfo>(wanted.size());
        for (String name : wanted) {
            if (name.isEmpty()) continue;
            this.checkCancelled(dir);
            ChildInfo record = RefreshWorker.childRecord(fs, (VirtualFile)dir, name);
            if (record == null) continue;
            newKids.add(record);
        }
        if (this.isDirectoryChanged(dir, cached, wanted)) {
            return false;
        }
        for (Pair pair : existingMap) {
            NewVirtualFile child3 = (NewVirtualFile)pair.first;
            this.checkCancelled(child3);
            FileAttributes childAttributes = (FileAttributes)pair.second;
            if (childAttributes != null) {
                this.checkAndScheduleChildRefresh(fs, persistence, dir, child3, childAttributes);
                this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, (VirtualFile)child3);
                continue;
            }
            this.myHelper.scheduleDeletion((VirtualFile)child3);
        }
        for (ChildInfo record : newKids) {
            this.myHelper.scheduleCreation((VirtualFile)dir, record.getName().toString(), record.getFileAttributes(), record.getSymLinkTarget(), (ThrowableRunnable<RefreshCancelledException>)((ThrowableRunnable)() -> this.checkCancelled(dir)));
        }
        return !this.isDirectoryChanged(dir, cached, wanted);
    }

    private boolean isDirectoryChanged(@NotNull VirtualDirectoryImpl dir, @NotNull List<VirtualFile> cached, @NotNull List<String> wanted) {
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(17);
        }
        if (cached == null) {
            RefreshWorker.$$$reportNull$$$0(18);
        }
        if (wanted == null) {
            RefreshWorker.$$$reportNull$$$0(19);
        }
        return (Boolean)ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return !cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames());
        });
    }

    @Nullable
    private static ChildInfo childRecord(@NotNull NewVirtualFileSystem fs, @NotNull VirtualFile dir, @NotNull String name) {
        FakeVirtualFile file2;
        FileAttributes attributes;
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(20);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(21);
        }
        if (name == null) {
            RefreshWorker.$$$reportNull$$$0(22);
        }
        if ((attributes = fs.getAttributes((VirtualFile)(file2 = new FakeVirtualFile(dir, name)))) == null) {
            return null;
        }
        boolean isEmptyDir = attributes.isDirectory() && !fs.hasChildren((VirtualFile)file2);
        String symlinkTarget = attributes.isSymLink() ? fs.resolveSymLink((VirtualFile)file2) : null;
        return new ChildInfoImpl(-1, name, attributes, (ChildInfo[])(isEmptyDir ? ChildInfo.EMPTY_ARRAY : null), symlinkTarget);
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) throws RefreshCancelledException {
        if (stopAt == null) {
            RefreshWorker.$$$reportNull$$$0(23);
        }
        if (ourTestListener != null) {
            ourTestListener.accept((VirtualFile)stopAt);
        }
        if (this.myCancelled) {
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.trace("cancelled at: " + stopAt);
            }
            RefreshWorker.forceMarkDirty(stopAt);
            while (!this.myRefreshQueue.isEmpty()) {
                RefreshWorker.forceMarkDirty((NewVirtualFile)this.myRefreshQueue.pullFirst());
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(@NotNull NewVirtualFile file2) {
        if (file2 == null) {
            RefreshWorker.$$$reportNull$$$0(24);
        }
        file2.markClean();
        file2.markDirty();
    }

    private void checkAndScheduleChildRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @Nullable NewVirtualFile parent, @NotNull NewVirtualFile child2, @NotNull FileAttributes childAttributes) {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(25);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(26);
        }
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(27);
        }
        if (childAttributes == null) {
            RefreshWorker.$$$reportNull$$$0(28);
        }
        if (!VfsEventGenerationHelper.checkDirty(child2)) {
            return;
        }
        if (this.checkAndScheduleFileTypeChange(fs, parent, child2, childAttributes)) {
            child2.markClean();
            return;
        }
        this.myHelper.checkWritableAttributeChange((VirtualFile)child2, persistence.isWritable((VirtualFile)child2), childAttributes.isWritable());
        if (SystemInfo.isWindows) {
            this.myHelper.checkHiddenAttributeChange((VirtualFile)child2, child2.is(VFileProperty.HIDDEN), childAttributes.isHidden());
        }
        if (childAttributes.isSymLink()) {
            this.myHelper.checkSymbolicLinkChange((VirtualFile)child2, child2.getCanonicalPath(), fs.resolveSymLink((VirtualFile)child2));
        }
        if (!childAttributes.isDirectory()) {
            long oltTS = persistence.getTimeStamp((VirtualFile)child2);
            long newTS = childAttributes.lastModified;
            long oldLength = persistence.getLastRecordedLength((VirtualFile)child2);
            long newLength = childAttributes.length;
            this.myHelper.checkContentChanged((VirtualFile)child2, oltTS, newTS, oldLength, newLength);
            child2.markClean();
        } else if (this.myIsRecursive) {
            this.queueDirectory(child2);
        }
    }

    private boolean checkAndScheduleFileTypeChange(@NotNull NewVirtualFileSystem fs, @Nullable NewVirtualFile parent, @NotNull NewVirtualFile child2, @NotNull FileAttributes childAttributes) {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(29);
        }
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(30);
        }
        if (childAttributes == null) {
            RefreshWorker.$$$reportNull$$$0(31);
        }
        boolean currentIsDirectory = child2.isDirectory();
        boolean currentIsSymlink = child2.is(VFileProperty.SYMLINK);
        boolean currentIsSpecial = child2.is(VFileProperty.SPECIAL);
        boolean upToDateIsDirectory = childAttributes.isDirectory();
        boolean upToDateIsSymlink = childAttributes.isSymLink();
        boolean upToDateIsSpecial = childAttributes.isSpecial();
        if (currentIsDirectory != upToDateIsDirectory || currentIsSymlink != upToDateIsSymlink || currentIsSpecial != upToDateIsSpecial) {
            this.myHelper.scheduleDeletion((VirtualFile)child2);
            if (parent != null) {
                String symlinkTarget = upToDateIsSymlink ? fs.resolveSymLink((VirtualFile)child2) : null;
                this.myHelper.scheduleCreation((VirtualFile)parent, child2.getName(), childAttributes, symlinkTarget, (ThrowableRunnable<RefreshCancelledException>)((ThrowableRunnable)() -> this.checkCancelled(parent)));
            } else {
                VfsEventGenerationHelper.LOG.error("transgender orphan: " + child2 + ' ' + childAttributes);
            }
            return true;
        }
        return false;
    }

    private void checkAndScheduleFileNameChange(@Nullable OpenTHashSet<String> actualNames, @NotNull VirtualFile child2) {
        String currentName;
        String actualName;
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(32);
        }
        if (actualNames != null && (actualName = (String)actualNames.get((Object)(currentName = child2.getName()))) != null && !currentName.equals(actualName)) {
            this.myHelper.scheduleAttributeChange(child2, "name", currentName, actualName);
        }
    }

    public static void setTestListener(@Nullable Consumer<? super VirtualFile> testListener) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourTestListener = testListener;
        LocalFileSystemRefreshWorker.setTestListener(testListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshRoot";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker";
                break;
            }
            case 3: 
            case 5: 
            case 13: 
            case 20: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistedNames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cached";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wanted";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processQueue";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fullDirRefresh";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryChanged";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "partialDirRefresh";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "childRecord";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkCancelled";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "forceMarkDirty";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleChildRefresh";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleFileTypeChange";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleFileNameChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RefreshCancelledException
    extends RuntimeException {
        RefreshCancelledException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

