/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.BitUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistentFS
extends ManagingFS {
    static final int CHILDREN_CACHED_FLAG = 1;
    static final int IS_DIRECTORY_FLAG = 2;
    static final int IS_READ_ONLY = 4;
    static final int MUST_RELOAD_CONTENT = 8;
    static final int IS_SYMLINK = 16;
    static final int IS_SPECIAL = 32;
    static final int IS_HIDDEN = 64;
    static final int ALL_VALID_FLAGS = 127;

    public static PersistentFS getInstance() {
        return (PersistentFS)ManagingFS.getInstance();
    }

    public abstract void clearIdCache();

    @NotNull
    public abstract String[] listPersisted(@NotNull VirtualFile var1);

    @NotNull
    public abstract FSRecords.NameId[] listAll(@NotNull VirtualFile var1);

    public abstract int getId(@NotNull VirtualFile var1, @NotNull String var2, @NotNull NewVirtualFileSystem var3);

    public abstract String getName(int var1);

    public abstract long getLastRecordedLength(@NotNull VirtualFile var1);

    public abstract boolean isHidden(@NotNull VirtualFile var1);

    @Attributes
    public abstract int getFileAttributes(int var1);

    public static boolean isDirectory(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)2);
    }

    public static boolean isWritable(@Attributes int attributes) {
        return !BitUtil.isSet((int)attributes, (int)4);
    }

    public static boolean isSymLink(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)16);
    }

    public static boolean isSpecialFile(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)32);
    }

    public static boolean isHidden(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)64);
    }

    @Nullable
    public abstract NewVirtualFile findFileByIdIfCached(int var1);

    public abstract int storeUnlinkedContent(@NotNull byte[] var1);

    @NotNull
    public abstract byte[] contentsToByteArray(int var1) throws IOException;

    @NotNull
    public abstract byte[] contentsToByteArray(@NotNull VirtualFile var1, boolean var2) throws IOException;

    public abstract int acquireContent(@NotNull VirtualFile var1);

    public abstract void releaseContent(int var1);

    public abstract int getCurrentContentId(@NotNull VirtualFile var1);

    public abstract void processEvents(@NotNull List<? extends VFileEvent> var1);

    @NotNull
    public static NewVirtualFileSystem replaceWithNativeFS(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            PersistentFS.$$$reportNull$$$0(0);
        }
        if (SystemInfo.isWindows && !(fs instanceof Win32LocalFileSystem) && fs.getProtocol().equals("file") && Win32LocalFileSystem.isAvailable()) {
            Win32LocalFileSystem win32LocalFileSystem = Win32LocalFileSystem.getWin32Instance();
            if (win32LocalFileSystem == null) {
                PersistentFS.$$$reportNull$$$0(1);
            }
            return win32LocalFileSystem;
        }
        NewVirtualFileSystem newVirtualFileSystem = fs;
        if (newVirtualFileSystem == null) {
            PersistentFS.$$$reportNull$$$0(2);
        }
        return newVirtualFileSystem;
    }

    public abstract boolean mayHaveChildren(int var1);

    @NotNull
    public static FileAttributes toFileAttributes(int attributes) {
        boolean isDirectory = BitUtil.isSet((int)attributes, (int)2);
        boolean isSpecial = BitUtil.isSet((int)attributes, (int)32);
        boolean isSymlink = BitUtil.isSet((int)attributes, (int)16);
        boolean isHidden = BitUtil.isSet((int)attributes, (int)64);
        boolean isWritable = !BitUtil.isSet((int)attributes, (int)4);
        FileAttributes fileAttributes = new FileAttributes(isDirectory, isSpecial, isSymlink, isHidden, -1L, -1L, isWritable);
        if (fileAttributes == null) {
            PersistentFS.$$$reportNull$$$0(3);
        }
        return fileAttributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFS";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFS";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithNativeFS";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithNativeFS";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface Attributes {
    }
}

