/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.FilePointerPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualFilePointerImpl
extends TraceableDisposable
implements VirtualFilePointer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFilePointerImpl");
    private final VirtualFilePointerListener myListener;
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    volatile FilePointerPartNode myNode;
    boolean recursive;

    VirtualFilePointerImpl(@Nullable VirtualFilePointerListener listener2) {
        super(TRACE_CREATION);
        this.myListener = listener2;
    }

    @NotNull
    public String getFileName() {
        FilePointerPartNode node = this.myNode;
        if (!this.checkDisposed(node)) {
            if ("" == null) {
                VirtualFilePointerImpl.$$$reportNull$$$0(0);
            }
            return "";
        }
        Pair<VirtualFile, String> result2 = this.update(node);
        if (result2 == null) {
            if ("" == null) {
                VirtualFilePointerImpl.$$$reportNull$$$0(1);
            }
            return "";
        }
        VirtualFile file2 = (VirtualFile)result2.first;
        if (file2 != null) {
            String string = file2.getName();
            if (string == null) {
                VirtualFilePointerImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String url = (String)result2.second;
        int index = url.lastIndexOf(47);
        String string = index >= 0 ? url.substring(index + 1) : url;
        if (string == null) {
            VirtualFilePointerImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    private Pair<VirtualFile, String> update(FilePointerPartNode node) {
        do {
            Pair<VirtualFile, String> result2;
            if ((result2 = node.update()) == null) continue;
            return result2;
        } while ((node = this.myNode) != null);
        return null;
    }

    public VirtualFile getFile() {
        FilePointerPartNode node = this.myNode;
        if (!this.checkDisposed(node)) {
            return null;
        }
        Pair<VirtualFile, String> result2 = this.update(node);
        return result2 == null ? null : (VirtualFile)result2.first;
    }

    @NotNull
    public String getUrl() {
        FilePointerPartNode node = this.myNode;
        if (VirtualFilePointerImpl.isDisposed(node)) {
            if ("" == null) {
                VirtualFilePointerImpl.$$$reportNull$$$0(4);
            }
            return "";
        }
        Pair<VirtualFile, String> fileAndUrl = node.myFileAndUrl;
        if (fileAndUrl != null && fileAndUrl.getFirst() == null) {
            String string = (String)fileAndUrl.getSecond();
            if (string == null) {
                VirtualFilePointerImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        Pair<VirtualFile, String> result2 = this.update(node);
        String string = result2 == null ? "" : (String)result2.second;
        if (string == null) {
            VirtualFilePointerImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        FilePointerPartNode node = this.myNode;
        if (!this.checkDisposed(node)) {
            if ("" == null) {
                VirtualFilePointerImpl.$$$reportNull$$$0(7);
            }
            return "";
        }
        Pair<VirtualFile, String> result2 = this.update(node);
        String string = result2 == null ? "" : PathUtil.toPresentableUrl((String)((String)result2.second));
        if (string == null) {
            VirtualFilePointerImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    private boolean checkDisposed(FilePointerPartNode node) {
        if (VirtualFilePointerImpl.isDisposed(node)) {
            ProgressManager.checkCanceled();
            LOG.error("Already disposed: URL='" + (Object)((Object)this) + "'");
            return false;
        }
        return true;
    }

    public boolean isValid() {
        FilePointerPartNode node = this.myNode;
        Pair<VirtualFile, String> result2 = VirtualFilePointerImpl.isDisposed(node) ? null : this.update(node);
        return result2 != null && result2.first != null;
    }

    public String toString() {
        Pair<VirtualFile, String> fileAndUrl;
        FilePointerPartNode node = this.myNode;
        return node == null ? "(disposed)" : ((fileAndUrl = node.myFileAndUrl) == null ? "?" : (String)fileAndUrl.second);
    }

    public void dispose() {
        FilePointerPartNode node = this.myNode;
        this.checkDisposed(node);
        if (node.incrementUsageCount(-1) == 0) {
            this.kill("URL when die: " + (Object)((Object)this));
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            if (pointerManager instanceof VirtualFilePointerManagerImpl) {
                ((VirtualFilePointerManagerImpl)pointerManager).removeNodeFrom(this);
            }
        }
    }

    public boolean isDisposed() {
        return VirtualFilePointerImpl.isDisposed(this.myNode);
    }

    private static boolean isDisposed(FilePointerPartNode node) {
        return node == null;
    }

    VirtualFilePointerListener getListener() {
        return this.myListener;
    }

    int incrementUsageCount(int delta) {
        return this.myNode.incrementUsageCount(delta);
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

