/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformVirtualFileManager
extends VirtualFileManagerImpl {
    @NotNull
    private final ManagingFS myManagingFS = ManagingFS.getInstance();

    public PlatformVirtualFileManager() {
        super(PlatformVirtualFileManager.getVirtualFileSystems());
    }

    @NotNull
    private static List<VirtualFileSystem> getVirtualFileSystems() {
        List<VirtualFileSystem> result2;
        Application app = ApplicationManager.getApplication();
        List<VirtualFileSystem> list2 = result2 = app instanceof ComponentManagerImpl ? ((ComponentManagerImpl)app).getComponentInstancesOfType(VirtualFileSystem.class, true) : Collections.emptyList();
        if (!result2.isEmpty()) {
            LOG.warn("Do not register file system as application component, instead, register as extension, for example:\n<virtualFileSystem implementationClass=\"com.example.MyFileSystem\" key=\"myProtocol\" physical=\"true\"/>\n\n" + result2);
        }
        List<VirtualFileSystem> list3 = result2;
        if (list3 == null) {
            PlatformVirtualFileManager.$$$reportNull$$$0(0);
        }
        return list3;
    }

    @Override
    protected long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        RefreshSession session2 = RefreshQueue.getInstance().createSession(asynchronous, true, postAction);
        session2.addAllFiles(this.myManagingFS.getRoots());
        session2.launch();
        super.doRefresh(asynchronous, postAction);
        return session2.getId();
    }

    @Override
    public long getModificationCount() {
        return this.myManagingFS.getModificationCount();
    }

    @Override
    public long getStructureModificationCount() {
        return this.myManagingFS.getStructureModificationCount();
    }

    public VirtualFile findFileById(int id) {
        return this.myManagingFS.findFileById(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/PlatformVirtualFileManager", "getVirtualFileSystems"));
    }
}

