/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ThrowableRunnable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NotImplementedError;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleRootManagerImpl
extends ModuleRootManagerEx
implements Disposable {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.ModuleRootManagerImpl");
    private final Module myModule;
    private final ProjectRootManagerImpl myProjectRootManager;
    private final VirtualFilePointerManager myFilePointerManager;
    protected RootModelImpl myRootModel;
    private boolean myIsDisposed;
    private boolean myLoaded;
    private final OrderRootsCache myOrderRootsCache;
    private final Map<RootModelImpl, Throwable> myModelCreations;
    protected final SimpleModificationTracker myModificationTracker;

    public ModuleRootManagerImpl(@NotNull Module module, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        if (module == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(0);
        }
        if (projectRootManager == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(1);
        }
        if (filePointerManager == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(2);
        }
        this.myModelCreations = new THashMap();
        this.myModificationTracker = new SimpleModificationTracker();
        this.myModule = module;
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myRootModel = new RootModelImpl(this, projectRootManager, filePointerManager);
        this.myOrderRootsCache = new OrderRootsCache((Disposable)module);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(3);
        }
        return module;
    }

    @NotNull
    public ModuleFileIndex getFileIndex() {
        ModuleFileIndex moduleFileIndex = (ModuleFileIndex)ModuleServiceManager.getService((Module)this.myModule, ModuleFileIndex.class);
        if (moduleFileIndex == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(4);
        }
        return moduleFileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myRootModel.dispose();
        this.myIsDisposed = true;
        if (Disposer.isDebugMode()) {
            ArrayList<Map.Entry<RootModelImpl, Throwable>> entries;
            Map<RootModelImpl, Throwable> map2 = this.myModelCreations;
            synchronized (map2) {
                entries = new ArrayList<Map.Entry<RootModelImpl, Throwable>>(this.myModelCreations.entrySet());
            }
            for (Map.Entry entry : entries) {
                LOG.warn("\n***********************************************************************************************\n***                        R O O T   M O D E L   N O T   D I S P O S E D                    ***\n***********************************************************************************************\nCreated at:", (Throwable)entry.getValue());
                ((RootModelImpl)entry.getKey()).dispose();
            }
        }
    }

    @NotNull
    public ModifiableRootModel getModifiableModel() {
        ModifiableRootModel modifiableRootModel = this.getModifiableModel(new RootConfigurationAccessor());
        if (modifiableRootModel == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(5);
        }
        return modifiableRootModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModifiableRootModel getModifiableModel(@NotNull RootConfigurationAccessor accessor) {
        if (accessor == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootModelImpl model2 = new RootModelImpl(this.myRootModel, this, true, accessor, this.myFilePointerManager, this.myProjectRootManager){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                super.dispose();
                if (Disposer.isDebugMode()) {
                    Map map2 = ModuleRootManagerImpl.this.myModelCreations;
                    synchronized (map2) {
                        ModuleRootManagerImpl.this.myModelCreations.remove(this);
                    }
                }
            }
        };
        if (Disposer.isDebugMode()) {
            Map<RootModelImpl, Throwable> map2 = this.myModelCreations;
            synchronized (map2) {
                this.myModelCreations.put(model2, new Throwable());
            }
        }
        RootModelImpl rootModelImpl = model2;
        if (rootModelImpl == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(7);
        }
        return rootModelImpl;
    }

    @Override
    public long getModificationCountForTests() {
        throw new NotImplementedError("Make sense only for persistent root manager");
    }

    void makeRootsChange(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(8);
        }
        ProjectRootManagerEx projectRootManagerEx = (ProjectRootManagerEx)ProjectRootManager.getInstance((Project)this.myModule.getProject());
        projectRootManagerEx.makeRootsChange(runnable2, false, this.myModule.isLoaded());
    }

    public RootModelImpl getRootModel() {
        return this.myRootModel;
    }

    @NotNull
    public ContentEntry[] getContentEntries() {
        ContentEntry[] contentEntryArray = this.myRootModel.getContentEntries();
        if (contentEntryArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(9);
        }
        return contentEntryArray;
    }

    @NotNull
    public OrderEntry[] getOrderEntries() {
        OrderEntry[] orderEntryArray = this.myRootModel.getOrderEntries();
        if (orderEntryArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(10);
        }
        return orderEntryArray;
    }

    public Sdk getSdk() {
        return this.myRootModel.getSdk();
    }

    public boolean isSdkInherited() {
        return this.myRootModel.isSdkInherited();
    }

    void commitModel(RootModelImpl rootModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(rootModel.myModuleRootManager == this);
        LOG.assertTrue(!this.myIsDisposed);
        boolean changed = rootModel.isChanged();
        Project project = this.myModule.getProject();
        ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project).getModifiableModel();
        ModifiableModelCommitter.multiCommit(Collections.singletonList(rootModel), moduleModel);
        if (changed) {
            this.stateChanged();
        }
    }

    static void doCommit(RootModelImpl rootModel) {
        ModuleRootManagerImpl rootManager = (ModuleRootManagerImpl)ModuleRootManagerImpl.getInstance((Module)rootModel.getModule());
        LOG.assertTrue(!rootManager.myIsDisposed);
        rootModel.docommit();
        rootModel.dispose();
        try {
            rootManager.stateChanged();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public Module[] getDependencies() {
        Module[] moduleArray = this.myRootModel.getModuleDependencies();
        if (moduleArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(11);
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getDependencies(boolean includeTests) {
        Module[] moduleArray = this.myRootModel.getModuleDependencies(includeTests);
        if (moduleArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(12);
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getModuleDependencies() {
        Module[] moduleArray = this.myRootModel.getModuleDependencies();
        if (moduleArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(13);
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getModuleDependencies(boolean includeTests) {
        Module[] moduleArray = this.myRootModel.getModuleDependencies(includeTests);
        if (moduleArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(14);
        }
        return moduleArray;
    }

    public boolean isDependsOn(@NotNull Module module) {
        if (module == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(15);
        }
        return this.myRootModel.findModuleOrderEntry(module) != null;
    }

    @NotNull
    public String[] getDependencyModuleNames() {
        String[] stringArray = this.myRootModel.getDependencyModuleNames();
        if (stringArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    public <T> T getModuleExtension(@NotNull Class<T> klass) {
        if (klass == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(17);
        }
        return this.myRootModel.getModuleExtension(klass);
    }

    public <R> R processOrder(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(18);
        }
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.processOrder(policy, initialValue);
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        ModuleOrderEnumerator moduleOrderEnumerator = new ModuleOrderEnumerator(this.myRootModel, this.myOrderRootsCache);
        if (moduleOrderEnumerator == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(19);
        }
        return moduleOrderEnumerator;
    }

    public static OrderRootsEnumerator getCachingEnumeratorForType(@NotNull OrderRootType type, @NotNull Module module) {
        if (type == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(20);
        }
        if (module == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(21);
        }
        return ModuleRootManagerImpl.getEnumeratorForType(type, module).usingCache();
    }

    @NotNull
    private static OrderRootsEnumerator getEnumeratorForType(@NotNull OrderRootType type, @NotNull Module module) {
        if (type == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(22);
        }
        if (module == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(23);
        }
        OrderEnumerator base = OrderEnumerator.orderEntries((Module)module);
        if (type == OrderRootType.CLASSES) {
            OrderRootsEnumerator orderRootsEnumerator = base.exportedOnly().withoutModuleSourceEntries().recursively().classes();
            if (orderRootsEnumerator == null) {
                ModuleRootManagerImpl.$$$reportNull$$$0(24);
            }
            return orderRootsEnumerator;
        }
        if (type == OrderRootType.SOURCES) {
            OrderRootsEnumerator orderRootsEnumerator = base.exportedOnly().recursively().sources();
            if (orderRootsEnumerator == null) {
                ModuleRootManagerImpl.$$$reportNull$$$0(25);
            }
            return orderRootsEnumerator;
        }
        OrderRootsEnumerator orderRootsEnumerator = base.roots(type);
        if (orderRootsEnumerator == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(26);
        }
        return orderRootsEnumerator;
    }

    @NotNull
    public VirtualFile[] getContentRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getContentRoots();
        if (virtualFileArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(27);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getContentRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getContentRootUrls();
        if (stringArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(28);
        }
        return stringArray;
    }

    @NotNull
    public String[] getExcludeRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getExcludeRootUrls();
        if (stringArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(29);
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getExcludeRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getExcludeRoots();
        if (virtualFileArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(30);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getSourceRootUrls() {
        String[] stringArray = this.getSourceRootUrls(true);
        if (stringArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(31);
        }
        return stringArray;
    }

    @NotNull
    public String[] getSourceRootUrls(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getSourceRootUrls(includingTests);
        if (stringArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(32);
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots() {
        VirtualFile[] virtualFileArray = this.getSourceRoots(true);
        if (virtualFileArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(33);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(34);
        }
        return virtualFileArray;
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(35);
        }
        List<VirtualFile> list2 = this.myRootModel.getSourceRoots(rootType);
        if (list2 == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(36);
        }
        return list2;
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(37);
        }
        List<VirtualFile> list2 = this.myRootModel.getSourceRoots(rootTypes);
        if (list2 == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(38);
        }
        return list2;
    }

    @Override
    public void dropCaches() {
        this.myOrderRootsCache.clearCache();
    }

    public ModuleRootManagerState getState() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("getState, module " + this.myModule.getName());
        }
        return new ModuleRootManagerState(this.myRootModel);
    }

    public void loadState(@NotNull ModuleRootManagerState object) {
        if (object == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(39);
        }
        this.loadState(object, this.myLoaded || this.myModule.isLoaded());
        this.myLoaded = true;
    }

    protected void loadState(ModuleRootManagerState object, boolean throwEvent) {
        ThrowableRunnable r = () -> {
            RootModelImpl newModel = new RootModelImpl(object.getRootModelElement(), this, this.myProjectRootManager, this.myFilePointerManager, throwEvent);
            if (throwEvent) {
                this.makeRootsChange(() -> ModuleRootManagerImpl.doCommit(newModel));
            } else {
                this.myRootModel.dispose();
                this.myRootModel = newModel;
            }
            assert (!this.myRootModel.isOrderEntryDisposed());
        };
        try {
            if (throwEvent) {
                WriteAction.run((ThrowableRunnable)r);
            } else {
                ReadAction.run((ThrowableRunnable)r);
            }
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void stateChanged() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("ModelRootManager state changed");
        }
        this.myModificationTracker.incModificationCount();
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return ExternalProjectSystemRegistry.getInstance().getExternalSource(this.myModule);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointerManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleRootManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleRootManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIndex";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentEntries";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyModuleNames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "orderEntries";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumeratorForType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootUrls";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRootUrls";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRoots";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootUrls";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makeRootsChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDependsOn";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExtension";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processOrder";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCachingEnumeratorForType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getEnumeratorForType";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ModuleRootManagerState
    implements JDOMExternalizable {
        private RootModelImpl myRootModel;
        private Element myRootModelElement;

        public ModuleRootManagerState() {
        }

        public ModuleRootManagerState(RootModelImpl rootModel) {
            this.myRootModel = rootModel;
        }

        public void readExternal(Element element) {
            this.myRootModelElement = element;
        }

        public void writeExternal(Element element) {
            this.myRootModel.writeExternal(element);
        }

        public Element getRootModelElement() {
            return this.myRootModelElement;
        }
    }
}

