/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProjectRootUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootUtil");

    private ProjectRootUtil() {
    }

    @NotNull
    private static PsiDirectory[] convertRoots(@NotNull Project project, @NotNull VirtualFile[] roots) {
        if (project == null) {
            ProjectRootUtil.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            ProjectRootUtil.$$$reportNull$$$0(1);
        }
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(((PsiManagerImpl)PsiManager.getInstance((Project)project)).getFileManager(), roots);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(2);
        }
        return psiDirectoryArray;
    }

    @NotNull
    private static PsiDirectory[] convertRoots(@NotNull FileManager fileManager, @NotNull VirtualFile[] roots) {
        if (fileManager == null) {
            ProjectRootUtil.$$$reportNull$$$0(3);
        }
        if (roots == null) {
            ProjectRootUtil.$$$reportNull$$$0(4);
        }
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile root : roots) {
            PsiDirectory dir;
            if (!root.isValid()) {
                LOG.error("Root " + root + " is not valid!");
            }
            if ((dir = fileManager.findDirectory(root)) == null) continue;
            dirs.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(5);
        }
        return psiDirectoryArray;
    }

    @NotNull
    public static PsiDirectory[] getSourceRootDirectories(@NotNull Project project) {
        if (project == null) {
            ProjectRootUtil.$$$reportNull$$$0(6);
        }
        VirtualFile[] files2 = OrderEnumerator.orderEntries((Project)project).sources().usingCache().getRoots();
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(project, files2);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(7);
        }
        return psiDirectoryArray;
    }

    @NotNull
    public static PsiDirectory[] getAllContentRoots(@NotNull Project project) {
        if (project == null) {
            ProjectRootUtil.$$$reportNull$$$0(8);
        }
        VirtualFile[] files2 = ProjectRootManager.getInstance((Project)project).getContentRootsFromAllModules();
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(project, files2);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(9);
        }
        return psiDirectoryArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/ProjectRootUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectRootUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootDirectories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertRoots";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootDirectories";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllContentRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

