/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class ExcludeRootsCache {
    private volatile CachedUrls myCache;

    ExcludeRootsCache(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            ExcludeRootsCache.$$$reportNull$$$0(0);
        }
        messageBus.connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExcludeRootsCache.this.myCache = null;
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExcludeRootsCache.this.myCache = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/project/impl/ExcludeRootsCache$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    String[] getExcludedUrls() {
        String[] stringArray = (String[])ReadAction.compute(() -> {
            Object[] urls;
            CachedUrls cache = this.myCache;
            long actualModCount = Arrays.stream(ProjectManager.getInstance().getOpenProjects()).map(ProjectRootManager::getInstance).mapToLong(SimpleModificationTracker::getModificationCount).sum();
            if (cache != null && actualModCount == cache.myModificationCount) {
                urls = cache.myUrls;
            } else {
                THashSet excludedUrls = new THashSet();
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        urls = ModuleRootManager.getInstance((Module)module).getExcludeRootUrls();
                        ContainerUtil.addAll((Collection)excludedUrls, (Object[])urls);
                    }
                }
                urls = ArrayUtilRt.toStringArray((Collection)excludedUrls);
                Arrays.sort(urls);
                this.myCache = new CachedUrls(actualModCount, (String[])urls);
            }
            return urls;
        });
        if (stringArray == null) {
            ExcludeRootsCache.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/impl/ExcludeRootsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/impl/ExcludeRootsCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedUrls {
        private final long myModificationCount;
        @NotNull
        private final String[] myUrls;

        /*
         * WARNING - void declaration
         */
        private CachedUrls(long count, @NotNull String[] stringArray) {
            void urls;
            if (stringArray == null) {
                CachedUrls.$$$reportNull$$$0(0);
            }
            this.myModificationCount = count;
            this.myUrls = urls;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/openapi/project/impl/ExcludeRootsCache$CachedUrls", "<init>"));
        }
    }
}

