/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileOffsetsManager {
    private final Map<VirtualFile, LineOffsets> myLineOffsetsMap = new THashMap();

    @NotNull
    public static FileOffsetsManager getInstance() {
        FileOffsetsManager fileOffsetsManager = (FileOffsetsManager)ServiceManager.getService(FileOffsetsManager.class);
        if (fileOffsetsManager == null) {
            FileOffsetsManager.$$$reportNull$$$0(0);
        }
        return fileOffsetsManager;
    }

    public int getConvertedOffset(@NotNull VirtualFile file2, int originalOffset) {
        LineOffsets offsets;
        if (file2 == null) {
            FileOffsetsManager.$$$reportNull$$$0(1);
        }
        if ((offsets = this.getLineOffsets(file2)).myLineOffsetsAreTheSame) {
            return originalOffset;
        }
        return FileOffsetsManager.getCorrespondingOffset(offsets.myOriginalLineOffsets, offsets.myConvertedLineOffsets, originalOffset);
    }

    public int getOriginalOffset(@NotNull VirtualFile file2, int convertedOffset) {
        LineOffsets offsets;
        if (file2 == null) {
            FileOffsetsManager.$$$reportNull$$$0(2);
        }
        if ((offsets = this.getLineOffsets(file2)).myLineOffsetsAreTheSame) {
            return convertedOffset;
        }
        return FileOffsetsManager.getCorrespondingOffset(offsets.myConvertedLineOffsets, offsets.myOriginalLineOffsets, convertedOffset);
    }

    private static int getCorrespondingOffset(int[] offsets1, int[] offsets2, int offset1) {
        int line2 = Arrays.binarySearch(offsets1, offset1);
        if (line2 < 0) {
            line2 = -line2 - 2;
        }
        try {
            return offsets2[line2] + offset1 - offsets1[line2];
        }
        catch (Exception e) {
            return offset1;
        }
    }

    @NotNull
    private synchronized LineOffsets getLineOffsets(@NotNull VirtualFile file2) {
        LineOffsets offsets;
        if (file2 == null) {
            FileOffsetsManager.$$$reportNull$$$0(3);
        }
        if ((offsets = this.myLineOffsetsMap.get(file2)) != null && file2.getModificationStamp() == offsets.myFileModificationStamp) {
            LineOffsets lineOffsets = offsets;
            if (lineOffsets == null) {
                FileOffsetsManager.$$$reportNull$$$0(4);
            }
            return lineOffsets;
        }
        offsets = FileOffsetsManager.loadLineOffsets(file2);
        this.myLineOffsetsMap.put(file2, offsets);
        LineOffsets lineOffsets = offsets;
        if (lineOffsets == null) {
            FileOffsetsManager.$$$reportNull$$$0(5);
        }
        return lineOffsets;
    }

    @NotNull
    private static LineOffsets loadLineOffsets(@NotNull VirtualFile file2) {
        LineOffsets lineOffsets;
        if (file2 == null) {
            FileOffsetsManager.$$$reportNull$$$0(6);
        }
        assert (!file2.getFileType().isBinary());
        try {
            byte[] bytes = file2.contentsToByteArray();
            Charset charset = LoadTextUtil.detectCharsetAndSetBOM(file2, bytes, file2.getFileType());
            byte[] bom = file2.getBOM();
            int bomLength = bom == null ? 0 : bom.length;
            lineOffsets = FileOffsetsManager.loadLineOffsets(bytes, charset, bomLength, file2.getModificationStamp());
        }
        catch (IOException e) {
            LineOffsets lineOffsets2 = new LineOffsets(file2.getModificationStamp(), new int[]{0}, new int[]{0});
            if (lineOffsets2 == null) {
                FileOffsetsManager.$$$reportNull$$$0(8);
            }
            return lineOffsets2;
        }
        if (lineOffsets == null) {
            FileOffsetsManager.$$$reportNull$$$0(7);
        }
        return lineOffsets;
    }

    @NotNull
    private static LineOffsets loadLineOffsets(@NotNull byte[] bytes, @NotNull Charset charset, int startOffset, long modificationStamp) {
        CharBuffer charBuffer;
        if (bytes == null) {
            FileOffsetsManager.$$$reportNull$$$0(9);
        }
        if (charset == null) {
            FileOffsetsManager.$$$reportNull$$$0(10);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, bytes.length - startOffset);
        try {
            charBuffer = charset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtilRt.EMPTY_CHAR_ARRAY);
        }
        LineOffsets lineOffsets = FileOffsetsManager.loadLineOffsets(charBuffer, modificationStamp);
        if (lineOffsets == null) {
            FileOffsetsManager.$$$reportNull$$$0(11);
        }
        return lineOffsets;
    }

    @NotNull
    private static LineOffsets loadLineOffsets(@NotNull CharBuffer buffer, long modificationStamp) {
        if (buffer == null) {
            FileOffsetsManager.$$$reportNull$$$0(12);
        }
        int dst = 0;
        int prev = 32;
        int crlfCount = 0;
        IntArrayList originalLineOffsets = new IntArrayList();
        IntArrayList convertedLineOffsets = new IntArrayList();
        originalLineOffsets.add(0);
        convertedLineOffsets.add(0);
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        for (int src = 0; src < length; ++src) {
            int c2 = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c2) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    originalLineOffsets.add(dst + crlfCount);
                    convertedLineOffsets.add(dst);
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        originalLineOffsets.set(originalLineOffsets.size() - 1, dst + ++crlfCount);
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    originalLineOffsets.add(dst + crlfCount);
                    convertedLineOffsets.add(dst);
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c2;
                        break;
                    }
                    buffer.put(dst++, (char)c2);
                }
            }
            prev = c2;
        }
        LineOffsets lineOffsets = new LineOffsets(modificationStamp, originalLineOffsets.toArray(), convertedLineOffsets.toArray());
        if (lineOffsets == null) {
            FileOffsetsManager.$$$reportNull$$$0(13);
        }
        return lineOffsets;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileOffsetsManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileOffsetsManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineOffsets";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLineOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalOffset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLineOffsets";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadLineOffsets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LineOffsets {
        private final long myFileModificationStamp;
        private final int[] myOriginalLineOffsets;
        private final int[] myConvertedLineOffsets;
        private final boolean myLineOffsetsAreTheSame;

        /*
         * WARNING - void declaration
         */
        LineOffsets(long modificationStamp, @NotNull int[] originalLineOffsets, @NotNull int[] nArray) {
            void convertedLineOffsets;
            if (originalLineOffsets == null) {
                LineOffsets.$$$reportNull$$$0(0);
            }
            if (nArray == null) {
                LineOffsets.$$$reportNull$$$0(1);
            }
            assert (((void)convertedLineOffsets).length > 0 && originalLineOffsets.length == ((void)convertedLineOffsets).length) : originalLineOffsets.length + " " + ((void)convertedLineOffsets).length;
            this.myFileModificationStamp = modificationStamp;
            this.myOriginalLineOffsets = originalLineOffsets;
            this.myConvertedLineOffsets = convertedLineOffsets;
            this.myLineOffsetsAreTheSame = originalLineOffsets[originalLineOffsets.length - 1] == convertedLineOffsets[((void)convertedLineOffsets).length - 1];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalLineOffsets";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "convertedLineOffsets";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileEditor/impl/FileOffsetsManager$LineOffsets";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

