/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=-2147483618)
public class ContentRootDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    public static final com.intellij.openapi.util.Key<Boolean> CREATE_EMPTY_DIRECTORIES = com.intellij.openapi.util.Key.create((String)"createEmptyDirectories");
    private static final Logger LOG = Logger.getInstance(ContentRootDataService.class);

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        Key key = ProjectKeys.CONTENT_ROOT;
        if (key == null) {
            ContentRootDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ContentRootDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(3);
        }
        ContentRootDataService.logUnitTest("Importing data. Data size is [" + toImport.size() + "]");
        if (toImport.isEmpty()) {
            return;
        }
        SourceFolderManager sourceFolderManager = SourceFolderManager.getInstance((Project)project);
        boolean isNewlyImportedProject = project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
        boolean forceDirectoriesCreation = false;
        DataNode projectDataNode = ExternalSystemApiUtil.findParent(toImport.iterator().next(), (Key)ProjectKeys.PROJECT);
        if (projectDataNode != null) {
            forceDirectoriesCreation = projectDataNode.getUserData(CREATE_EMPTY_DIRECTORIES) == Boolean.TRUE;
        }
        THashSet modulesToExpand = new THashSet();
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        ContentRootDataService.filterAndReportDuplicatingContentRoots((MultiMap<DataNode<ModuleData>, DataNode<ContentRootData>>)byModule, project);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module = (Module)((DataNode)entry.getKey()).getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module2 = module = module != null ? module : modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module == null) {
                LOG.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.importData(modelsProvider, sourceFolderManager, (Collection)entry.getValue(), module, forceDirectoriesCreation);
            if (!forceDirectoriesCreation && (!isNewlyImportedProject || projectData == null || !projectData.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalProjectPath((Module)module)))) continue;
            modulesToExpand.add(module);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesToExpand.isEmpty()) {
            for (Module module : modulesToExpand) {
                VirtualFile[] roots;
                String productionModuleName = modelsProvider.getProductionModuleName(module);
                if (productionModuleName != null && modulesToExpand.contains(modelsProvider.findIdeModule(productionModuleName)) || (roots = modelsProvider.getModifiableRootModel(module).getContentRoots()).length <= 0) continue;
                VirtualFile virtualFile = roots[0];
                ExternalSystemUtil.invokeLater(project, ModalityState.NON_MODAL, () -> StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    ProjectView projectView = ProjectView.getInstance(project);
                    projectView.changeViewCB("ProjectPane", null).doWhenProcessed(() -> projectView.selectCB(null, virtualFile, false));
                }));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void importData(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull SourceFolderManager sourceFolderManager, @NotNull Collection<? extends DataNode<ContentRootData>> data, @NotNull Module module, boolean forceDirectoriesCreation) {
        void var10_12;
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(4);
        }
        if (sourceFolderManager == null) {
            ContentRootDataService.$$$reportNull$$$0(5);
        }
        if (data == null) {
            ContentRootDataService.$$$reportNull$$$0(6);
        }
        if (module == null) {
            ContentRootDataService.$$$reportNull$$$0(7);
        }
        ContentRootDataService.logUnitTest("Import data for module [" + module.getName() + "], data size [" + data.size() + "]");
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        ContentEntry[] contentEntries = modifiableRootModel.getContentEntries();
        HashMap<String, ContentEntry> contentEntriesMap = new HashMap<String, ContentEntry>();
        ContentEntry[] contentEntryArray = contentEntries;
        int n = contentEntryArray.length;
        boolean bl = false;
        while (var10_12 < n) {
            ContentEntry contentEntry = contentEntryArray[var10_12];
            contentEntriesMap.put(contentEntry.getUrl(), contentEntry);
            ++var10_12;
        }
        sourceFolderManager.removeSourceFolders(module);
        THashSet importedContentEntries = ContainerUtil.newIdentityTroveSet();
        for (DataNode<ContentRootData> dataNode : data) {
            ContentRootData contentRoot = (ContentRootData)dataNode.getData();
            ContentEntry contentEntry = ContentRootDataService.findOrCreateContentRoot(modifiableRootModel, contentRoot.getRootPath());
            if (!importedContentEntries.contains(contentEntry)) {
                ContentRootDataService.removeSourceFoldersIfAbsent(contentEntry, contentRoot);
                importedContentEntries.add(contentEntry);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Importing content root '%s' for module '%s'", contentRoot.getRootPath(), module.getName()));
            }
            for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
                JpsModuleSourceRootType<?> type = ContentRootDataService.getJavaSourceRootType(externalSrcType);
                if (type == null) continue;
                for (ContentRootData.SourceRoot path : contentRoot.getPaths(externalSrcType)) {
                    ContentRootDataService.createSourceRootIfAbsent(sourceFolderManager, contentEntry, path, module, type, externalSrcType.isGenerated(), forceDirectoriesCreation);
                }
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.EXCLUDED)) {
                ContentRootDataService.createExcludedRootIfAbsent(contentEntry, path, module.getName(), module.getProject());
            }
            contentEntriesMap.remove(contentEntry.getUrl());
        }
        for (ContentEntry contentEntry : contentEntriesMap.values()) {
            modifiableRootModel.removeContentEntry(contentEntry);
        }
    }

    @Nullable
    private static JpsModuleSourceRootType<?> getJavaSourceRootType(ExternalSystemSourceType type) {
        switch (type) {
            case SOURCE: {
                return JavaSourceRootType.SOURCE;
            }
            case TEST: {
                return JavaSourceRootType.TEST_SOURCE;
            }
            case EXCLUDED: {
                return null;
            }
            case SOURCE_GENERATED: {
                return JavaSourceRootType.SOURCE;
            }
            case TEST_GENERATED: {
                return JavaSourceRootType.TEST_SOURCE;
            }
            case RESOURCE: {
                return JavaResourceRootType.RESOURCE;
            }
            case TEST_RESOURCE: {
                return JavaResourceRootType.TEST_RESOURCE;
            }
        }
        return null;
    }

    @NotNull
    private static ContentEntry findOrCreateContentRoot(@NotNull ModifiableRootModel model2, @NotNull String path) {
        ContentEntry[] entries;
        if (model2 == null) {
            ContentRootDataService.$$$reportNull$$$0(8);
        }
        if (path == null) {
            ContentRootDataService.$$$reportNull$$$0(9);
        }
        for (ContentEntry entry : entries = model2.getContentEntries()) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(path)) continue;
            ContentEntry contentEntry = entry;
            if (contentEntry == null) {
                ContentRootDataService.$$$reportNull$$$0(10);
            }
            return contentEntry;
        }
        ContentEntry contentEntry = model2.addContentEntry(VfsUtilCore.pathToUrl((String)path));
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(11);
        }
        return contentEntry;
    }

    private static Set<String> getSourceRoots(@NotNull ContentRootData contentRoot) {
        if (contentRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(12);
        }
        THashSet sourceRoots = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
            JpsModuleSourceRootType<?> type = ContentRootDataService.getJavaSourceRootType(externalSrcType);
            if (type == null) continue;
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(externalSrcType)) {
                if (path == null) continue;
                sourceRoots.add(path.getPath());
            }
        }
        return sourceRoots;
    }

    private static void removeSourceFoldersIfAbsent(@NotNull ContentEntry contentEntry, @NotNull ContentRootData contentRoot) {
        SourceFolder[] sourceFolders;
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(13);
        }
        if (contentRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(14);
        }
        Set<String> sourceRoots = ContentRootDataService.getSourceRoots(contentRoot);
        for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
            String url = sourceFolder.getUrl();
            String path = VfsUtilCore.urlToPath((String)url);
            if (sourceRoots.contains(path)) continue;
            contentEntry.removeSourceFolder(sourceFolder);
        }
    }

    private static void createSourceRootIfAbsent(@NotNull SourceFolderManager sourceFolderManager, @NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull Module module, @NotNull JpsModuleSourceRootType<?> sourceRootType, boolean generated, boolean createEmptyContentRootDirectories) {
        JavaSourceRootProperties properties;
        SourceFolder[] folders;
        if (sourceFolderManager == null) {
            ContentRootDataService.$$$reportNull$$$0(15);
        }
        if (entry == null) {
            ContentRootDataService.$$$reportNull$$$0(16);
        }
        if (root == null) {
            ContentRootDataService.$$$reportNull$$$0(17);
        }
        if (module == null) {
            ContentRootDataService.$$$reportNull$$$0(18);
        }
        if (sourceRootType == null) {
            ContentRootDataService.$$$reportNull$$$0(19);
        }
        ContentRootDataService.logUnitTest("create source root if absent entry.url=[" + entry.getUrl() + "] root.path=[" + root.getPath() + "] generated=[" + generated + "] createEmptyContentRootDirectories=[" + createEmptyContentRootDirectories + "]");
        for (SourceFolder folder : folders = entry.getSourceFolders()) {
            VirtualFile file2 = folder.getFile();
            if (file2 == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(root.getPath())) continue;
            JpsModuleSourceRootType folderRootType = folder.getRootType();
            if (JavaSourceRootType.SOURCE.equals(folderRootType) || sourceRootType.equals((Object)folderRootType)) {
                return;
            }
            if (JavaSourceRootType.TEST_SOURCE.equals(folderRootType) && JavaResourceRootType.TEST_RESOURCE.equals(sourceRootType)) {
                return;
            }
            entry.removeSourceFolder(folder);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Importing %s for content root '%s' of module '%s'", root, entry.getUrl(), module.getName()));
        }
        if (!createEmptyContentRootDirectories && !FileUtil.exists((String)root.getPath())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Source folder [" + root.getPath() + "] does not exist and will not be created, will add when dir is created");
            }
            ContentRootDataService.logUnitTest("Adding source folder listener to watch [" + root.getPath() + "] for creation in project [hashCode=" + module.getProject().hashCode() + "]");
            String url = VfsUtilCore.pathToUrl((String)root.getPath());
            String packagePrefix = StringUtil.notNullize((String)root.getPackagePrefix());
            sourceFolderManager.addSourceFolder(module, url, sourceRootType, packagePrefix, generated);
            return;
        }
        SourceFolder sourceFolder = entry.addSourceFolder(VfsUtilCore.pathToUrl((String)root.getPath()), sourceRootType);
        if (!StringUtil.isEmpty((String)root.getPackagePrefix())) {
            sourceFolder.setPackagePrefix(root.getPackagePrefix());
        }
        if (generated && (properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) != null) {
            properties.setForGeneratedSources(true);
        }
        if (createEmptyContentRootDirectories && !FileUtil.exists((String)root.getPath())) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                try {
                    VfsUtil.createDirectoryIfMissing((String)root.getPath());
                }
                catch (IOException e) {
                    LOG.warn(String.format("Unable to create directory for the path: %s", root.getPath()), (Throwable)e);
                }
            });
        }
    }

    private static void logUnitTest(String message) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info(message);
        }
    }

    private static void createExcludedRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull Project project) {
        if (entry == null) {
            ContentRootDataService.$$$reportNull$$$0(20);
        }
        if (root == null) {
            ContentRootDataService.$$$reportNull$$$0(21);
        }
        if (moduleName == null) {
            ContentRootDataService.$$$reportNull$$$0(22);
        }
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(23);
        }
        String rootPath = root.getPath();
        for (VirtualFile file2 : entry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(rootPath)) continue;
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Importing excluded root '%s' for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        }
        entry.addExcludeFolder(VfsUtilCore.pathToUrl((String)rootPath));
        if (!Registry.is((String)"ide.hide.excluded.files")) {
            ChangeListManager.getInstance((Project)project).addDirectoryToIgnoreImplicitly(rootPath);
        }
    }

    private static void filterAndReportDuplicatingContentRoots(@NotNull MultiMap<DataNode<ModuleData>, DataNode<ContentRootData>> moduleNodeToRootNodes, @NotNull Project project) {
        String notificationMessage;
        if (moduleNodeToRootNodes == null) {
            ContentRootDataService.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(25);
        }
        LinkedHashMap<String, DuplicateModuleReport> filter = new LinkedHashMap<String, DuplicateModuleReport>();
        for (Map.Entry entry : moduleNodeToRootNodes.entrySet()) {
            ModuleData moduleData = (ModuleData)((DataNode)entry.getKey()).getData();
            Collection crDataNodes = (Collection)entry.getValue();
            Iterator iterator = crDataNodes.iterator();
            while (iterator.hasNext()) {
                DataNode crDataNode = (DataNode)iterator.next();
                String rootPath = ((ContentRootData)crDataNode.getData()).getRootPath();
                DuplicateModuleReport report = filter.putIfAbsent(rootPath, new DuplicateModuleReport(moduleData));
                if (report == null) continue;
                report.addDuplicate(moduleData);
                iterator.remove();
                crDataNode.clear(true);
            }
        }
        Map toReport = filter.entrySet().stream().filter(e -> ((DuplicateModuleReport)e.getValue()).hasDuplicates()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (r1, r2) -> {
            LOG.warn("Unexpected duplicates in keys while collecting filtered reports");
            return r2;
        }, LinkedHashMap::new));
        if (!toReport.isEmpty() && (notificationMessage = ContentRootDataService.prepareMessageAndLogWarnings(toReport)) != null) {
            ContentRootDataService.showNotificationsPopup(project, toReport.size(), notificationMessage);
        }
    }

    @Nullable
    private static String prepareMessageAndLogWarnings(@NotNull Map<String, DuplicateModuleReport> toReport) {
        if (toReport == null) {
            ContentRootDataService.$$$reportNull$$$0(26);
        }
        String firstMessage = null;
        LOG.warn("Duplicating content roots detected.");
        for (Map.Entry<String, DuplicateModuleReport> entry : toReport.entrySet()) {
            String path = entry.getKey();
            DuplicateModuleReport report = entry.getValue();
            String message = String.format("Path [%s] of module [%s] was removed from modules [%s]", path, report.getOriginalName(), StringUtil.join(report.getDuplicatesNames(), (String)", "));
            if (firstMessage == null) {
                firstMessage = message;
            }
            LOG.warn(message);
        }
        return firstMessage;
    }

    private static void showNotificationsPopup(@NotNull Project project, int reportsCount, @NotNull String notificationMessage) {
        int extraReportsCount;
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(27);
        }
        if (notificationMessage == null) {
            ContentRootDataService.$$$reportNull$$$0(28);
        }
        if ((extraReportsCount = reportsCount - 1) > 0) {
            notificationMessage = notificationMessage + "<br>Also " + extraReportsCount + " more " + StringUtil.pluralize((String)"path", (int)extraReportsCount) + " " + (extraReportsCount == 1 ? "was" : "were") + " deduplicated. See idea log for details";
        }
        Notification notification = new Notification("Content root duplicates", "Duplicate content roots detected", notificationMessage, NotificationType.WARNING);
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolderManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNodeToRootNodes";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReport";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateContentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateContentRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceFoldersIfAbsent";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createSourceRootIfAbsent";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedRootIfAbsent";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "filterAndReportDuplicatingContentRoots";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "prepareMessageAndLogWarnings";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationsPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DuplicateModuleReport {
        private final ModuleData myOriginal;
        private final List<ModuleData> myDuplicates;

        public DuplicateModuleReport(@NotNull ModuleData original) {
            if (original == null) {
                DuplicateModuleReport.$$$reportNull$$$0(0);
            }
            this.myDuplicates = new ArrayList<ModuleData>();
            this.myOriginal = original;
        }

        public void addDuplicate(@NotNull ModuleData duplicate) {
            if (duplicate == null) {
                DuplicateModuleReport.$$$reportNull$$$0(1);
            }
            this.myDuplicates.add(duplicate);
        }

        public boolean hasDuplicates() {
            return !this.myDuplicates.isEmpty();
        }

        public String getOriginalName() {
            return this.myOriginal.getInternalName();
        }

        public Collection<String> getDuplicatesNames() {
            return ContainerUtil.map(this.myDuplicates, AbstractNamedData::getInternalName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicate";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService$DuplicateModuleReport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDuplicate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

