/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.ide.DataManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import java.awt.Component;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentSelectionModel
implements SelectionModel {
    private final JTextComponent myTextComponent;
    private final TextComponentEditor myEditor;

    public TextComponentSelectionModel(@NotNull JTextComponent textComponent, @NotNull TextComponentEditor textComponentEditor) {
        if (textComponent == null) {
            TextComponentSelectionModel.$$$reportNull$$$0(0);
        }
        if (textComponentEditor == null) {
            TextComponentSelectionModel.$$$reportNull$$$0(1);
        }
        this.myTextComponent = textComponent;
        this.myEditor = textComponentEditor;
    }

    public int getSelectionStart() {
        return this.myTextComponent.getSelectionStart();
    }

    @Nullable
    public VisualPosition getSelectionStartPosition() {
        return null;
    }

    public int getSelectionEnd() {
        return this.myTextComponent.getSelectionEnd();
    }

    @Nullable
    public VisualPosition getSelectionEndPosition() {
        return null;
    }

    @Nullable
    public String getSelectedText() {
        return this.myTextComponent.getSelectedText();
    }

    @Nullable
    public String getSelectedText(boolean allCarets) {
        return this.getSelectedText();
    }

    public int getLeadSelectionOffset() {
        int caretPosition = this.myTextComponent.getCaretPosition();
        int start2 = this.myTextComponent.getSelectionStart();
        int end = this.myTextComponent.getSelectionEnd();
        return caretPosition == start2 ? end : start2;
    }

    @Nullable
    public VisualPosition getLeadSelectionPosition() {
        return null;
    }

    public boolean hasSelection() {
        return this.myTextComponent.getSelectionStart() != this.myTextComponent.getSelectionEnd();
    }

    public boolean hasSelection(boolean anyCaret) {
        return this.hasSelection();
    }

    public void setSelection(int startOffset, int endOffset) {
        if (this.myTextComponent.getCaretPosition() == startOffset) {
            this.myTextComponent.setCaretPosition(endOffset);
            this.myTextComponent.moveCaretPosition(startOffset);
        } else {
            this.myTextComponent.setCaretPosition(startOffset);
            this.myTextComponent.moveCaretPosition(endOffset);
        }
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startOffset, endOffset);
    }

    public void removeSelection() {
        int position = this.myTextComponent.getCaretPosition();
        this.myTextComponent.select(position, position);
    }

    public void removeSelection(boolean allCarets) {
        this.removeSelection();
    }

    public void addSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            TextComponentSelectionModel.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            TextComponentSelectionModel.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void selectLineAtCaret() {
        SelectionModelImpl.doSelectLineAtCaret(this.myEditor.getCaretModel().getPrimaryCaret());
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.removeSelection();
        EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorSelectWord");
        handler2.execute((Editor)this.myEditor, null, DataManager.getInstance().getDataContext((Component)this.myEditor.getComponent()));
    }

    public void copySelectionToClipboard() {
        if (!(this.myTextComponent instanceof JPasswordField)) {
            EditorCopyPasteHelper.getInstance().copySelectionToClipboard((Editor)this.myEditor);
        }
    }

    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (blockStart == null) {
            TextComponentSelectionModel.$$$reportNull$$$0(4);
        }
        if (blockEnd == null) {
            TextComponentSelectionModel.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public int[] getBlockSelectionStarts() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public int[] getBlockSelectionEnds() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public TextAttributes getTextAttributes() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponentEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/textarea/TextComponentSelectionModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addSelectionListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeSelectionListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setBlockSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

